package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class Associative extends AssociativeFactory implements MappingsSamples {

	public static Statement PARTIAL_BINARY_OPERATION_ASSOCIATIVE;

	public static Statement PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE; // https://mathoverflow.net/questions/123614/on-the-notion-of-partial-semigroup

	public static Statement FLEXIBLE_BINARY_OPERATION;

	// Missing: Generalized associative law


	private Associative() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "associative property", null, "Assoziativgesetz", null);


			PARTIAL_BINARY_OPERATION_ASSOCIATIVE = associativePartialBinaryOperation(null);
			PARTIAL_BINARY_OPERATION_ASSOCIATIVE.setReferences(References.wikiEn("Associative_property"), References.wikiDe("Assoziativgesetz"),
					References.wikiEn("Partial_groupoid"));
			PARTIAL_BINARY_OPERATION_ASSOCIATIVE.be(multDotExtended);
			PARTIAL_BINARY_OPERATION_ASSOCIATIVE.setMain(Bool.definedAsEqualToMultiline(//
					associativePartialBinaryOperation(multDot), //
					Logic.forAllMultiline(Basics.commaSeparated(aElemA, bElemA, cElemA),
							Bool.andMultiline(//
							Bool.iff(Mappings.mappingDefinedAt(ab_c_), Mappings.mappingDefinedAt(a_bc_)), //
									Basics.proofline(Logic.equals(ab_c_, a_bc_), Basics.inCaseOf(Mappings.mappingDefinedAt(ab_c_)))))));
			definition(PARTIAL_BINARY_OPERATION_ASSOCIATIVE, "associative", null, "assoziativ",
					"Das Assoziativgesetz besagt, dass man Klammern vertauschen kann, falls die Operationen auf den Werten definiert sind. Bei totalen Abbildungen vereinfacht es sich zur Aussage (a∙b)∙c = a∙(b∙c)");
			PARTIAL_BINARY_OPERATION_ASSOCIATIVE.setExamples(//
					Basics.comment("Die Addition auf den (natürlichen, reellen, ...) Zahlen ist assoziativ."), //
					Basics.comment("Die Multiplikation auf den (natürlichen, reellen, ...) Zahlen ist assoziativ.")//
			);

			PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE = stronglyAssociativePartialBinaryOperation(null);
			PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE
					.setReferences(References.url("https://mathoverflow.net/questions/123614/on-the-notion-of-partial-semigroup"));
			PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE.be(associativePartialBinaryOperation(multDotExtended), aElemA, bElemA, cElemA);
			PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE.setMain(Bool.definedAsEqualTo(//
					stronglyAssociativePartialBinaryOperation(multDot), //
					Bool.implies(Bool.and(Mappings.mappingDefinedAt(ab_), Mappings.mappingDefinedAt(bc_)), Mappings.mappingDefinedAt(ab_c_))));
			definition(PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE, "strongly associative", null, "stark assoziativ",
					"(Prüfen, ob Übersetzung korrent?). Die Vertauschung der Klammerregeln ergibt sich dann aus der Assoziativität.");
			PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE.setExamples(//
					Basics.comment("Die Addition auf den (natürlichen, reellen, ...) Zahlen ist stark assoziativ."), //
					Basics.comment("Die Multiplikation auf den (natürlichen, reellen, ...) Zahlen ist stark assoziativ.")//
			);

			FLEXIBLE_BINARY_OPERATION = flexibleBinaryOperation(null);
			FLEXIBLE_BINARY_OPERATION.setReferences(References.wikiEn("Flexible_algebra"), References.wikiDe("Flexible_Algebra"));
			FLEXIBLE_BINARY_OPERATION.be(multDotTotalExtended);
			FLEXIBLE_BINARY_OPERATION.setMain(Bool.definedAsEqualTo(//
					flexibleBinaryOperation(multDotTotal), //
					Logic.forAll(Basics.commaSeparated(aElemA, bElemA), Logic.equals(ab_a_, a_ba_))));
			definition(FLEXIBLE_BINARY_OPERATION, "flexible operation", null, "flexible Operation", null);
			FLEXIBLE_BINARY_OPERATION.setExamples(//
					Basics.comment("Jede assoziative totale Operation ist flexibel. Insbesondere: "), //
					Basics.comment("Die Addition auf den (natürlichen, reellen, ...) Zahlen ist stark flexibel."), //
					Basics.comment("Die Multiplikation auf den (natürlichen, reellen, ...) Zahlen ist stark flexibel.")//
			);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(PARTIAL_BINARY_OPERATION_ASSOCIATIVE, PARTIAL_BINARY_OPERATION_STRONGLY_ASSOCIATIVE, FLEXIBLE_BINARY_OPERATION),
				(List) Arrays.asList());
	}

}
