package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class AssociativeFactory extends Statements {

	protected static final AssociativeFactory SINGLETON = new AssociativeFactory();

	protected AssociativeFactory() {
		super("associative", Mappings.SINGLETON);

	}


	public static Statement associativePartialBinaryOperation(Statement partialBinaryOperation) {
		return SINGLETON.normal("associativePartialBinaryOperation", partialBinaryOperation);
	}

	public static Statement stronglyAssociativePartialBinaryOperation(Statement partialBinaryOperation) {
		return SINGLETON.normal("stronglyAssociativePartialBinaryOperation", partialBinaryOperation);
	}

	public static Statement flexibleBinaryOperation(Statement binaryOperation) {
		return SINGLETON.normal("flexibleBinaryOperation", binaryOperation);
	}

}
