package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.Write;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class CanonicalProjection extends CanonicalProjectionFactory implements SetTheorySamples {



	public static Statement PROJECTION;


	private CanonicalProjection() {

	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "projection ", null, "kanonische Projektion", null);
			titleText(SINGLETON.unit(1), "projection", null, "kanonische Projektion", null);


			PROJECTION = projection(null, null, null);
			PROJECTION.setReferences(wikiDe("Projektion_(Mengenlehre)"), wikiEn("Projection_(set_theory)"), ml2("2.6.6"));
			Object[] piIndexed = { Basics.MANTISSA_INDEX_EXPONENT, pi, THIRD_VARIABLE, Basics.EMPTY };

			MathMLGenerator.displayRule(PROJECTION,
					WriteExtended.shortDefault(//
							WriteAfterStatementTransformation.ruleTransformation(piIndexed), //
							WriteAfterStatementTransformation.ruleTransformationWithName(Mappings.EXPLICIT_MAPPING, piIndexed, FIRST_VARIABLE, SECOND_VARIABLE,
									Tuples.tuple(x_1, DOTS, x_n), new Object[] { Basics.MANTISSA_INDEX_EXPONENT, x, THIRD_VARIABLE, Basics.EMPTY })));


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public static StudyUnit createStudyUnit1() {
		return new StudyUnit(SINGLETON, 1, (List) Arrays.asList(), (List) Arrays.asList());
	}


}
