package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class Commutative extends CommutativeFactory implements MappingsSamples {


	public static Statement COMMUTATIVE_PARTIAL_BINARY_OPERATION;

	public static Statement COMMUTATIVE_IMPLIES_FLEXIBLE;

	private Commutative() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "commutative property", null, "Kommutativgesetz", null);



			COMMUTATIVE_PARTIAL_BINARY_OPERATION = commutativePartialBinaryOperation(null);
			COMMUTATIVE_PARTIAL_BINARY_OPERATION.setReferences(References.wikiEn("Commutative_property"), References.wikiDe("Kommutativgesetz"),
					References.wikiDe("Pseudo-Magma#Rechengesetze"));
			COMMUTATIVE_PARTIAL_BINARY_OPERATION.be(multDotExtended);
			COMMUTATIVE_PARTIAL_BINARY_OPERATION.setMain(Bool.definedAsEqualToMultiline(//
					commutativePartialBinaryOperation(multDot), //
					Logic.forAllMultiline(Basics.commaSeparated(aElemA, bElemA),
							Bool.andMultiline(//
									Bool.iff(Mappings.mappingDefinedAt(ab_), Mappings.mappingDefinedAt(ba_)), //
									Basics.proofline(Logic.equals(ab_, ba_), Basics.inCaseOf(Mappings.mappingDefinedAt(ab_)))))//
			));
			definition(COMMUTATIVE_PARTIAL_BINARY_OPERATION, "commutative operation", null, "kommutative Operation",
					"Das Kommutativgesetz sagt, dass man die Operanden vertauschen kann, falls die Operation auf den Werten definiert ist. Bei totalen Abbildungen vereinfacht es sich zu:",
					Logic.forAll(Basics.commaSeparated(aElemA, bElemA), Logic.equals(ab_, ba_)));
			COMMUTATIVE_PARTIAL_BINARY_OPERATION.setExamples(//
					Basics.comment("Die Addition auf den (natürlichen, reellen, ...) Zahlen ist kommutativ"), //
					Basics.comment("Die Multiplikation auf den (natürlichen, reellen, ...) Zahlen ist kommutativ"), //
					Basics.blankSeparated("Auf der Booleschen Menge", Bool.BOOLEAN_SET, " sind z.B. die UND (", Bool.AND_RELATION, "), ODER (",
							Bool.OR_RELATION, ") und XOR-Operationen kommutativ.")//
			);

			COMMUTATIVE_IMPLIES_FLEXIBLE = SINGLETON.normal("COMMUTATIVE_IMPLIES_FLEXIBLE");
			COMMUTATIVE_IMPLIES_FLEXIBLE.setMain(Bool.implies(commutativePartialBinaryOperation(multDotTotal), Associative.flexibleBinaryOperation(multDotTotal)));
			lemma(COMMUTATIVE_IMPLIES_FLEXIBLE, null, null, "kommutative Operationen sind flexibel", null);
			COMMUTATIVE_IMPLIES_FLEXIBLE.setProofs(Logic.equals(a_ba_, ba_a_, ab_a_));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(COMMUTATIVE_PARTIAL_BINARY_OPERATION, COMMUTATIVE_IMPLIES_FLEXIBLE),
				(List) Arrays.asList());
	}

}
