package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class CommutativeFactory extends Statements {

	protected static final CommutativeFactory SINGLETON = new CommutativeFactory();

	protected CommutativeFactory() {
		super("commutative", Mappings.SINGLETON);

	}



	public static Statement commutativePartialBinaryOperation(Statement binaryOperation) {
		return SINGLETON.normal("commutativeBinaryOperation", binaryOperation);
	}

}
