package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetMappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.IdentityFunction;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Composition;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class CompositionOfMappings extends CompositionOfMappingsFactory implements MappingsSamples {


	public static Statement COMPOSITE;

	public static Statement COMPOSITION_WITH_ID_1;

	public static Statement COMPOSITION_WITH_ID_2;

	public static Statement ASSOCIATIVE;

	private CompositionOfMappings() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), null, null, "Komposition von Abbildungen", null);

			Statement g_f = composite(g, f);

			COMPOSITE = composite(null, null);
			COMPOSITE.setReferences(References.ml2("2.6.8, 2.6.9"));
			COMPOSITE.be(Basics.notSeparated(Mappings.mappingsTuple(g, B, G, C), ",", Mappings.mappingsTuple(f, A, F, B), ("(partielle) Abbildungen")));
			COMPOSITE.main(Mappings.mappingsTuple(g_f, A, Composition.composite(G, F), C));
			definition(COMPOSITE, null, null, "Komposition zweier Abbildungen",
					"Diese Komposition zweier Abbildungen ist wieder eine (partielle) Abbildung. Sie wird auch Verknüpfung, Verkettung, Hintereinanderschaltung oder Produkt genannt. ",
					Logic.equals(Mappings.functionValueAt(Logic.bracket(g_f), x), Mappings.functionValueAt(g, f_of_x)),
					" (falls f(x) definiert und g(f(x)) definiert)");
			MathMLGenerator.displayRule(COMPOSITE, new WriteOperation("∘"));
			COMPOSITE.setProofs(Basics.MISSING_PROOF);

			COMPOSITION_WITH_ID_1 = SINGLETON.normal("COMPOSITION_WITH_ID_1");
			COMPOSITION_WITH_ID_1.setReferences(ml2("2.6.11"));
			COMPOSITION_WITH_ID_1.be(f_A__B);
			COMPOSITION_WITH_ID_1.main(Logic.equals(composite(f, id_A), f));
			lemma(COMPOSITION_WITH_ID_1, null, null, "Komposition mit identischer Abbildung (1)", null);
			COMPOSITION_WITH_ID_1.setProofs(Basics.MISSING_PROOF);

			COMPOSITION_WITH_ID_2 = SINGLETON.normal("COMPOSITION_WITH_ID_2");
			COMPOSITION_WITH_ID_2.setReferences(ml2("2.6.11"));
			COMPOSITION_WITH_ID_2.be(f_A__B);
			COMPOSITION_WITH_ID_2.main(Logic.equals(composite(id_B, f), f));
			lemma(COMPOSITION_WITH_ID_2, null, null, "Komposition mit identischer Abbildung (2)", null);
			COMPOSITION_WITH_ID_2.setProofs(Basics.MISSING_PROOF);

			ASSOCIATIVE = SINGLETON.normal("ASSOCIATIVE");
			ASSOCIATIVE.setReferences(ml2("2.6.11"));
			ASSOCIATIVE.be(f_A__B, g_B__C, h_C__D);
			ASSOCIATIVE.main(Logic.equals(composite(Logic.bracket(composite(h, g)), f), composite(h, Logic.bracket(composite(g, f)))));
			lemma(ASSOCIATIVE, null, null, "Assoziativität der Komposition", null);
			ASSOCIATIVE.setProofs(Basics.MISSING_PROOF);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(COMPOSITE, COMPOSITION_WITH_ID_1, COMPOSITION_WITH_ID_2, ASSOCIATIVE, SetMappings.COMPOSITION, SetMappings.CATEGORY),
				(List) Arrays.asList());
	}

}
