package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Composition;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class CompositionOfMappingsFactory extends Statements {

	protected static final CompositionOfMappingsFactory SINGLETON = new CompositionOfMappingsFactory();

	protected CompositionOfMappingsFactory() {
		super("composition of mappings", Composition.SINGLETON);

	}

	public static Statement composite(Statement mapping1, Statement mapping2) {
		return SINGLETON.normal("composite", mapping1, mapping2);
	}



}
