package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.Write;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class ConstantFunction extends ConstantFunctionFactory implements SetTheorySamples {



	public static Statement CONSTANT_MAPPING;


	private ConstantFunction() {

	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "constant function ", null, "konstante Abbildung", null);
			titleText(SINGLETON.unit(1), "constant function ", null, "konstante Abbildung", null);


			CONSTANT_MAPPING = constantMapping(null, null, null);
			// TODO missing definition FIRST_VARIABLE subset SECOND variable
			CONSTANT_MAPPING.setReferences(wikiDe("Konstante_Funktion"), wikiEn("Constant_function"), ml2("2.6.6"));
			// TODO: do this per transformation into a mapping
			Object[] kIndexed = { Basics.MANTISSA_INDEX_EXPONENT, k, new Object[] { Basics.COMMA_SEPARATED, FIRST_VARIABLE, SECOND_VARIABLE, THIRD_VARIABLE },
					Basics.EMPTY };

			MathMLGenerator.displayRule(CONSTANT_MAPPING,
					WriteExtended.shortDefault(//
							WriteAfterStatementTransformation.ruleTransformation(kIndexed), //
							WriteAfterStatementTransformation.ruleTransformationWithName(Mappings.EXPLICIT_MAPPING, kIndexed, FIRST_VARIABLE, SECOND_VARIABLE,
									x, THIRD_VARIABLE)));


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public static StudyUnit createStudyUnit1() {
		return new StudyUnit(SINGLETON, 1, (List) Arrays.asList(), (List) Arrays.asList());
	}


}
