package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Composition;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.CompositionFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.InverseRelation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Relation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinaryFactory;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.Write;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class IdentityFunction extends IdentityFunctionFactory implements SetTheorySamples {

	private static Statement id = Basics.comment("id");
	private static Statement in = Basics.comment("in");
	private static Statement delta = Basics.comment("∆");

	public static Statement IDENTITY_RELATION;

	public static Statement ID_;

	public static Statement INCLUSION_MAPPING;

	public static Statement INVERSE_OF_IDENTITY_RELATION_IS_ID;

	public static Statement COMPOSITION;

	public static Statement IDENTITY_RELATION_IS_RIGHT_UNIQUE;
	public static Statement IDENTITY_RELATION_IS_LEFT_UNIQUE;
	public static Statement IDENTITY_RELATION_IS_1_TO_1;

	private IdentityFunction() {

	}

	static {
		try {
			titleText(SINGLETON.unit(1), "identity function ", "identity relation, identity map, identity transformation", "identische Abbildung", null);

			Statement idA = idRelation(A);

			Write writeId = WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, id, FIRST_VARIABLE, "");
			Write writeIn = WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, in,
					new Object[] { Basics.COMMA_SEPARATED, FIRST_VARIABLE, SECOND_VARIABLE }, "");
			Write writeDelta = WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, delta, FIRST_VARIABLE, "");
			Write writeXElementOf = WriteAfterStatementTransformation.ruleTransformation(ClassesSets.ELEMENT_OF, Basics.comment("x"), FIRST_VARIABLE);

			IDENTITY_RELATION = idRelation(null);
			IDENTITY_RELATION.setReferences(References.wikiEn("Identity_function"), References.wikiDe("Identische_Abbildung"),
					References.wikibooksDe("Mathematik:_Analysis:_Grundlagen:_Relationen"), References.ml1("2.2.6"));
			MathMLGenerator.displayRule(IDENTITY_RELATION,
					WriteExtended.shortDefault(writeDelta, writeDelta, new WriteMulti(writeDelta, ":={(x,x)| ", writeXElementOf, "}")));

			ID_ = id(null);
			// TODO missing definition
			ID_.setReferences(ml2("2.6.6"));
			// TODO: do this per transformation into a mapping
			// MathMLGenerator.displayRule(ID_, WriteAfterStatementTransformation.ruleTransformation(Mappings.MAPPING, FIRST_VARIABLE,
			// delta/* missing index FIRST_VARIABLE */, FIRST_VARIABLE)); // missing name
			MathMLGenerator.displayRule(ID_, WriteExtended.shortDefault(writeId, new WriteMulti(writeId, ":", FIRST_VARIABLE, "—>", FIRST_VARIABLE),
					new WriteMulti(writeId, ":", FIRST_VARIABLE, "—>", FIRST_VARIABLE, TextBoostUtils.NON_BREAKING_SPACE, " x Ⱶ─>x")));


			INCLUSION_MAPPING = inclusionMapping(null, null);
			// TODO missing definition FIRST_VARIABLE subset SECOND variable
			INCLUSION_MAPPING.setReferences(ml2("2.6.6"));
			// TODO: do this per transformation into a mapping
			MathMLGenerator.displayRule(INCLUSION_MAPPING,
					WriteExtended.shortDefault(writeId, new WriteMulti(writeIn, ":", FIRST_VARIABLE, "—>", SECOND_VARIABLE),
							new WriteMulti(writeIn, ":", FIRST_VARIABLE, "—>", SECOND_VARIABLE, TextBoostUtils.NON_BREAKING_SPACE, " x Ⱶ─>x")));

			INVERSE_OF_IDENTITY_RELATION_IS_ID = SINGLETON.normal("INVERSE_OF_IDENTITY_RELATION_IS_ID");
			INVERSE_OF_IDENTITY_RELATION_IS_ID.setReferences(References.ml1("2.3.3"));
			INVERSE_OF_IDENTITY_RELATION_IS_ID.be(classA);
			INVERSE_OF_IDENTITY_RELATION_IS_ID.main(Logic.equals(InverseRelation.inverse(Logic.bracket(idA)), idA));
			lemma(INVERSE_OF_IDENTITY_RELATION_IS_ID, null, null, "inverse Relation der identischen Abbildung ist wieder identische Abbildung", null);
			INVERSE_OF_IDENTITY_RELATION_IS_ID.setProofs(Logic.equalsMultiline(//
					InverseRelation.inverse(Logic.bracket(idA)), ClassesSets.classByPredicate(b_a, ClassesSets.elementOf(a_b, idA)), //
					ClassesSets.classByPredicate(b_a, Bool.and(Logic.equals(a, b), aElemA, bElemA)), //
					ClassesSets.classByPredicate(a_a, aElemA), //
					idA
			//
			));

			COMPOSITION = SINGLETON.normal("COMPOSITION");
			COMPOSITION.setReferences(References.ml1("2.3.9"));
			COMPOSITION.be(Relation.binary(R));
			COMPOSITION.main(Logic.equals(//
					Composition.composite(R, idRelation(RelationBinary.domain(R))), R, Composition.composite(idRelation(RelationBinary.image(R)), R)) //
			);
			lemma(COMPOSITION, null, null, "Komposition mit id ist Originalrelation.", null);
			COMPOSITION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(a_b, R), //
					Bool.and(ClassesSets.elementOf(a_b, R), ClassesSets.elementOf(a, RelationBinary.domain(R))), //
					Bool.and(ClassesSets.elementOf(a_b, R), ClassesSets.elementOf(a_a, idRelation(RelationBinary.domain(R)))), //
					Bool.and(ClassesSets.elementOf(a_b, CompositionFactory.composite(R, idRelation(RelationBinary.domain(R))))) //

			));

			IDENTITY_RELATION_IS_RIGHT_UNIQUE = SINGLETON.normal("IDENTITY_RELATION_IS_RIGHT_UNIQUE");
			IDENTITY_RELATION_IS_RIGHT_UNIQUE.setReferences(References.ml1("2.4.7"));
			IDENTITY_RELATION_IS_RIGHT_UNIQUE.be(setA);
			IDENTITY_RELATION_IS_RIGHT_UNIQUE.main(RelationBinaryFactory.rightUnique(idRelation(A)));
			lemma(IDENTITY_RELATION_IS_RIGHT_UNIQUE, null, null, "Gleichheitsrelation ist rechtseindeutig", null);
			IDENTITY_RELATION_IS_RIGHT_UNIQUE.setProofs(Bool.impliesMultiline( //
					Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a, b_1), idA), ClassesSets.elementOf(Tuples.tuple(a, b_2), idA)), //
					Bool.and(Logic.equals(a, b_1), Logic.equals(a, b_2)), //
					Logic.equals(b_1, a, b_2)
			//
			));

			IDENTITY_RELATION_IS_LEFT_UNIQUE = SINGLETON.normal("IDENTITY_RELATION_IS_LEFT_UNIQUE");
			// IDENTITY_RELATION_IS_LEFT_UNIQUE.setReferences(References.ml1("2.4.7"));
			IDENTITY_RELATION_IS_LEFT_UNIQUE.be(setA);
			IDENTITY_RELATION_IS_LEFT_UNIQUE.main(RelationBinaryFactory.leftUnique(idA));
			lemma(IDENTITY_RELATION_IS_LEFT_UNIQUE, null, null, "Gleichheitsrelation ist linkseindeutig", null);
			IDENTITY_RELATION_IS_LEFT_UNIQUE.setProofs(Bool.impliesMultiline(//
					Basics.comment("Sei die Klasse A beliebig"),//
					Logic.forAll(
							bElemB,
									Logic.forAll(ClassesSets.elementOf(Basics.commaSeparated(a_1, a_2), A),
											Bool.impliesMulti(
											Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a_1, b), idA),
													ClassesSets.elementOf(Tuples.tuple(a_2, b), idA)),
											Logic.bracket(Bool.and(Logic.equals(a_1, b), Logic.equals(a_2, b))),
											Logic.equals(a_1, b, a_2)))))
					
					
					);

			IDENTITY_RELATION_IS_1_TO_1 = SINGLETON.normal("IDENTITY_RELATION_IS_1_TO_1");
			// IDENTITY_RELATION_IS_1_TO_1.setReferences(References.ml1("2.4.7"));
			IDENTITY_RELATION_IS_1_TO_1.be(setA);
			IDENTITY_RELATION_IS_1_TO_1.main(RelationBinaryFactory.one2one(idRelation(A)));
			lemma(IDENTITY_RELATION_IS_1_TO_1, null, null, "Gleichheitsrelation ist eineindeutig", null);
			IDENTITY_RELATION_IS_1_TO_1
					.setProofs(Basics.comment("Trivial, da bereits bewiesen wurde, dass die Gleichheitsrelation linkseindeutig und rechtseindeutig ist."));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public static StudyUnit createStudyUnit1() {
		return new StudyUnit(SINGLETON, 1, (List) Arrays.asList(), Arrays.asList(ID_));
	}

	public static StudyUnit createStudyUnit0() {
		return new StudyUnit(SINGLETON, 0, (List) Arrays.asList(), (List) Arrays.asList());
	}

}
