package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class JectiveFunctions extends JectiveFunctionsFactory implements SetTheorySamples {


	public static Statement INJECTIVE;

	public static Statement SURJECTIVE;

	public static Statement BIJECTIVE;

	private JectiveFunctions() {

	}

	static {
		try {
			titleText(SINGLETON.unit(1), "...jective functions", null, "...jektive Funktionen", null);
			
			Statement mapping_f = Mappings.mapping(f, A, F, B);

			INJECTIVE = injective(null);
			INJECTIVE.setReferences(wikiDe("Surjektive_Funktion"), wikiEn("Surjective_function"));
			INJECTIVE.be(mapping_f);
			INJECTIVE.setMain(Bool.definedAsEqualTo(injective(f), Logic.forAll(ClassesSets.elementOf(Basics.commaSeparated(x_1, x_2), A),
					Bool.implies(Logic.equals(Mappings.functionValueAt(f, x_1), Mappings.functionValueAt(f, x_2)), Logic.equals(x_1, x_2)))));
			definition(INJECTIVE, "injective", null, "injektiv",
					"Unterschiedliche Ausgangswerte haben unterschiedliche Funktionswerte. Die Funktion der Abbildung ist linkseindeutig.");

			SURJECTIVE = surjective(null);
			SURJECTIVE.setReferences(wikiDe("Injektive_Funktion"), wikiEn("Injective_function"));
			SURJECTIVE.be(mapping_f);
			SURJECTIVE.setMain(Bool.definedAsEqualTo(surjective(f), Logic.forAllExists(bElemB, aElemA, Logic.equals(Mappings.functionValueAt(f, a), b))));
			definition(SURJECTIVE, "surjective", null, "surjektiv",
					"Jedes Element des Wertebereichs wird von der Funktion angenommen. f(A) = B. Die Funktion der Abbildung ist rechtstotal (surjektiv).");

			BIJECTIVE = bijective(null);
			BIJECTIVE.setReferences(wikiDe("Bijektive_Funktion"), wikiEn("Bijection"), ml1("2.5.6"));
			BIJECTIVE.be(mapping_f);
			BIJECTIVE.setMain(Bool.definedAsEqualTo(bijective(f), Bool.and(injective(f), surjective(f))));
			definition(BIJECTIVE, "bijective", null, "bijektiv", "Die zugrundeliegende Funktion ist eineindeutig und surjektiv.");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				(List) Arrays.asList(INJECTIVE, SURJECTIVE, BIJECTIVE), (List) Arrays.asList());
	}

}
