package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;

/**
 * factory for in/sur/bi-jective functions.
 * 
 * @author cbauer
 *
 */
public class JectiveFunctionsFactory extends Statements {

	protected static final JectiveFunctionsFactory SINGLETON = new JectiveFunctionsFactory();

	protected JectiveFunctionsFactory() {
		super("...jective functions", Mappings.SINGLETON);
	}

	public static Statement injective(Statement function) {
		return SINGLETON.normal("injective", function);
	}

	public static Statement surjective(Statement function) {
		return SINGLETON.normal("surjective", function);
	}

	public static Statement bijective(Statement function) {
		return SINGLETON.normal("bijective", function);
	}

}
