package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import java.util.Arrays;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetMappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SubsetFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Difference;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleStatementCreator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.Write;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class Mappings extends MappingsFactory implements MappingsSamples {

	public static Statement ELEMENT_MAPPED_TO;
	public static Statement PARTIAL_MAPPING;
	public static Statement MAPPING_DEFINED_AT;
	public static Statement MAPPINGS_TUPLE;
	public static Statement MAPPING;
	public static Statement EXPLICIT_MAPPING;
	public static Statement MAPPING_FROM_PARTIAL_MAPPING;
	public static Statement DOMAIN;
	public static Statement FUNCTION_VALUE_AT;
	public static Statement IMAGE;
	public static Statement IMAGE_OF_SUBSET_IS_SUBSET;
	public static Statement IMAGE_OF_UNION_IS_UNION;
	public static Statement IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS;
	public static Statement IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE;

	public static Statement PREIMAGE;
	public static Statement PREIMAGE_OF_SUBSET_IS_SUBSET;
	public static Statement PREIMAGE_OF_UNION_IS_UNION;
	public static Statement PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS;
	public static Statement PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE;

	public static Statement MAPPING_IS_PARTIAL_MAPPING;
	public static Statement MAPPING_EQUALITY;

	public static Statement OPERATION;
	public static Statement INNER_OPERATION;
	public static Statement PARTIAL_BINARY_OPERATION;
	public static Statement INFIX_VALUE;
	public static Statement BINARY_OPERATION;
	// public static Statement N_ARY_FROM_BINARY_OPERATION;
	public static Statement PARTIAL_HETEROGEN_OPERATION_ON_CLASS_SYSTEM;
	public static Statement HETEROGEN_OPERATION_ON_CLASS_SYSTEM;

	private Mappings() {

	}

	static {
		try {


			String elementArrow = "Ⱶ─>";

			titleText(SINGLETON.getCategory(), "operations", null, "Abbildungen/Operationen", null);

			titleText(SINGLETON.unit(1), "operations ", null, "Abbildungen/Operationen",
					"In der Literatur erfolgt nicht immer eine Unterscheidung zwischen Funktionen (als spezielle Relationen) und Abbildungen bzw. Operationen.");

			ELEMENT_MAPPED_TO = elementMappedTo(null, null);
			MathMLGenerator.displayRule(ELEMENT_MAPPED_TO, new WriteMulti(FIRST_VARIABLE, elementArrow, SECOND_VARIABLE));

			PARTIAL_MAPPING = partialMapping(null, null, null, null);
			PARTIAL_MAPPING.setReferences(wikiDe("Partielle_Funktion"), wikiEn("Partial_function"));
			PARTIAL_MAPPING.be(ClassesSets.clasz(A), ClassesSets.clasz(B), RelationBinary.partialFunction(F));
			Statement partialMapping = partialMapping(f, A, F, B);
			partialMapping.setDisplayLevel(EXTENDED);
			Statement partialMappingShort = partialMapping(f, A, F, B);
			partialMappingShort.setDisplayLevel(SHORT);
			PARTIAL_MAPPING.main(Bool.definedAsEqualTo(partialMapping,
					Bool.and(Subset.subclass(RelationBinary.domain(F), A), Subset.subclass(RelationBinary.image(F), B))));
			definition(PARTIAL_MAPPING, null, null, "partielle Abbildung", "Formal ist die partielle Abbildung ", f, "  als Tripel ",
					mappingsTuple(f, A, F, B), " definiert. Für dieses Tupel schreibt man ", partialMapping,
					" oder abkürzend (ohne F zu erwähnen) ", partialMapping(f, A, F, B),
					". In der Literatur erfolgt nicht zwingend eine Unterscheidung zwischen partieller Funktion und partieller Abbildung. Der Bild von x (Wert der Abbildung f) ist definiert als der Funktionswert an dieser Stelle ",
					Logic.definedAs(f_of_x, RelationBinary.functionValueAt(F, x)), ". Ist  ", Subset.subclass(A_1, A), " so ist das Bild von ", A_1,
					" definiert als ", Logic.definedAs(functionValueAt(f, A_1), RelationBinary.functionValueAt(F, A_1)));
			MathMLGenerator.displayRule(PARTIAL_MAPPING, WriteExtended.defaultExtended(new WriteMulti(NAME, ":", FIRST_VARIABLE, "-->", THIRD_VARIABLE),
					new WriteMulti(NAME, ":", FIRST_VARIABLE, "-->", THIRD_VARIABLE, TextBoostUtils.NON_BREAKING_SPACE + " x " + elementArrow, SECOND_VARIABLE,
							"(x)")));

			/**
			 * A mapping is defined for given arguments. The arguments are element of the domain of the mapping
			 */
			MAPPING_DEFINED_AT = mappingDefinedAt(null);
			definition(MAPPING_DEFINED_AT, null, null, "definiert", null);


			DOMAIN = domain(null);
			DOMAIN.setReferences(wikiDe("Definitionsmenge"), wikiEn("Domain_of_a_function"), wikiEn("Partial_function#Domain_of_a_partial_function"));
			DOMAIN.be(partialMapping);
			DOMAIN.main(Logic.definedAs(domain(partialMappingShort), RelationBinary.domain(F)));
			definition(DOMAIN, "domain (of definition)", null, "Definitionsbereich",
					"Der Definitionsbereich einer partiellen Abbildung ist der Definitionsbereich der zugrundeliegenden partiellen Funktion.");
			MathMLGenerator.displayRule(DOMAIN, new WriteOperation("D(", ", ", ")"));

			FUNCTION_VALUE_AT = functionValueAt(null, null);
			MathMLGenerator.displayRule(FUNCTION_VALUE_AT, new WriteMulti(FIRST_VARIABLE, "(", SECOND_VARIABLE, ")"));

			IMAGE = image(null, null);
			IMAGE.be(f_A__Bextended,
					Basics.blankSeparated(ClassesSets.elementOf(x, RelationBinary.domain(F)), "bzw. ", Subset.subclass(x, RelationBinary.domain(F))));
			IMAGE.main(Logic.definedAs(f_of_x, RelationBinary.functionValueAt(F, x)));
			MathMLGenerator.displayRule(IMAGE, new WriteMulti(FIRST_VARIABLE, "(", SECOND_VARIABLE, ")"));
			definition(IMAGE, null, null, "Bild",
					"Das Bild an einer Stelle bzw. einer Teilmenge ist definiert als das entsprechende Bild der zur Abbildung gehörenden Funktion. Bei einem Einzelwert ist das Bild ebenfalls nur ein Element, bei einer Teilklasse/-menge ist das Bild ebenfalls eine Klasse/Menge. Insofern besteht ein (formaler) Unterschied zwischen  ",
					Logic.equals(functionValueAt(f, a), b), " und ",
					Logic.equals(functionValueAt(f, ClassesSets.explicitSetWithoutName(a)), ClassesSets.explicitSetWithoutName(b)),
					"(für geeignete a und b). Manchmal wird bereits in der Schreibweise zwischen dem Bild eines einzelnen Elements f(x) und dem Bild einer Teilmenge f[x] unterschieden.");
			
			IMAGE_OF_SUBSET_IS_SUBSET = SINGLETON.normal("IMAGE_OF_SUBSET_IS_SUBSET");
			IMAGE_OF_SUBSET_IS_SUBSET.setReferences(ml2("2.6.20"));
			IMAGE_OF_SUBSET_IS_SUBSET.be(f_A__B, XsubclassA, YsubclassA);
			IMAGE_OF_SUBSET_IS_SUBSET.main(Bool.implies(Subset.subclass(X, Y), Subset.subclass(image(f, X), image(f, Y))));
			lemma(IMAGE_OF_SUBSET_IS_SUBSET, null, null, "Bild einer Teilmenge ist Teilmenge des Bildes", null);
			IMAGE_OF_SUBSET_IS_SUBSET.setProofs(Basics.MISSING_PROOF);
			
			IMAGE_OF_UNION_IS_UNION = SINGLETON.normal("IMAGE_OF_UNION_IS_UNION");
			IMAGE_OF_UNION_IS_UNION.setReferences(ml2("2.6.20"));
			IMAGE_OF_UNION_IS_UNION.be(f_A__B, nonEmptySetOfSetsI, Logic.forAll(XelemI, Subset.subclass(X, A)));
			IMAGE_OF_UNION_IS_UNION.main(Logic.equals(image(f, arbitraryUnionIX), Union.arbitraryUnion(X, I, image(f, X))));
			lemma(IMAGE_OF_UNION_IS_UNION, null, null, "Bild einer Vereinigung ist Vereinigunge der Bilder", null);
			IMAGE_OF_UNION_IS_UNION.setProofs(Basics.MISSING_PROOF);

			IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS = SINGLETON.normal("IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS");
			IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS.setReferences(ml2("2.6.20"));
			IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS.be(f_A__B, nonEmptySetOfSetsI, Logic.forAll(XelemI, Subset.subclass(X, A)));
			IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS
					.main(Subset.subclass(image(f, arbitraryIntersectionIX), Intersection.arbitraryIntersection(X, I, image(f, X))));
			lemma(IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS, null, null, "Bild einer Schnittmenge ist Teilmenge des Schnitts der Bilder", null);
			IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS.setProofs(Basics.MISSING_PROOF);

			IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE = SINGLETON.normal("IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE");
			IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE.setReferences(ml2("2.6.20"));
			IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE.be(f_A__B, XsubclassA, YsubclassA);
			IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE.main(Subset.superclass(image(f, XminusY), Difference.difference(image(f, X), image(f, Y))));
			lemma(IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE, null, null, "Bild einer Differenz ist Obermenge der Differenz der Bilder", null);
			IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE.setProofs(Basics.MISSING_PROOF);

			PREIMAGE = preimage(null, null);
			PREIMAGE.be(f_A__B,
					Basics.blankSeparated(Subset.subclass(Y, B)));
			PREIMAGE.main(Logic.definedAs(preimage(f, Y), ClassesSets.classByPredicate(xElemA, ClassesSets.elementOf(f_of_x, Y))));
			MathMLGenerator.displayRule(PREIMAGE, new WriteMulti(writeExponent(FIRST_VARIABLE, MINUS_ONE), "(", SECOND_VARIABLE, ")"));
			definition(PREIMAGE, "preimage", null, "Urbild", "Das Urbild ist immer eine Menge/Klasse.");

			PREIMAGE_OF_SUBSET_IS_SUBSET = SINGLETON.normal("PREIMAGE_OF_SUBSET_IS_SUBSET");
			PREIMAGE_OF_SUBSET_IS_SUBSET.setReferences(ml2("2.6.21"));
			PREIMAGE_OF_SUBSET_IS_SUBSET.be(f_A__B, XsubclassB, YsubclassB);
			PREIMAGE_OF_SUBSET_IS_SUBSET.main(Bool.implies(Subset.subclass(X, Y), Subset.subclass(preimage(f, X), preimage(f, Y))));
			lemma(PREIMAGE_OF_SUBSET_IS_SUBSET, null, null, "Urbild einer Teilmenge ist Teilmenge des Urbilds", null);
			PREIMAGE_OF_SUBSET_IS_SUBSET.setProofs(Basics.MISSING_PROOF);

			PREIMAGE_OF_UNION_IS_UNION = SINGLETON.normal("PREIMAGE_OF_UNION_IS_UNION");
			PREIMAGE_OF_UNION_IS_UNION.setReferences(ml2("2.6.21"));
			PREIMAGE_OF_UNION_IS_UNION.be(f_A__B, nonEmptySetOfSetsI, Logic.forAll(XelemI, XsubclassB));
			PREIMAGE_OF_UNION_IS_UNION.main(Logic.equals(preimage(f, arbitraryUnionIX), Union.arbitraryUnion(X, I, preimage(f, X))));
			lemma(PREIMAGE_OF_UNION_IS_UNION, null, null, "Urbild einer Vereinigung ist Vereinigunge der Urbilder", null);
			PREIMAGE_OF_UNION_IS_UNION.setProofs(Basics.MISSING_PROOF);

			PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS = SINGLETON.normal("PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS");
			PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS.setReferences(ml2("2.6.21"));
			PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS.be(f_A__B, nonEmptySetOfSetsI, Logic.forAll(XelemI, XsubclassB));
			PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS
					.main(Logic.equals(preimage(f, arbitraryIntersectionIX), Intersection.arbitraryIntersection(X, I, preimage(f, X))));
			lemma(PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS, null, null, "Urbild einer Schnittmenge ist Schnitt der Urbilder", null);
			PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS.setProofs(Basics.MISSING_PROOF);

			PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE = SINGLETON.normal("PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE");
			PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE.setReferences(ml2("2.6.21"));
			PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE.be(f_A__B, XsubclassB, YsubclassB);
			PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE.main(Logic.equals(preimage(f, XminusY), Difference.difference(preimage(f, X), preimage(f, Y))));
			lemma(PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE, null, null, "Urbild einer Differenz ist Differenz der Urbilder", null);
			PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE.setProofs(Basics.MISSING_PROOF);

			MAPPINGS_TUPLE = mappingsTuple(null, null, null, null);
			MathMLGenerator.displayRule(MAPPINGS_TUPLE,
					new WriteMulti(FIRST_VARIABLE, ":=(", SECOND_VARIABLE, ", ", THIRD_VARIABLE, ", ", FOURTH_VARIABLE, ")"));

			MAPPING = mapping(null, null, null, null);
			MAPPING.setReferences(wikiDe("Funktion_(Mathematik)"), wikiEn("Function_(mathematics)"), wikiEn("Map_(mathematics)"), ml2("2.6.1"));
			MAPPING.be(f_A__Bextended); // ClassesSets.clasz(A), ClassesSets.clasz(B), Basics.blankSeparated(RelationBinary.function(F), "zwischen A und B"));
			MAPPING.main(
					Bool.definedAsEqualTo(f_A_Bextended, Bool.and(Logic.equals(RelationBinary.domain(F), A), Subset.subclass(RelationBinary.image(F), B))));
			definition(MAPPING, null, null, "Abbildung", "Die Schreibweise für die partielle Abbildung ", mappingsTuple(f, A, F, B), " wird somit zu",
					f_A_Bextended, "oder abkürzend (ohne F zu erwähnen) ", f_A_B,
					"geändert. In der Literatur erfolgt nicht zwingend eine Unterscheidung zwischen Funktion und Abbildung. Im Unterschied zur partiellen Abbildung spricht man hier auch von einer totalen Abbildung. A heißt Definitionsbereich, B Bildbereich, F zugrundeliegende Funktion. Man spricht auch vom Graphen von f: ",
					Logic.definedAs(Basics.mantissaIndex(G, f), F), ".  ");
			MathMLGenerator.displayRule(MAPPING, WriteExtended.defaultExtended(new WriteMulti(NAME, ":", FIRST_VARIABLE, "—>", THIRD_VARIABLE),
					new WriteMulti(NAME, ":", FIRST_VARIABLE, "—>", THIRD_VARIABLE, TextBoostUtils.NON_BREAKING_SPACE + " x Ⱶ─>", SECOND_VARIABLE, "(x)")));
			MAPPING.setExamples(//
					Basics.blankSeparated("Identische Abbildung", IdentityFunction.id(A).setDisplayLevel(VERY_EXTENDED), "mit der Diagonalen",
					IdentityFunction.idRelation(A).setDisplayLevel(EXTENDED), " als Funktion (Graph)."), //
					//
					Basics.blankSeparated("Inklusionsabbildung", IdentityFunction.inclusionMapping(A, B).setDisplayLevel(VERY_EXTENDED), ", wobei ",
							SubsetFactory.subclass(A, B), "sein muss , mit der Diagonalen", IdentityFunction.idRelation(A).setDisplayLevel(EXTENDED),
							" als Funktion (Graph)."), //
					//
					Basics.blankSeparated("Konstante Abbildung: Seien A,B Klassen mit ", cElemB, ": ",
							ConstantFunction.constantMapping(A, B, c).setDisplayLevel(VERY_EXTENDED)), //
					//
					Basics.blankSeparated("Kanonische Projektion: Seien ", X_1, Basics.DOTS, X_n, " Klassen mit 1≤j≤n : ",
							CanonicalProjection.projection(CartesianProduct.nFoldFromTo(i, ONE, n, X_i), X_j, j).setDisplayLevel(VERY_EXTENDED)) //
			// ,Basics.blankSeparated(SetMappings.MAPPINGS_FROM_TO.getMain().get(0), " sind für Mengen A und B die Mengenabbildungen von A nach B."),
			// Basics.blankSeparated(SetMappings.SET_MAPPINGS.getMain().get(0), " ist die Klasse der Mengenabbildungen.")

			//
			);

			MAPPING_FROM_PARTIAL_MAPPING = mapping(null);
			MathMLGenerator.displayRule(MAPPING_FROM_PARTIAL_MAPPING, new WriteMulti(FIRST_VARIABLE, new Object[] { Basics.DEF_NAMES, Mappings.MAPPING }));

			EXPLICIT_MAPPING = mapping(null, null, null, null, null);
			MathMLGenerator.displayRule(EXPLICIT_MAPPING,
					new WriteMulti(NAME, ":", FIRST_VARIABLE, "—>", SECOND_VARIABLE, "  ", THIRD_VARIABLE, "Ⱶ─>", FOURTH_VARIABLE));


			MAPPING_IS_PARTIAL_MAPPING = SINGLETON.normal("MAPPING_IS_PARTIAL_MAPPING");
			MAPPING_IS_PARTIAL_MAPPING.main(Bool.implies(f_A_Bextended, partialMapping));
			MAPPING_IS_PARTIAL_MAPPING.setProofs(Bool.implies(Logic.equals(RelationBinary.domain(F), A), Subset.subclass(RelationBinary.domain(F), A)));
			lemma(MAPPING_IS_PARTIAL_MAPPING, null, null, "Abbildung ist partielle Abbildung", "Jede Abbildung ist auch eine partielle Abbildung.");

			MAPPING_EQUALITY = SINGLETON.normal("MAPPING_EQUALITY");
			MAPPING_EQUALITY.setReferences(ml2("2.6.4"));
			MAPPING_EQUALITY.be(f_A_B, g_C_D);
			MAPPING_EQUALITY.main(Bool.iff(Logic.equals(f, g),
					Bool.and(Logic.equals(A, C), Logic.equals(B, D), Logic.forAll(xElemA, Logic.equals(f_of_x, functionValueAt(g, x))))));
			MAPPING_EQUALITY.setProofs(Bool.implies(Logic.equals(RelationBinary.domain(F), A), Subset.subclass(RelationBinary.domain(F), A)));
			lemma(MAPPING_EQUALITY, null, null, "Gleichheit von Abbildungen", null);
			MAPPING_EQUALITY.setProofs(Bool.iffMultiline(//
					Logic.equals(Tuples.tuple(G_f, A, B), f, g, Tuples.tuple(G_g, C, D)), //
					Bool.and(Logic.equals(G_f, G_g), Logic.equals(domain(G_f), A, C, domain(G_g)), Logic.equals(B, D)), //
					Bool.and(
							Logic.equals(ClassesSets.classByPredicate(Tuples.tuple(x, f_of_x), ClassesSets.elementOf(x, domain(G_f))),
									ClassesSets.classByPredicate(Tuples.tuple(x, g_of_x), ClassesSets.elementOf(x, domain(G_g)))),
							Logic.equals(domain(G_f), A, C, domain(G_g)), Logic.equals(B, D)), //
					Bool.and(
							Logic.equals(ClassesSets.classByPredicate(Tuples.tuple(x, f_of_x), ClassesSets.elementOf(x, A)),
									ClassesSets.classByPredicate(Tuples.tuple(x, g_of_x), ClassesSets.elementOf(x, A))),
							Logic.equals(domain(G_f), A, C, domain(G_g)), Logic.equals(B, D)), //
					Bool.and(Logic.forAll(xElemA, Logic.equals(f_of_x, functionValueAt(g, x))), Logic.equals(domain(G_f), A, C, domain(G_g)),
							Logic.equals(B, D))
			//
			));

			OPERATION = operation(null, null);
			OPERATION.be(partialMapping(f, A, F, B), ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS));
			OPERATION.main(Bool.definedAsEqualTo(operation(f, n), Subset.subset(A, CartesianProduct.nFoldFromTo(i, ONE, n, Ai))));
			definition(OPERATION, "operation", null, "Verknüpfung", f,
					" heißt in diesem Fall genauer n-stellige partielle Verknüpfung. Ist ", F,
					" Funktion und ", Logic.equals(A, CartesianProduct.nFoldFromTo(i, ONE, n, Ai)), " ist ", f,
					" n-stellige Verknüpfung. Bei n=1 spricht man von einstelliger (unärer/monadischer) Verknüpfung, bei n=2 spricht man von zweistelliger (binärer) Verknüpfung. ");
			OPERATION.setReferences(wikiDe("Verknüpfung_(Mathematik)"), wikiDe("Einstellige_Verknüpfung"), wikiDe("Zweistellige_Verknüpfung"),
					wikiEn("Operation_(mathematics)"));
			
			INNER_OPERATION = innerOperation(null, null, null, null);
			INNER_OPERATION.be(ClassesSets.clasz(A), ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS));
			INNER_OPERATION
					.main(Bool.definedAsEqualTo(innerOperation(f, A, n, F),
							operation(partialMapping(f, CartesianProduct.power(A, n), F, A), n)));
			INNER_OPERATION.setWorthwileMain(false);// display is similar
			definition(INNER_OPERATION, null, null, "partielle innere Verknüpfung",
					"Eine n-stellige partielle innere Verknüpfung ist eine Verknüpfung der Form ",
					innerOperation(f, A, n, F),
					". Sie wird auch als n-stellige (partielle) Operation bezeichnet.");
			INNER_OPERATION.setReferences(wikiDe("Verknüpfung_(Mathematik)"));
			MathMLGenerator.displayRule(INNER_OPERATION,
					WriteAfterStatementTransformation.ruleTransformation(new RuleStatementCreator(Mappings.PARTIAL_MAPPING, NAME),
							new Object[] { CartesianProduct.POWER, FIRST_VARIABLE, SECOND_VARIABLE }, THIRD_VARIABLE, FIRST_VARIABLE));

			INFIX_VALUE = infixValue(null, null, null);
			MathMLGenerator.displayRule(INFIX_VALUE,
					WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED, SECOND_VARIABLE, NAME_OF_FIRST_VARIABLE, THIRD_VARIABLE));
			Statement addition = partialBinaryOperation(PLUS, null, null);
			Statement multiplication = partialBinaryOperation(MULT, null, null);
			Statement multiplicationWithoutDot = partialBinaryOperation(NOTHING, null, null);

			PARTIAL_BINARY_OPERATION = partialBinaryOperation(null, null, null);
			PARTIAL_BINARY_OPERATION.be(ClassesSets.clasz(A));
			PARTIAL_BINARY_OPERATION.main(Bool.definedAsEqualTo(partialBinaryOperation(f, A, F), innerOperation(f, A, TWO, F)));
			PARTIAL_BINARY_OPERATION.setWorthwileMain(false);// display is similar
			definition(PARTIAL_BINARY_OPERATION, null, null, "partielle binäre Operation",
					"Eine partielle binäre Operation  (auch partielle Multiplikation genannt) ist eine zweistellige (partielle) Operation der Form ",
					partialBinaryOperation(f, A, F), ". Insbesondere bei den mathematischen Operationen der Addition (", PLUS, ") und Multiplikation (", MULT,
					") verwendet man die Infixschreibweise ", plus(addition, a, b), ",", mult(multiplication, a, b), " bzw. einfach nur ",
					mult(multiplicationWithoutDot, a, b), ". Ist ", ClassesSets.elementOf(Tuples.pair(a, b), domain(f)), " spricht man davon, dass  ",
					mult(multiplicationWithoutDot, a, b), " existiert bzw. definiert ist."
			);
			PARTIAL_BINARY_OPERATION.setReferences(kat1("1.2.4"), wikiEn("Binary_operation"), wikiDe("Zweistellige_Verknüpfung"));

			Write writeMapping = WriteAfterStatementTransformation.ruleTransformation(new RuleStatementCreator(Mappings.INNER_OPERATION, NAME), FIRST_VARIABLE,
					TWO, SECOND_VARIABLE);

			MathMLGenerator.displayRule(PARTIAL_BINARY_OPERATION,
					WriteExtended.shortDefault(//
							MathMLGenerator.WRITE_NAME_OF_INSTANCE, //
							writeMapping, //
							new WriteMulti(writeMapping, SECOND_VARIABLE)
					//
					));



			BINARY_OPERATION = binaryOperation(null, null, null);
			BINARY_OPERATION.main(Bool.definedAsEqualTo(binaryOperation(f, A, F), Logic.equals(domain(f), CartesianProduct.power(A, TWO))));
			// BINARY_OPERATION.setWorthwileMain(false);// display is similar
			definition(BINARY_OPERATION, null, null, "binäre Operation", "Eine binäre Operation ist eine zweistellige Operation", binaryOperation(f, A, F),
					" bei der der Definitionsbereich ganz ", CartesianProduct.power(A, TWO), " ist.");
			BINARY_OPERATION.setReferences(wikiEn("Binary_operation"), wikiDe("Zweistellige_Verknüpfung"));
			MathMLGenerator.displayRule(BINARY_OPERATION, WriteAfterStatementTransformation.ruleTransformation(new RuleStatementCreator(Mappings.MAPPING, NAME),
					new Object[] { CartesianProduct.POWER, FIRST_VARIABLE, TWO }, SECOND_VARIABLE, FIRST_VARIABLE));

			// N_ARY_FROM_BINARY_OPERATION = SINGLETON.naive("N_ARY_FROM_BINARY_OPERATION");
			// N_ARY_FROM_BINARY_OPERATION.be(binaryOperation(f, A, F));
			// definition(N_ARY_FROM_BINARY_OPERATION, null, null, "n-stellige Operation aus zweistelliger mittels Induktion", "Mittels induktiver Definition
			// lässt sich leicht aus einer zweistelligen Operation eine n-stellige Operation machen.");

			Statement iElementI =ClassesSets.elementOf(i, I);
			Statement AiClass = Basics.blankSeparated(ClassesSets.clasz(Ai), Basics.defNames(ClassesSets.CLASS));
			//https://books.google.de/books?id=o3DSBgAAQBAJ&pg=PA199&lpg=PA199&dq=Heterogene+Algebra&source=bl&ots=qnaL4oP-Gf&sig=jijjr_50dUeeKHHsD81BFb2sfIo&hl=de&sa=X&ved=0ahUKEwi8_Ln1w7XVAhVL2BoKHXCVBY4Q6AEIMzAC#v=onepage&q=Heterogene%20Algebra&f=false
			PARTIAL_HETEROGEN_OPERATION_ON_CLASS_SYSTEM = partialHeterogenOperationOnClassSystem(null,null,null);
			PARTIAL_HETEROGEN_OPERATION_ON_CLASS_SYSTEM.be(ClassesSets.set(I),
					Logic.forAll(iElementI, Bool.and(AiClass, Logic.notEquals(Ai, EmptySet.EMPTY_SET))),
					ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS), ClassesSets.elementOf(i_1, I), DOTS, ClassesSets.elementOf(i_n, I),
					ClassesSets.elementOf(x, I));
			definition(PARTIAL_HETEROGEN_OPERATION_ON_CLASS_SYSTEM, null, null, "Partielle heterogene Operation auf Klassensystem",
					"Eine partielle heterogene Operation auf einem System von Klassen ", ClassesSets.classByPredicate(null, Ai, iElementI),
					" ist eine partielle Abbildung ",
					partialMapping(f, CartesianProduct.nFold(Logic.var("A", i_1), DOTS, Logic.var("A", i_n)), F, Logic.var("A", x)));

			HETEROGEN_OPERATION_ON_CLASS_SYSTEM = heterogenOperationOnClassSystem(null, null, null);
			HETEROGEN_OPERATION_ON_CLASS_SYSTEM.be(ClassesSets.set(I), Logic.forAll(iElementI, Bool.and(AiClass, Logic.notEquals(Ai, EmptySet.EMPTY_SET))),
					ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS), ClassesSets.elementOf(i_1, I), DOTS, ClassesSets.elementOf(i_n, I),
					ClassesSets.elementOf(x, I));
			definition(HETEROGEN_OPERATION_ON_CLASS_SYSTEM, null, null, "Heterogene Operation auf Klassensystem",
					"Eine  heterogene Operation auf einem System von Klassen ", ClassesSets.classByPredicate(null, Ai, iElementI), " ist eine Abbildung ",
					mapping(f, CartesianProduct.nFold(Logic.var("A", i_1), DOTS, Logic.var("A", i_n)), F, Logic.var("A", x)));
			
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(PARTIAL_MAPPING, DOMAIN, //
						IMAGE, IMAGE_OF_SUBSET_IS_SUBSET, IMAGE_OF_UNION_IS_UNION,IMAGE_OF_INTERSECTION_IS_SUBSET_OF_INTERSECTIONS, IMAGE_OF_DIFFERENCE_IS_SUPERSET_OF_DIFFERENCE, //
						PREIMAGE, PREIMAGE_OF_SUBSET_IS_SUBSET, PREIMAGE_OF_UNION_IS_UNION, PREIMAGE_OF_INTERSECTION_IS_INTERSECTIONS,
						PREIMAGE_OF_DIFFERENCE_IS_DIFFERENCE, //
						MAPPING,
						MAPPING_IS_PARTIAL_MAPPING,
						MAPPING_EQUALITY,
						SetMappings.MAPPINGS_FROM_TO,
						SetMappings.SET_MAPPINGS, SetMappings.MAPPINGS_TO_ONE_ELEMENT_SET, SetMappings.MAPPINGS_FROM_EMPTY_SET,
						SetMappings.MAPPINGS_FROM_TO_EMPTY, OPERATION, 
						INNER_OPERATION,
						PARTIAL_BINARY_OPERATION,
						BINARY_OPERATION, /* N_ARY_FROM_BINARY_OPERATION, */
						PARTIAL_HETEROGEN_OPERATION_ON_CLASS_SYSTEM, HETEROGEN_OPERATION_ON_CLASS_SYSTEM),
				Arrays.asList(INFIX_VALUE, MAPPING_FROM_PARTIAL_MAPPING, MAPPING_DEFINED_AT, IdentityFunction.INCLUSION_MAPPING,
						ConstantFunction.CONSTANT_MAPPING, CanonicalProjection.PROJECTION,
						EXPLICIT_MAPPING, SetMappings.SET_MAPPINGS, SetMappings.MAPPINGS_FROM_TO, MAPPINGS_TUPLE, FUNCTION_VALUE_AT));
	}

}
