package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;

public class MappingsFactory extends Statements {

	protected static final MappingsFactory SINGLETON = new MappingsFactory();

	protected MappingsFactory() {
		super("mappings", null);
	}

	public static Statement elementMappedTo(Statement element, Statement result) {
		return SINGLETON.normal("elementMappedTo", element, result);

	}


	public static Statement mappingsTuple(Statement name, Statement domain, Statement function, Statement codomain) {
		Statement result = SINGLETON.normal("mappingsTuple", name, domain, function, codomain);
		return result;
	}

	public static Statement mapping(Statement name, Statement domain, Statement function, Statement codomain) {
		Statement result = SINGLETON.normal("mapping", domain, function, codomain);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement mapping(Statement name, Statement domain, Statement codomain, Statement variable, Statement functionValue) {
		Statement result = SINGLETON.normal("mapping2", domain, codomain, variable, functionValue);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement mapping(Statement partialMapping) {
		Statement result = SINGLETON.normal("mappingFromPartialMapping", partialMapping);
		return result;
	}

	public static Statement partialMapping(Statement name, Statement domain, Statement function, Statement codomain) {
		Statement result = SINGLETON.normal("partial mapping", domain, function, codomain);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement operation(Statement mapping, Statement arity) {
		Statement result = SINGLETON.normal("operation", mapping, arity);
		return result;
	}

	public static Statement innerOperation(Statement name, Statement codomain, Statement arity, Statement function) {
		Statement result = SINGLETON.normal("innerOperation", codomain, arity, function);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement partialBinaryOperation(Statement name, Statement codomain, Statement function) {
		Statement result = SINGLETON.normal("partialBinaryOperation", codomain, function);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement infixValue(Statement binaryOperation, Statement firstOperand, Statement secondOperand) {
		Statement result = SINGLETON.normal("infixValue", binaryOperation, firstOperand, secondOperand);
		return result;
	}

	public static Statement mult(Statement binaryOperation, Statement firstOperand, Statement secondOperand) {
		return infixValue(binaryOperation, firstOperand, secondOperand);
	}

	public static Statement plus(Statement binaryOperation, Statement firstOperand, Statement secondOperand) {
		return infixValue(binaryOperation, firstOperand, secondOperand);
	}

	public static Statement binaryOperation(Statement name, Statement codomain, Statement function) {
		Statement result = SINGLETON.normal("binaryOperation", codomain, function);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement domain(Statement partialMapping) {
		Statement result = SINGLETON.normal("domain", partialMapping);
		return result;
	}

	public static Statement partialHeterogenOperationOnClassSystem(Statement name, Statement classSystem, Statement partialMapping) {
		Statement result = SINGLETON.normal("partialHeterogenOperationOnClassSystem", classSystem, partialMapping);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement heterogenOperationOnClassSystem(Statement name, Statement classSystem, Statement mapping) {
		Statement result = SINGLETON.normal("heterogenOperationOnClassSystem", classSystem, mapping);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement functionValueAt(Statement mapping, Statement input) {
		Statement result = SINGLETON.normal("functionValueAt", mapping, input);
		return result;
	}

	public static Statement image(Statement mapping, Statement input) {
		Statement result = SINGLETON.normal("image", mapping, input);
		return result;
	}

	public static Statement preimage(Statement mapping, Statement output) {
		Statement result = SINGLETON.normal("preimage", mapping, output);
		return result;
	}

	public static Statement mappingDefinedAt(Statement domainElementDescription) {
		return SINGLETON.naive("functionDefinedAt", domainElementDescription);
	}


}
