package net.sf.gluebooster.demos.pojo.math.library.setTheory.functions;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.VariableExamples;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;

public interface MappingsSamples extends SetTheorySamples {

	Statement multDot = MappingsFactory.partialBinaryOperation(MULT, A, null).setDisplayLevel(Statements.SHORT);
	Statement multDotExtended = multDot.copy().setDisplayLevel(Statements.EXTENDED);

	Statement multDotTotal = MappingsFactory.binaryOperation(MULT, A, null).setDisplayLevel(Statements.SHORT);
	Statement multDotTotalExtended = multDotTotal.copy().setDisplayLevel(Statements.EXTENDED);

	Statement mult = MappingsFactory.partialBinaryOperation(NOTHING, null, null).setDisplayLevel(Statements.SHORT);
	Statement multiplication = MappingsFactory.partialBinaryOperation(f, A, null).setDisplayIdentifyingNameInPrecondition(true);
	Statement shortMultiplication = multiplication.copy().setDisplayLevel(Statements.SHORT);
	

	// multiplications without multiplication symbol

	Statement ab = MappingsFactory.mult(mult, a, b);
	Statement ae = MappingsFactory.mult(mult, a, e);
	Statement ea = MappingsFactory.mult(mult, e, a);

	// multiplications with a dot end with an underscore

	Statement ab_ = Mappings.mult(multDot, a, b);
	Statement ax_ = Mappings.mult(multDot, a, x);

	Statement ba_ = Mappings.mult(multDot, b, a);
	Statement bc_ = MappingsFactory.mult(multDot, b, c);
	Statement bx_ = Mappings.mult(multDot, b, x);

	Statement na_ = Mappings.mult(multDot, n, a);
	Statement nb_ = Mappings.mult(multDot, n, b);

	Statement xa_ = Mappings.mult(multDot, x, a);
	Statement xb_ = Mappings.mult(multDot, x, b);

	Statement ab_c_ = MappingsFactory.mult(multDot, Logic.bracket(ab_), c);
	Statement a_bc_ = Mappings.mult(multDot, a, Logic.bracket(bc_));
	Statement a_ba_ = Mappings.mult(multDot, a, Logic.bracket(ba_));
	Statement a_xa_ = Mappings.mult(multDot, a, Logic.bracket(xa_));
	Statement a_xb_ = Mappings.mult(multDot, a, Logic.bracket(xb_));
	Statement ab_a_ = Mappings.mult(multDot, Logic.bracket(ab_), a);
	Statement ax_a_ = Mappings.mult(multDot, Logic.bracket(ax_), a);
	Statement ax_b_ = Mappings.mult(multDot, Logic.bracket(ax_), b);
	Statement ba_a_ = Mappings.mult(multDot, Logic.bracket(ba_), a);


	Statement id_A = IdentityFunctionFactory.id(A).setDisplayLevel(Statements.SHORT);
	Statement id_B = IdentityFunctionFactory.id(B).setDisplayLevel(Statements.SHORT);

	Statement f_A__B = MappingsFactory.partialMapping(f, A, null, B);
	Statement f_A__Bextended = MappingsFactory.partialMapping(f, A, F, B).setDisplayLevel(Statements.EXTENDED);
	Statement f_A_B = MappingsFactory.mapping(f, A, F, B);
	Statement f_A_Bextended = MappingsFactory.mapping(f, A, F, B).setDisplayLevel(Statements.EXTENDED);
	Statement g_B__C = MappingsFactory.partialMapping(g, B, null, C);
	Statement g_C_D = MappingsFactory.mapping(g, C, G, D);
	Statement h_C__D = MappingsFactory.partialMapping(h, C, null, D);



}
