package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.crypto.CipherInputStream;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Integers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Numbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.InverseRelation;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class CartesianProduct extends CartesianProductFactory implements SetTheorySamples {


	public static Statement CARTESIAN_PRODUCT;
	public static Statement CARTESIAN_PRODUCT_N_FOLD; //
	public static Statement CARTESIAN_PRODUCT_N_FOLD_FROM_TO; //
	public static Statement POWER; // with special A²
	public static Statement CARTESIAN_INTERSECTION_DISTRIBUTIVE;
	public static Statement CARTESIAN_UNION_DISTRIBUTIVE;
	public static Statement INTERSECTION_BINARY_PRODUCTS;
	public static Statement UNION_BINARY_PRODUCTS;
	public static Statement PRODUCT_OF_SUBSETS;
	public static Statement COMMUTATIVE_PRODUCT;
	public static Statement PRODUCT_WITH_EMPTY_SET;
	public static Statement DIFFERENCE_OF_PRODUCTS;
	public static Statement INVERSE_OF_BINARY_PRODUCT;


	private CartesianProduct() {
	}

	static {
		try {
			WriteOperation WRITE_OPERATION_CARTESIAN_PRODUCT = new WriteOperation("×");

			titleText(SINGLETON.getCategory(), "Cartesian produkt", null, "Kreuzprodukt/Kartesisches Produkt", null);


			titleText(SINGLETON.unit(1), "Cartesian produkt (1)", null, "Kreuzprodukt/Kartesisches Produkt (1)", null);

			CARTESIAN_PRODUCT = binary(null, null);
			CARTESIAN_PRODUCT.setReferences(References.wikiEn("Cartesian_product"), References.wikiDe("Kartesisches_Produkt"));
			CARTESIAN_PRODUCT.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			CARTESIAN_PRODUCT.setMain(Logic.definedAs(binary(A, B),
					ClassesSets.classByPredicate(null, Tuples.pair(x, y), Bool.and(ClassesSets.elementOf(x, A), ClassesSets.elementOf(y, B)))));
			definition(CARTESIAN_PRODUCT, "Cartesian product", null, "Kartesisches Produkt",
					"Das kartesische Produkt wird auch als Mengenprodukt oder Kreuzprodukt bezeichnet. Gelesen wird ", binary(A, B), " als 'A Kreuz B'");
			MathMLGenerator.displayRule(CARTESIAN_PRODUCT, WRITE_OPERATION_CARTESIAN_PRODUCT);
			CARTESIAN_PRODUCT.setExamples(
					Logic.equals(binary(Bool.BOOLEAN_SET, Bool.BOOLEAN_SET), ClassesSets.explicitSetWithoutName(Tuples.tuple(Bool.VERUM, Bool.VERUM),
							Tuples.tuple(Bool.VERUM, Bool.FALSUM), Tuples.tuple(Bool.FALSUM, Bool.VERUM), Tuples.tuple(Bool.FALSUM, Bool.FALSUM))));

			CARTESIAN_PRODUCT_N_FOLD_FROM_TO = nFoldFromTo(null, null, null, null);
			MathMLGenerator.displayRule(CARTESIAN_PRODUCT_N_FOLD_FROM_TO, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
					new Object[] { Basics.UNDEROVER, "X", new Object[] { Logic.EQUALS, FIRST_VARIABLE, SECOND_VARIABLE }, THIRD_VARIABLE }, FOURTH_VARIABLE));

			CARTESIAN_PRODUCT_N_FOLD = nFold();
			CARTESIAN_PRODUCT_N_FOLD.setReferences(References.wikiEn("Cartesian_product"), References.wikiDe("Kartesisches_Produkt"));
			CARTESIAN_PRODUCT_N_FOLD.be(ClassesSets.clasz(A_1), more, ClassesSets.clasz(A_n));
			CARTESIAN_PRODUCT_N_FOLD.setMain(Logic.definedAs(nFold(A_1, more, A_n), ClassesSets.classByPredicate(null, Tuples.tuple(x_1, more, x_n),
					Bool.and(ClassesSets.elementOf(x_1, A_1), more, ClassesSets.elementOf(x_n, A_n)))));
			definition(CARTESIAN_PRODUCT_N_FOLD, "N-fold cartesian product", null,
					"Kartesisches Produkt endlich vieler Klassen", "Eine andere Schreibweise ist ",
					Logic.definedAs(nFoldFromTo(i, n, m, A_i), nFold(A_1, more, A_n)));
			MathMLGenerator.displayRule(CARTESIAN_PRODUCT_N_FOLD, WRITE_OPERATION_CARTESIAN_PRODUCT);

			POWER = power(null, null);
			POWER.setReferences(References.wikiEn("Cartesian_product"), References.wikiDe("Kartesisches_Produkt"));
			POWER.be(ClassesSets.clasz(A), ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS));
			POWER.setMain(Logic.definedAs(power(A, n), Logic.equals(nFold(A, A, more, A), ClassesSets.classByPredicate(null,
					Tuples.tuple(x_1, more, x_n), Logic.forAll(ClassesSets.elementOf(i, NaturalNumbers.upTo(n)), ClassesSets.elementOf(x_i, A))))));
			definition(POWER, "Cartesian power", null, "N-faches kartesisches Produkt mit sich selbst",
					"Eine Erweiterung ergibt sich durch die Definition von ",
					Logic.definedAs(power(A, ZERO), ClassesSets.explicitSet(null, EmptySet.EMPTY_SET)));
			MathMLGenerator.displayRule(POWER,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, FIRST_VARIABLE, "", SECOND_VARIABLE));
			POWER.setExamples(
					//
					Basics.notSeparated(Basics.comment("Kartesisches Produkt über endliche Mengen: "), power(Bool.BOOLEAN_SET, TWO), Basics.comment(", "),
							power(Bool.BOOLEAN_SET, THREE)), //
					Basics.notSeparated(Basics.comment("Kartesisches Produkt über echte Klassen: "), power(ClassesSets.CLASS_OF_ALL_SETS, TWO),
							Basics.comment(", "),
					power(ClassesSets.CLASS_OF_ALL_SETS, THREE)));
			
			CARTESIAN_INTERSECTION_DISTRIBUTIVE = SINGLETON.normal("CARTESIAN_INTERSECTION_DISTRIBUTIVE");
			CARTESIAN_INTERSECTION_DISTRIBUTIVE.setReferences(References.ml1("2.1.6"));
			CARTESIAN_INTERSECTION_DISTRIBUTIVE.be(classA, classB, classC);
			Statement left = binary(A, Logic.bracket(BinterC));
			Statement right = Intersection.intersectionWithBrackets(binary(A, B), binary(A, C));
			CARTESIAN_INTERSECTION_DISTRIBUTIVE.setMain(Logic.equals(left, right));
			lemma(CARTESIAN_INTERSECTION_DISTRIBUTIVE, null, null, "Distributivgesetz Kartesisches Produkt-Schnitt", null);
			CARTESIAN_INTERSECTION_DISTRIBUTIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(xTy, left), //
					Bool.and(xElemA, ClassesSets.elementOf(y, BinterC)), //
					Bool.and(xElemA, yElemB, yElemC), //
					Bool.and(xElemA, yElemB, xElemA, yElemC), //
					Bool.and(ClassesSets.elementOf(xTy, AcrossB), ClassesSets.elementOf(xTy, AcrossC)), //
					ClassesSets.elementOf(xTy, right) //
			//
			));

			CARTESIAN_UNION_DISTRIBUTIVE = SINGLETON.normal("CARTESIAN_UNION_DISTRIBUTIVE");
			CARTESIAN_UNION_DISTRIBUTIVE.setReferences(References.ml1("2.1.6"));
			CARTESIAN_UNION_DISTRIBUTIVE.be(classA, classB, classC);
			left = binary(A, Logic.bracket(BunionC));
			right = Union.unionWithBrackets(binary(A, B), binary(A, C));
			CARTESIAN_UNION_DISTRIBUTIVE.setMain(Logic.equals(left, right));
			lemma(CARTESIAN_UNION_DISTRIBUTIVE, null, null, "Distributivgesetz Kartesisches Produkt-Vereinigung", null);
			CARTESIAN_UNION_DISTRIBUTIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(xTy, left), //
					Bool.and(xElemA, ClassesSets.elementOf(y, BunionC)), //
					Bool.and(xElemA, Logic.bracket(Bool.or(yElemB, yElemC))), //
					Bool.orWithBrackets(Bool.and(xElemA, yElemB), Bool.and(xElemA, yElemC)), //
					Bool.or(ClassesSets.elementOf(xTy, AcrossB), ClassesSets.elementOf(xTy, AcrossC)), //
					ClassesSets.elementOf(xTy, right) //
			//
			));

			INTERSECTION_BINARY_PRODUCTS = SINGLETON.normal("INTERSECTION_BINARY_PRODUCTS");
			INTERSECTION_BINARY_PRODUCTS.setReferences(References.ml1("2.1.6"));
			INTERSECTION_BINARY_PRODUCTS.be(classA, classB, classC, classD);
			left = Intersection.intersectionWithBrackets(binary(A, B), binary(C, D));
			right = binary(Logic.bracket(AinterC), Logic.bracket(BinterD));
			INTERSECTION_BINARY_PRODUCTS.setMain(Logic.equals(left, right));
			lemma(INTERSECTION_BINARY_PRODUCTS, null, null, "Schnitt kartesischer Produkte ist kartesisches Produkt der Schnitte", null);
			INTERSECTION_BINARY_PRODUCTS.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(xTy, left), //
					Bool.and(ClassesSets.elementOf(xTy, AcrossB), ClassesSets.elementOf(xTy, CcrossD)), //
					Bool.and(xElemA, yElemB, xElemC, yElemD), //
					Bool.and(ClassesSets.elementOf(x, AinterC), ClassesSets.elementOf(y, BinterD)), //
					ClassesSets.elementOf(xTy, right) //
			//
			));
			
			UNION_BINARY_PRODUCTS = SINGLETON.normal("UNION_BINARY_PRODUCTS");
			UNION_BINARY_PRODUCTS.setReferences(References.ml1("2.1.6"));
			UNION_BINARY_PRODUCTS.be(classA, classB, classC, classD);
			left = Union.unionWithBrackets(binary(A, B), binary(C, D));
			right = binary(Logic.bracket(AunionC), Logic.bracket(BunionD));
			UNION_BINARY_PRODUCTS.setMain(Subset.subclass(left, right));
			lemma(UNION_BINARY_PRODUCTS, null, null, "Vereinigung kartesischer Produkte ist Teilmenge des kartesisches Produkt der Vereinigungen", null);
			UNION_BINARY_PRODUCTS.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(xTy, left), //
					Bool.or(ClassesSets.elementOf(xTy, AcrossB), ClassesSets.elementOf(xTy, CcrossD)), //
					Bool.orWithBrackets(Bool.and(xElemA, yElemB), Bool.and(xElemC, yElemD)), //
					Bool.andWithBrackets(Bool.or(xElemA, xElemC), Bool.or(yElemB, yElemD)), //
					Bool.andWithBrackets(ClassesSets.elementOf(x, AunionC), ClassesSets.elementOf(y, BunionD)), //
					ClassesSets.elementOf(xTy, right) //
			//
			));

			PRODUCT_OF_SUBSETS = SINGLETON.normal("PRODUCT_OF_SUBSETS");
			PRODUCT_OF_SUBSETS.setReferences(References.ml1("2.1.7"));
			PRODUCT_OF_SUBSETS.be(classA, classB, classC, classD);
			left = Bool.and(AsubclassC, BsubclassD);
			right = Subset.subclass(AcrossB, CcrossD);
			PRODUCT_OF_SUBSETS.setMain(Bool.implies(left, right));
			lemma(PRODUCT_OF_SUBSETS, null, null, "kartesischer Produkt von Teilmengen ist Teilmenge des kartesisches Produkt der Obermengen", null);
			PRODUCT_OF_SUBSETS.setProofs(Subset.subclassesMultiline(//
					AcrossB, //
					Union.unionWithBrackets(AcrossB, CcrossD), //
					Logic.equals(binaryWithBrackets(AunionC, BunionD), CcrossD) //
			//
			));

			COMMUTATIVE_PRODUCT = SINGLETON.normal("COMMUTATIVE_PRODUCT");
			COMMUTATIVE_PRODUCT.setReferences(References.ml1("2.1.7"));
			COMMUTATIVE_PRODUCT.be(nonEmptyClassA, nonEmptyClassB);
			left = Logic.equals(binary(A, B), binary(B, A));
			right = Logic.equals(A, B);
			COMMUTATIVE_PRODUCT.setMain(Bool.iff(left, right));
			lemma(COMMUTATIVE_PRODUCT, null, null, "kommutatives kartesisches Produkt nur bei gleichen Klassen", null);
			COMMUTATIVE_PRODUCT.setProofs(Bool.iffByIf(//
					Bool.implies(left, right), //
					Basics.multiline( //
							Basics.be(left), //
							Bool.impliesMultiline( //
									aElemA, //
									Logic.exists(bElemB, ClassesSets.elementOf(a_b, left)), //
									Logic.exists(bElemB, ClassesSets.elementOf(a_b, binary(B, A))), //
									aElemB), //
							Basics.analogous(Bool.implies(aElemB, aElemA))), //
					Bool.implies(right, left), //
					Basics.TRIVIAL
			//
			));

			PRODUCT_WITH_EMPTY_SET = SINGLETON.normal("PRODUCT_WITH_EMPTY_SET");
			PRODUCT_WITH_EMPTY_SET.setReferences(References.ml1("2.1.7"));
			PRODUCT_WITH_EMPTY_SET.be(classA);
			PRODUCT_WITH_EMPTY_SET.setMain(Logic.equals(binary(A, EmptySet.EMPTY_SET), EmptySet.EMPTY_SET, binary(EmptySet.EMPTY_SET, A)));
			lemma(PRODUCT_WITH_EMPTY_SET, null, null, "kartesisches Produkt mit leerer Menge ist leere Menge", null);
			PRODUCT_WITH_EMPTY_SET
					.setProofs(Logic.proofByContradiction(Basics.multiline(//
							Bool.impliesMultiline(//
											Logic.notEquals(binary(A, EmptySet.EMPTY_SET), EmptySet.EMPTY_SET), //
									Logic.exists(x, ClassesSets.elementOf(x, binary(A, EmptySet.EMPTY_SET))), //
									Logic.exists(Basics.commaSeparated(aElemA, ClassesSets.elementOf(b, EmptySet.EMPTY_SET)), Logic.equals(a_b, x)), //
									Logic.exists(b, ClassesSets.elementOf(b, EmptySet.EMPTY_SET))),
							Basics.analogous(Logic.equals(EmptySet.EMPTY_SET, binary(EmptySet.EMPTY_SET, A)))

			//
			)));
			
			
			DIFFERENCE_OF_PRODUCTS = SINGLETON.normal("DIFFERENCE_OF_PRODUCTS");
			DIFFERENCE_OF_PRODUCTS.setReferences(References.ml1("2.1.7"));
			DIFFERENCE_OF_PRODUCTS.be(classA, classB, classC, classD);
			left = Difference.difference(Logic.bracket(AcrossB), Logic.bracket(CcrossD));
			right = Union.unionWithBrackets(binary(Logic.bracket(AminusC), B), binary(A, Logic.bracket(BminusD)));
			DIFFERENCE_OF_PRODUCTS.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_OF_PRODUCTS, null, null, "Differenz kartesischer Produkte", null);
			DIFFERENCE_OF_PRODUCTS.setProofs(Logic.equalsMultiline(//
					left, //
					ClassesSets.classByPredicate(x_y, Bool.and(ClassesSets.elementOf(x_y, AcrossB), Bool.not(ClassesSets.elementOf(x_y, CcrossD)))), //
					ClassesSets.classByPredicate(x_y, Bool.and(xElemA, yElemB, Bool.notWithBrackets(Bool.and(xElemC, yElemD)))), //
					ClassesSets.classByPredicate(x_y, Bool.and(xElemA, yElemB, Logic.bracket(Bool.or(xNotElemC, yNotElemD)))), //
					ClassesSets.classByPredicate(x_y, Bool.orWithBrackets(Bool.and(xElemA, yElemB, xNotElemC), Bool.and(xElemA, yElemB, yNotElemD))), //
					ClassesSets.classByPredicate(x_y,
							Bool.orWithBrackets(Bool.and(ClassesSets.elementOf(x, AminusC), yElemB), Bool.and(xElemA, ClassesSets.elementOf(y, BminusD)))), //
					ClassesSets.classByPredicate(x_y,
							Bool.or(ClassesSets.elementOf(x_y, binary(Logic.bracket(AminusC), B)),
									ClassesSets.elementOf(x_y, binary(A, Logic.bracket(BminusD))))), //
					right
			//
			));

			INVERSE_OF_BINARY_PRODUCT = SINGLETON.normal("INVERSE_OF_BINARY_PRODUCT");
			INVERSE_OF_BINARY_PRODUCT.setReferences(References.ml1("2.3.3"));
			INVERSE_OF_BINARY_PRODUCT.main(Logic.equals(InverseRelation.inverse(Logic.bracket(AcrossB)), BcrossA));
			lemma(INVERSE_OF_BINARY_PRODUCT, null, null, "inverse Relation des (binären) kartesischen Produkts", null);
			INVERSE_OF_BINARY_PRODUCT.setProofs(Logic.equalsMultiline(//
					InverseRelation.inverse(Logic.bracket(AcrossB)), //
					ClassesSets.classByPredicate(b_a, ClassesSets.elementOf(a_b, AcrossB)), //
					ClassesSets.classByPredicate(b_a, Bool.and(aElemA, bElemB)), //
					ClassesSets.classByPredicate(b_a, Bool.and(bElemB, aElemA)), //
					ClassesSets.classByPredicate(b_a, ClassesSets.elementOf(b_a, BcrossA)), //
					BcrossA
			//
			));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				(List) Arrays.asList(CARTESIAN_PRODUCT, CARTESIAN_PRODUCT_N_FOLD, POWER, CARTESIAN_INTERSECTION_DISTRIBUTIVE, CARTESIAN_UNION_DISTRIBUTIVE,
						INTERSECTION_BINARY_PRODUCTS, INTERSECTION_BINARY_PRODUCTS, UNION_BINARY_PRODUCTS, PRODUCT_OF_SUBSETS, COMMUTATIVE_PRODUCT,
						PRODUCT_WITH_EMPTY_SET, DIFFERENCE_OF_PRODUCTS),
				Arrays.asList(CARTESIAN_PRODUCT_N_FOLD_FROM_TO));
	}

}
