package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class CartesianProductFactory extends Statements {

	protected static final CartesianProductFactory SINGLETON = new CartesianProductFactory();



	protected CartesianProductFactory() {
		super("CartesianProduct", SetTheory.SINGLETON);
	}



	public static Statement binary(Statement class1, Statement class2) {
		Statement result = SINGLETON.binary("product", class1, class2);
		return result;
	}

	public static Statement binaryWithBrackets(Statement class1, Statement class2) {
		return binary(Logic.bracket(class1), Logic.bracket(class2));
	}

	public static Statement nFold(Statement... classes) {
		Statement result = SINGLETON.normal("n_fold product", classes);
		return result;
	}

	public static Statement nFoldFromTo(Statement index, Statement from, Statement to, Statement indexedClass) throws Exception {
		Statement result = SINGLETON.normal("n_fold product from to", index, from, to, indexedClass);
		return result;
	}

	public static Statement power(Statement clasz, Statement exponent) {
		Statement result = SINGLETON.normal("power", clasz, exponent);
		return result;
	}


}
