package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RationalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Difference extends DifferenceFactory implements SetTheorySamples {


	public static Statement DIFFERENCE;

	public static Statement DIFFERENCE_WITH_SELF;
	public static Statement DIFFERENCE_WITH_EMPTY;
	public static Statement DIFFERENCE_IS_SUBSET;
	public static Statement DIFFERENCE_FROM_EMPTY;
	public static Statement DIFFERENCE_AND_SUBCLASSES;

	public static Statement COMPLEMENT;

	public static Statement COMPLEMENT_OF_UNIVERSE_MAPPING;

	public static Statement SYMMETRIC_DIFFERENCE;


	private Difference() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "Difference (relative complement)", null, "Differenz (relatives Komplement)", null);


			titleText(SINGLETON.unit(1), "Difference (1)", null, "Differenz (1)", null);

			DIFFERENCE = difference(A, B);
			DIFFERENCE.setReferences(wikiEn("Complement_(set_theory)"), wikiDe("Komplement_(Mengenlehre)"));
			DIFFERENCE.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			DIFFERENCE.setMain(Bool.definedAsEqualTo(AminusB, ClassesSets.classByPredicate(null, xElemA, xNotElemB)));
			definition(DIFFERENCE, "Difference (relative complement)", null, "Differenz (relatives Komplement)", AminusB,
					" wird gesprochen als 'A ohne B' oder auch geschrieben als A-B 'A minus B'.");
			MathMLGenerator.displayRule(DIFFERENCE, new WriteOperation("\\"));
			DIFFERENCE.setExamples(RationalNumbers.SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO.getMain().get(0));


			DIFFERENCE_WITH_SELF = SINGLETON.normal("DIFFERENCE_WITH_SELF");
			DIFFERENCE_WITH_SELF.setReferences(wikiEn("Complement_(set_theory)"), wikiDe("Komplement_(Mengenlehre)"));
			DIFFERENCE_WITH_SELF.be(ClassesSets.clasz(A));
			DIFFERENCE_WITH_SELF.setMain(Logic.equals(difference(A, A), EmptySet.EMPTY_SET));
			lemma(DIFFERENCE_WITH_SELF, null, null, "Differenz mit sich selbst", null);
			DIFFERENCE_WITH_SELF.setProofs(Logic.equalsMultiline(//
					difference(A, A), //
					ClassesSets.classByPredicate(null, ClassesSets.elementOf(x, A), ClassesSets.notElementOf(x, A)), //
					ClassesSets.classByPredicate(null, x, Bool.and(ClassesSets.elementOf(x, A), ClassesSets.notElementOf(x, A))), //
					ClassesSets.classByPredicate(null, x, Bool.FALSUM), //
					EmptySet.EMPTY_SET)); //


			DIFFERENCE_WITH_EMPTY = SINGLETON.normal("DIFFERENCE_WITH_EMPTY");
			DIFFERENCE_WITH_EMPTY.setReferences(wikiEn("Complement_(set_theory)"), wikiDe("Komplement_(Mengenlehre)"));
			DIFFERENCE_WITH_EMPTY.be(ClassesSets.clasz(A));
			DIFFERENCE_WITH_EMPTY.setMain(Logic.equals(difference(A, EmptySet.EMPTY_SET), A));
			lemma(DIFFERENCE_WITH_EMPTY, null, null, "Differenz mit der leeren Menge", null);
			DIFFERENCE_WITH_EMPTY.setProofs(Logic.equalsMultiline(//
					difference(A, EmptySet.EMPTY_SET), //
					ClassesSets.classByPredicate(null, ClassesSets.elementOf(x, A), ClassesSets.notElementOf(x, EmptySet.EMPTY_SET)), //
					ClassesSets.classByPredicate(null, x, Bool.and(ClassesSets.elementOf(x, A), ClassesSets.notElementOf(x, EmptySet.EMPTY_SET))), //
					ClassesSets.classByPredicate(null, x, Bool.and(ClassesSets.elementOf(x, A), Bool.VERUM)), //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, A)), //
					A)); //

			DIFFERENCE_IS_SUBSET = SINGLETON.normal("DIFFERENCE_IS_SUBSET");
			DIFFERENCE_IS_SUBSET.setReferences(ml1("1.6.2"));
			DIFFERENCE_IS_SUBSET.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			DIFFERENCE_IS_SUBSET.setMain(Subset.subset(difference(A, B), A));
			lemma(DIFFERENCE_IS_SUBSET, null, null, "Differenz ist Teilklasse", null);
			DIFFERENCE_IS_SUBSET.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, difference(A, B)), //
					Bool.and(ClassesSets.elementOf(x, A), ClassesSets.notElementOf(x, B)), //
					ClassesSets.elementOf(x, A)));

			DIFFERENCE_FROM_EMPTY = SINGLETON.normal("DIFFERENCE_FROM_EMPTY");
			DIFFERENCE_FROM_EMPTY.setReferences(wikiEn("Complement_(set_theory)"), wikiDe("Komplement_(Mengenlehre)"));
			DIFFERENCE_FROM_EMPTY.be(ClassesSets.clasz(A));
			DIFFERENCE_FROM_EMPTY.setMain(Logic.equals(difference(EmptySet.EMPTY_SET, A), EmptySet.EMPTY_SET));
			lemma(DIFFERENCE_FROM_EMPTY, null, null, "Differenz von der leeren Menge", null);
			DIFFERENCE_FROM_EMPTY.setProofs(
					Subset.equalsBySubclasses(Basics.proofline(Subset.subclass(difference(EmptySet.EMPTY_SET, A), EmptySet.EMPTY_SET), DIFFERENCE_IS_SUBSET),
							Basics.proofline(Subset.subclass(EmptySet.EMPTY_SET, difference(EmptySet.EMPTY_SET, A)), EmptySet.EMPTY_SET_IS_SUBCLASS)));

			DIFFERENCE_AND_SUBCLASSES = SINGLETON.normal("DIFFERENCE_AND_SUBCLASSES");
			DIFFERENCE_AND_SUBCLASSES.be(classA, classB, classC, classD);
			DIFFERENCE_AND_SUBCLASSES.setMain(
					Bool.impliesWithBrackets(Bool.and(Subset.subclass(A, B), Subset.subclass(C, D)), Subset.subclass(difference(A, D), difference(B, C))));
			lemma(DIFFERENCE_AND_SUBCLASSES, null, null, "Differenz bei Teilklassen", null);
			DIFFERENCE_AND_SUBCLASSES.setProofs(Basics.multiline(Basics.be(Bool.and(Subset.subclass(A, B), Subset.subclass(C, D))),
					Bool.impliesMultiline( //
							ClassesSets.elementOf(x, difference(A, D)), //
							Bool.and(ClassesSets.elementOf(x, A), ClassesSets.notElementOf(x, D)), //
							Bool.and(ClassesSets.elementOf(x, B), ClassesSets.notElementOf(x, D)), //
							Bool.and(ClassesSets.elementOf(x, B), ClassesSets.notElementOf(x, C)), //
							ClassesSets.elementOf(x, difference(B, C))//
					//
					)));

			titleText(SINGLETON.unit(2), "Difference (2)", null, "Differenz (2)", null);

			COMPLEMENT = complement(null);
			COMPLEMENT.setReferences(wikiEn("Complement_(set_theory)"), wikiDe("Komplement_(Mengenlehre)"));
			COMPLEMENT.be(Basics.blankSeparated(U, "ein vorgegebenes Universum"), ClassesSets.clasz(B));
			COMPLEMENT.setMain(Logic.definedAs(Bcomplement, UminusB));
			definition(COMPLEMENT, "(absolute) complement", null, "(Absolutes) Komplement",
					"Um das Universum zu verdeutlichen, gibt es auch folgende Schreibweisen: ", Basics.mantissaIndex(C, U), B, ",", Basics.mantissaIndex(C, U),
					Logic.bracket(B));
			MathMLGenerator.displayRule(COMPLEMENT,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, SECOND_VARIABLE, Basics.EMPTY, c));

			COMPLEMENT_OF_UNIVERSE_MAPPING = complementOfUniverseMapping(null);
			COMPLEMENT_OF_UNIVERSE_MAPPING.setReferences(ml2("2.6.6"));
			COMPLEMENT_OF_UNIVERSE_MAPPING.be(Basics.blankSeparated(U, "eine Menge als vorgegebenes Universum"));
			// COMPLEMENT_OF_UNIVERSE_MAPPING.setMain(Logic.definedAs(Bcomplement, UminusB));
			definition(COMPLEMENT_OF_UNIVERSE_MAPPING, null, null, "Komplementabbildung eines Universums",
					"Mit Hilfe des absoluten Komplement kann man folgende Abbildung definieren: ", complementOfUniverseMapping(U).setDisplayLevel(EXTENDED));
			Object[] Cu = { Basics.MANTISSA_INDEX_EXPONENT, C, FIRST_VARIABLE, Basics.EMPTY };
			Object[] powersetU = new Object[] { Powerset.POWERSET, FIRST_VARIABLE };

			MathMLGenerator.displayRule(COMPLEMENT_OF_UNIVERSE_MAPPING,
					WriteExtended.shortDefault(//
							WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, C, FIRST_VARIABLE, Basics.EMPTY), //
							WriteAfterStatementTransformation.ruleTransformationWithName(Mappings.EXPLICIT_MAPPING, Cu, powersetU, powersetU, X,
									new Object[] { DIFFERENCE, FIRST_VARIABLE, X })));
			// WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, SECOND_VARIABLE, Basics.EMPTY, c));

			SYMMETRIC_DIFFERENCE = symmetricDifference(A, B);
			SYMMETRIC_DIFFERENCE.setReferences(wikiEn("Symmetric_difference"), wikiDe("Menge_(Mathematik)#Symmetrische_Differenz"));
			SYMMETRIC_DIFFERENCE.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			SYMMETRIC_DIFFERENCE.setMain(Logic.definedAs(symmetricDifference(A, B), Union.unionWithBrackets(AminusB, BminusA)));
			definition(SYMMETRIC_DIFFERENCE, "symmetric difference ", null, "symmetrische Differenz", null);
			MathMLGenerator.displayRule(SYMMETRIC_DIFFERENCE, new WriteOperation("∆"));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}

	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(DIFFERENCE, DIFFERENCE_WITH_SELF, DIFFERENCE_WITH_EMPTY, DIFFERENCE_IS_SUBSET,
						DIFFERENCE_FROM_EMPTY, DIFFERENCE_AND_SUBCLASSES),
				Arrays.asList(RationalNumbers.SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO));
	}

	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2, Arrays.asList(COMPLEMENT, COMPLEMENT_OF_UNIVERSE_MAPPING, SYMMETRIC_DIFFERENCE), (List) Arrays.asList());
	}
}
