package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class DifferenceFactory extends Statements {

	protected static final DifferenceFactory SINGLETON = new DifferenceFactory();


	protected DifferenceFactory() {
		super("difference", SetTheory.SINGLETON);
	}


	public static Statement difference(Statement class1, Statement class2) {
		return SINGLETON.normal("difference", class1, class2);
	}

	public static Statement complement(Statement universe, Statement clasz) {
		return SINGLETON.normal("complement", universe, clasz);
	}

	public static Statement complement(Statement clasz) {
		return complement(null, clasz);
	}

	public static Statement complementOfUniverseMapping(Statement universe) {
		return SINGLETON.normal("complementMapping", universe);
	}

	public static Statement symmetricDifference(Statement class1, Statement class2) {
		return SINGLETON.normal("symmetricDifference", class1, class2);
	}

}
