package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Intersection extends IntersectionFactory implements SetTheorySamples {

	public static Statement INTERSECTION;

	public static Statement INTERSECTION_IS_SUBCLASS;

	public static Statement INTERSECTION_WITH_EMTPY_SET;

	public static Statement INTERSECTION_IDEMPOTENT;

	public static Statement ASSOCIATIVE;

	public static Statement COMMUTATIVE;

	public static Statement INTERSECTION_AND_SUBCLASS;

	public static Statement DISJUNCT_CLASSES;

	public static Statement PAIRWISE_DISJOINT;

	public static Statement INTERSECTION_WITH_SUBCLASS;

	public static Statement ARBITRARY_INTERSECTION;
	public static Statement ARBITRARY_INTERSECTION_WITHOUT_INDEX;
	public static Statement ARBITRARY_INTERSECTION_FROM_TO;

	public static Statement ARBITRARY_INTERSECTION_IS_SUBCLASS;

	public static Statement ARBITRARY_INTERSECTION_OF_SUBSET;

	public static Statement INTERSECTION_OF_INTERSECTIONS;

	public static Statement ARBITRARY_INTERSECTION_AND_SUBCLASS;

	public static Statement ARBITRARY_INTERSECTION_OF_SUBSETS;

	private Intersection() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "Intersection", null, "Schnitt(menge)", null);



			Statement setOneTwo = ClassesSets.explicitSetWithoutName(ONE, TWO);


			Statement forAllB_AsubclassB = Logic.forAll(BelemI, AsubclassB);


			titleText(SINGLETON.unit(1), "Intersection (1)", null, "Schnitt(menge) (1)", null);

			INTERSECTION = intersection(A, B);
			INTERSECTION.setReferences(References.wikiEn("Intersection_(set_theory)"), References.wikiDe("Menge_(Mathematik)"), References.ml1("1.4.1"));
			INTERSECTION.setBe(Arrays.asList(ClassesSets.clasz(A), ClassesSets.clasz(B)));
			INTERSECTION.setMain(Arrays.asList(Bool.definedAsEqualTo(intersection(A, B),
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, xElemB)))));
			definition(INTERSECTION, "Intersection", null, "Schnitt (Durchschnitt)", "Bei Mengen spricht man auch von der Schnittmenge. ");
			INTERSECTION.setExamples(//
					Logic.equals(intersection(setOneTwo, ClassesSets.explicitSetWithoutName(THREE, FOUR)), EmptySet.EMPTY_SET)//
					,
					Logic.equals(intersection(ClassesSets.explicitSetWithoutName(ONE, TWO, THREE), ClassesSets.explicitSetWithoutName(THREE, FOUR)),
							ClassesSets.explicitSetWithoutName(THREE))//
					, Logic.equals(intersection(setOneTwo, setOneTwo), setOneTwo)//

			//
			);
			MathMLGenerator.displayRule(INTERSECTION, new WriteOperation("∩"));



			INTERSECTION_IS_SUBCLASS = SINGLETON.normal("intersection is subclass");
			INTERSECTION_IS_SUBCLASS.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			INTERSECTION_IS_SUBCLASS.setMain(Subset.subclass(intersection(A, B), A));
			lemma(INTERSECTION_IS_SUBCLASS, null, null, "Schnitt ist Teilklasse", null);
			INTERSECTION_IS_SUBCLASS.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, intersection(A, B)), //
					Bool.and(xElemA, xElemB), //
					xElemA//
			));

			INTERSECTION_WITH_EMTPY_SET = SINGLETON.naive("intersection with empty set");
			INTERSECTION_WITH_EMTPY_SET.setReferences(References.wikiDe("Leere_Menge"), References.wikiEn("Empty_set"));
			INTERSECTION_WITH_EMTPY_SET.be(ClassesSets.clasz(A));
			INTERSECTION_WITH_EMTPY_SET.setMain(Logic.equals(intersection(A, EmptySet.EMPTY_SET), EmptySet.EMPTY_SET));
			lemma(INTERSECTION_WITH_EMTPY_SET, null, null, "Schnitt mit leerer Menge", null);
			INTERSECTION_WITH_EMTPY_SET.setProofs(Subset.equalsBySubclasses(//
					Basics.proofline(Subset.subclass(intersection(A, EmptySet.EMPTY_SET), EmptySet.EMPTY_SET), INTERSECTION_IS_SUBCLASS), //
					Basics.proofline(Subset.subclass(EmptySet.EMPTY_SET, intersection(A, EmptySet.EMPTY_SET)), EmptySet.EMPTY_SET_IS_SUBCLASS)//
			));


			ASSOCIATIVE = SINGLETON.normal("ASSOCIATIVE");
			ASSOCIATIVE.setReferences(References.wikiEn("Intersection_(set_theory)"));
			ASSOCIATIVE.be(ClassesSets.clasz(A), ClassesSets.clasz(B), ClassesSets.clasz(C));
			ASSOCIATIVE.setMain(Logic.equals(intersection(Logic.bracket(intersection(A, B)), C), intersection(A, Logic.bracket(intersection(B, C)))));
			lemma(ASSOCIATIVE, null, null, "Assoziativgesetz des Schnitts", null);
			ASSOCIATIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, intersection(Logic.bracket(intersection(A, B)), C)), //
					Bool.and(ClassesSets.elementOf(x, Logic.bracket(intersection(A, B))), ClassesSets.elementOf(x, C)), //
					Bool.and(Logic.bracket(Bool.and(xElemA, xElemB)), ClassesSets.elementOf(x, C)), //
					Bool.and(xElemA, Logic.bracket(Bool.and(xElemB, ClassesSets.elementOf(x, C)))), //
					Bool.and(xElemA, ClassesSets.elementOf(x, intersection(B, C))), //
					ClassesSets.elementOf(x, Logic.bracket(intersection(A, Logic.bracket(intersection(B, C))))) //
			));

			COMMUTATIVE = SINGLETON.normal("COMMUTATIVE");
			COMMUTATIVE.setReferences(References.wikiEn("Intersection_(set_theory)"));
			COMMUTATIVE.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			COMMUTATIVE.setMain(Logic.equals(intersection(A, B), intersection(B, A)));
			lemma(COMMUTATIVE, null, null, "Kommutativgesetz des Schnitts ", null);
			COMMUTATIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, intersection(A, B)), //
					Bool.and(xElemA, xElemB), //
					Bool.and(xElemB, xElemA), //
					ClassesSets.elementOf(x, intersection(B, A)) //
			));

			INTERSECTION_AND_SUBCLASS = SINGLETON.normal("INTERSECTION_AND_SUBCLASS");
			INTERSECTION_AND_SUBCLASS.setReferences(References.ml1("1.4.9"));
			INTERSECTION_AND_SUBCLASS.be(ClassesSets.clasz(A), ClassesSets.clasz(B), ClassesSets.clasz(C));
			INTERSECTION_AND_SUBCLASS.setMain(Bool.iff(Bool.and(AsubclassB, AsubclassC), Subset.subclass(A, intersection(B, C))));
			lemma(INTERSECTION_AND_SUBCLASS, null, null, "Schnitte und Teilklassen ", null);
			INTERSECTION_AND_SUBCLASS.setProofs(Bool.iffByIf(//
					Bool.implies(Bool.and(AsubclassB, AsubclassC), Subset.subclass(A, intersection(B, C))), //
					Basics.multiline(Basics.be(Bool.and(AsubclassB, AsubclassC)),
					Bool.impliesMultiline(//
									xElemA, Bool.and(xElemB, ClassesSets.elementOf(x, C)),
									ClassesSets.elementOf(x, intersection(B, C)))),
					Bool.implies(Subset.subclass(A, intersection(B, C)), Bool.and(AsubclassB, AsubclassC)), //
					Basics.multiline(Basics.be(Subset.subclass(A, intersection(B, C))),
					Bool.impliesMultiline(//
									xElemA, ClassesSets.elementOf(x, intersection(B, C)), Bool.and(xElemB, ClassesSets.elementOf(x, C))))
			));

			INTERSECTION_IDEMPOTENT = SINGLETON.naive("INTERSECTION_WITH_SELF");
			INTERSECTION_IDEMPOTENT.setReferences(References.ml1("1.4.11"));
			INTERSECTION_IDEMPOTENT.be(ClassesSets.clasz(A));
			INTERSECTION_IDEMPOTENT.setMain(Logic.equals(intersection(A, A), A));
			lemma(INTERSECTION_IDEMPOTENT, null, null, "Schnitt ist idempotent", null);
			INTERSECTION_IDEMPOTENT.setProofs(Subset.equalsBySubclasses(//
					Basics.proofline(Subset.subclass(intersection(A, A), A), INTERSECTION_IS_SUBCLASS), //
					Basics.proofline(Bool.implies(Bool.and(Subset.subclass(A, A), Subset.subclass(A, A)), Subset.subclass(A, intersection(A, A))),
							INTERSECTION_AND_SUBCLASS)//
			));

			DISJUNCT_CLASSES = disjunctClasses(null, null);
			DISJUNCT_CLASSES.setReferences(References.ml1("1.4.10"));
			DISJUNCT_CLASSES.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			DISJUNCT_CLASSES.setMain(Bool.iff(disjunctClasses(A, B), Logic.equals(intersection(A, B), EmptySet.EMPTY_SET)));
			definition(DISJUNCT_CLASSES, "disjoint classes", null, "disjunkte Klassen", "Statt disjunkter Klassen spricht man auch von punktfremden Klassen.");
			MathMLGenerator.displayRule(DISJUNCT_CLASSES, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
					new Object[] { Basics.COMMA_SEPARATED, FIRST_VARIABLE, SECOND_VARIABLE }, new Object[] { Basics.DEF_NAMES, SELF }));

			PAIRWISE_DISJOINT = pairwiseDisjoint(null);
			PAIRWISE_DISJOINT.setReferences(References.wikiEn("Disjoint_sets"), References.wikiDe("Disjunkt#Definitionen"));
			PAIRWISE_DISJOINT.be(ClassesSets.setOfSets(I), EmptySet.notEmptySet(I));
			PAIRWISE_DISJOINT.setMain(
					Bool.iff(pairwiseDisjoint(I), Logic.forAll(Basics.commaSeparated(AelemI, BelemI),
							Bool.implies(Logic.notEquals(A, B), Logic.equals(intersection(A, B), EmptySet.EMPTY_SET)))));
			definition(PAIRWISE_DISJOINT, "pairwise disjoint", null, "paarweise disjunkt", null);

			INTERSECTION_WITH_SUBCLASS = SINGLETON.naive("INTERSECTION_WITH_SUBCLASS");
			INTERSECTION_WITH_SUBCLASS.setReferences(References.ml1("1.4.11"));
			INTERSECTION_WITH_SUBCLASS.be(ClassesSets.clasz(A));
			INTERSECTION_WITH_SUBCLASS.setMain(Bool.iff(Subset.subclass(B, A), Logic.equals(intersection(A, B), B)));
			lemma(INTERSECTION_WITH_SUBCLASS, null, null, "Schnitt mit Teilklasse", null);
			INTERSECTION_WITH_SUBCLASS.setProofs(
					Bool.iffByIf(//
						Bool.implies(Subset.subclass(B, A), Logic.equals(intersection(A, B), B)),
							
						Subset.equalsBySubclasses(//
						Basics.proofline(Subset.subclass(intersection(A, B), B), INTERSECTION_IS_SUBCLASS), //
						Basics.multiline(Basics.be(xElemB),
								Bool.impliesMultiline(xElemB, //
										Basics.proofline(xElemA, Subset.subclass(B, A)), //
										Bool.and(xElemB, xElemA), ClassesSets.elementOf(x, intersection(A, B))))),

						Bool.implies(Logic.equals(intersection(A, B), B), Subset.subclass(B, A)),
						Basics.multiline(Basics.be(Logic.equals(intersection(A, B), B)),
								Bool.impliesMultiline(xElemB, //
										ClassesSets.elementOf(x, intersection(A, B)),//
										Bool.and(xElemA, xElemB),
										xElemA))


					
					));

			titleText(SINGLETON.unit(2), "Intersection (2)", null, "Schnitt(menge) (2)", null);

			ARBITRARY_INTERSECTION_WITHOUT_INDEX = arbitraryIntersection(null);
			MathMLGenerator.displayRule(ARBITRARY_INTERSECTION_WITHOUT_INDEX, WriteOperation.prefix("∩"));

			ARBITRARY_INTERSECTION_FROM_TO = arbitraryIntersectionFromTo(null, null, null, null);
			MathMLGenerator.displayRule(ARBITRARY_INTERSECTION_FROM_TO, writeIndexedFromTo("∩"));
			// MathMLGenerator.displayRule(ARBITRARY_INTERSECTION_FROM_TO, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
			// new Object[] { Basics.UNDEROVER, "∩", new Object[] { Logic.EQUALS, FIRST_VARIABLE, SECOND_VARIABLE }, THIRD_VARIABLE }, FOURTH_VARIABLE));

			ARBITRARY_INTERSECTION = arbitraryIntersection(null, null, null);
			ARBITRARY_INTERSECTION.setReferences(References.wikiDe("Menge_(Mathematik)"), References.wikiEn("Intersection_(set_theory)"),
					References.ml1("1.5.2"));
			ARBITRARY_INTERSECTION.be(nonEmptySetOfSetsI);
			ARBITRARY_INTERSECTION.setMain(Logic.multipleDefinitions(arbitraryIntersection(I), arbitraryIntersection(A, I, A),
					ClassesSets.classByPredicate(null, x, Logic.forAll(ClassesSets.elementOf(A, I), xElemA))));
			lemma(ARBITRARY_INTERSECTION, "arbitrary intersection", null, "Verallgemeinerter Durchschnitt",
					"Man verwendet auch die Schreibung ", arbitraryIntersection(i, I, A_i), ". In diesem Fall ist ", I, " eine Indexmenge, die ", A_i,
					" sind Mengen und die eigentliche Menge der Mengen ist ", ClassesSets.classByPredicate(null, A_i, ClassesSets.elementOf(i, I)),
					". Lässt sich die Indexmenge ordnen, z.B. die natürlichen Zahlen von 1 bis n, so schreibt man auch ",
					arbitraryIntersectionFromTo(i, ONE, n, A_i), " oder für alle natürlichen Zahlen ", arbitraryIntersectionFromTo(i, ONE, INFINITE, A_i),
					". Analoge Schreibweisen gibt es auch bei anderen Operationen.");
			Statement A_1_2 = ClassesSets.explicitSet(null, A_1, A_2);
			MathMLGenerator.displayRule(ARBITRARY_INTERSECTION,
					WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
							new Object[] { Basics.UNDEROVER, "∩", new Object[] { ClassesSets.ELEMENT_OF, FIRST_VARIABLE, SECOND_VARIABLE }, ""/* NULL */ },
							THIRD_VARIABLE));
			ARBITRARY_INTERSECTION.setExamples(
					Logic.equals(arbitraryIntersection(A_1_2), ClassesSets.classByPredicate(null, x, Logic.forAll(ClassesSets.elementOf(A, A_1_2), xElemA)),
							ClassesSets.classByPredicate(null, x, Bool.and(ClassesSets.elementOf(x, A_1), ClassesSets.elementOf(x, A_2))),
							intersection(A_1, A_2)), //
					Logic.equals(arbitraryIntersectionFromTo(i, ONE, ONE, A_i), A_1)
			);

			ARBITRARY_INTERSECTION_IS_SUBCLASS = SINGLETON.normal("ARBITRARY_INTERSECTION_IS_SUBCLASS");
			ARBITRARY_INTERSECTION_IS_SUBCLASS.setReferences(References.ml1("1.5.6"));
			ARBITRARY_INTERSECTION_IS_SUBCLASS.be(nonEmptySetOfSetsI, BelemI);
			ARBITRARY_INTERSECTION_IS_SUBCLASS.setMain(Subset.subclass(arbitraryIntersection(I), B));
			lemma(ARBITRARY_INTERSECTION_IS_SUBCLASS, null, null, "Schnitt ist Teilmenge", null);
			ARBITRARY_INTERSECTION_IS_SUBCLASS.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, arbitraryIntersection(I)), //
					Logic.forAll(ClassesSets.elementOf(A, I), xElemA), //
					Basics.proofline(xElemB, BelemI)
			));

			ARBITRARY_INTERSECTION_OF_SUBSET = SINGLETON.normal("ARBITRARY_INTERSECTION_OF_SUBSET");
			ARBITRARY_INTERSECTION_OF_SUBSET.setReferences(References.ml1("1.5.6"));
			ARBITRARY_INTERSECTION_OF_SUBSET.be(nonEmptySetOfSetsI, Subset.subset(J, I), EmptySet.notEmptySet(J));
			ARBITRARY_INTERSECTION_OF_SUBSET.setMain(Subset.superclass(arbitraryIntersection(J), arbitraryIntersection(I)));
			lemma(ARBITRARY_INTERSECTION_OF_SUBSET, null, null, "Schnitt über Teilmenge ist größer", null);
			ARBITRARY_INTERSECTION_OF_SUBSET.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, arbitraryIntersection(I)), Logic.forAll(ClassesSets.elementOf(A, I), xElemA),
					Basics.proofline(Logic.forAll(ClassesSets.elementOf(A, J), xElemA), Subset.subset(J, I)),
					ClassesSets.elementOf(x, arbitraryIntersection(J))//
			));

			INTERSECTION_OF_INTERSECTIONS = SINGLETON.normal("INTERSECTION_OF_INTERSECTIONS");
			INTERSECTION_OF_INTERSECTIONS.setReferences(References.ml1("1.5.6"));
			INTERSECTION_OF_INTERSECTIONS.be(nonEmptySetOfSetsI, ClassesSets.setOfSets(J), EmptySet.notEmptySet(J));
			INTERSECTION_OF_INTERSECTIONS
					.setMain(Logic.equals(intersection(Logic.bracket(arbitraryIntersection(A, I, A)), Logic.bracket(arbitraryIntersection(A, J, A))),
							arbitraryIntersection(A, Union.union(I, J), A)));
			lemma(INTERSECTION_OF_INTERSECTIONS, null, null, "Schnitt zweier verallgemeinerter Schnitte", null);
			INTERSECTION_OF_INTERSECTIONS.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, arbitraryIntersection(A, Union.union(I, J), A)), //
					Logic.forAll(ClassesSets.elementOf(A, Union.union(I, J)), xElemA), //
					Bool.andWithBrackets(Logic.forAll(ClassesSets.elementOf(A, I), xElemA), Logic.forAll(ClassesSets.elementOf(A, J), xElemA)), //
					Bool.andWithBrackets(ClassesSets.elementOf(x, arbitraryIntersection(A, I, A)),
							ClassesSets.elementOf(x, arbitraryIntersection(A, J, A))), //
					ClassesSets.elementOf(x, intersection(Logic.bracket(arbitraryIntersection(A, I, A)), Logic.bracket(arbitraryIntersection(A, J, A))))));
			INTERSECTION_OF_INTERSECTIONS.setExamples(//
					Logic.equals(arbitraryIntersectionFromTo(i, ONE, nPlus1, A_i),
							intersection(Logic.bracket(arbitraryIntersectionFromTo(i, ONE, n, A_i)), Logic.var("A", nPlus1)))//
			);

			ARBITRARY_INTERSECTION_AND_SUBCLASS = SINGLETON.normal("ARBITRARY_INTERSECTION_AND_SUBCLASS");
			ARBITRARY_INTERSECTION_AND_SUBCLASS.setReferences(References.ml1("1.5.10"));
			ARBITRARY_INTERSECTION_AND_SUBCLASS.be(ClassesSets.clasz(A), nonEmptySetOfSetsI);
			ARBITRARY_INTERSECTION_AND_SUBCLASS.setMain(Bool.iff(forAllB_AsubclassB, Subset.subclass(A, arbitraryIntersectionIB)));
			lemma(ARBITRARY_INTERSECTION_AND_SUBCLASS, null, null, "Verallgemeinerte Schnitte und Teilklassen ", null);
			ARBITRARY_INTERSECTION_AND_SUBCLASS.setProofs(Bool.iffByIf(//
					Bool.implies(forAllB_AsubclassB, Subset.subclass(A, arbitraryIntersectionIB)), //
					Basics.multiline(Basics.be(forAllB_AsubclassB),
							Bool.impliesMultiline(//
									xElemA, //
									Logic.forAll(BelemI, Bool.and(xElemA, AsubclassB)), //
									Logic.forAll(BelemI, xElemB), //
									ClassesSets.elementOf(x, arbitraryIntersectionIB))),
					Bool.implies(Subset.subclass(A, arbitraryIntersectionIB), forAllB_AsubclassB), //
					Basics.multiline(//
							Basics.be(Subset.subclass(A, arbitraryIntersectionIB)), //
							Bool.impliesMultiline(//
									xElemA, //
									ClassesSets.elementOf(x, arbitraryIntersectionIB), //
									Logic.forAll(BelemI, xElemB))))//
			);

			ARBITRARY_INTERSECTION_OF_SUBSETS = SINGLETON.normal("ARBITRARY_INTERSECTION_OF_SUBSETS");
			ARBITRARY_INTERSECTION_OF_SUBSETS.setReferences(References.ml1("1.5.11"));
			ARBITRARY_INTERSECTION_OF_SUBSETS.be(nonEmptySetI, Logic.forAll(iElemI, Basics.commaSeparated(ClassesSets.clasz(A_i).cloneWithDisplayIdentifyingName(), ClassesSets.clasz(B_i).cloneWithDisplayIdentifyingName())));
			ARBITRARY_INTERSECTION_OF_SUBSETS.setMain(Bool.implies(Logic.forAll(iElemI, Subset.subclass(A_i, B_i)),
					Subset.subclass(arbitraryIntersection(i, I, A_i), arbitraryIntersection(i, I, B_i))));
			lemma(ARBITRARY_INTERSECTION_OF_SUBSETS, null, null, "Verallgemeinerte Schnitte von Teilklassen ", null);
			ARBITRARY_INTERSECTION_OF_SUBSETS.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, arbitraryIntersectionAi),//
					Logic.forAll(iElemI, ClassesSets.elementOf(x, A_i)),//
					Logic.forAll(iElemI, ClassesSets.elementOf(x, B_i)), //
					ClassesSets.elementOf(x, arbitraryIntersectionBi)//
					//
					));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(INTERSECTION, INTERSECTION_IS_SUBCLASS, INTERSECTION_WITH_EMTPY_SET, ASSOCIATIVE, COMMUTATIVE,
						INTERSECTION_AND_SUBCLASS, INTERSECTION_IDEMPOTENT, DISJUNCT_CLASSES, PAIRWISE_DISJOINT, INTERSECTION_WITH_SUBCLASS),
				(List) Arrays.asList());
	}

	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2,
				Arrays.asList(ARBITRARY_INTERSECTION, ARBITRARY_INTERSECTION_IS_SUBCLASS, ARBITRARY_INTERSECTION_OF_SUBSET, INTERSECTION_OF_INTERSECTIONS,
						ARBITRARY_INTERSECTION_AND_SUBCLASS, ARBITRARY_INTERSECTION_OF_SUBSETS),
				Arrays.asList(ARBITRARY_INTERSECTION_WITHOUT_INDEX, ARBITRARY_INTERSECTION_FROM_TO));
	}


}
