package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class IntersectionFactory extends Statements {

	protected static final IntersectionFactory SINGLETON = new IntersectionFactory();


	protected IntersectionFactory() {
		super("intersection", SetTheory.SINGLETON);
	}


	public static Statement intersection(Statement class1, Statement class2) {
		return SINGLETON.normal("intersection", class1, class2);
	}

	public static Statement intersectionWithBrackets(Statement class1, Statement class2) {
		return intersection(Logic.bracket(class1), Logic.bracket(class2));
	}

	public static Statement disjunctClasses(Statement class1, Statement class2) {
		return SINGLETON.normal("disjunctClasses", class1, class2);
	}

	public static Statement pairwiseDisjoint(Statement setOfSets) {
		return SINGLETON.normal("pairwiseDisjoint", setOfSets);
	}

	public static Statement arbitraryIntersection(Statement index, Statement indexSet, Statement indexedSet) {
		return SINGLETON.normal("arbitraryIntersection", index, indexSet, indexedSet);
	}

	public static Statement arbitraryIntersectionFromTo(Statement index, Statement from, Statement to, Statement indexedSet) {
		return SINGLETON.normal("arbitraryIntersectionFromTo", index, from, to, indexedSet);
	}

	public static Statement arbitraryIntersection(Statement setOfSets) {
		return SINGLETON.normal("arbitraryIntersection2", setOfSets);
	}

}
