package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class Powerset extends Statements implements SetTheorySamples {

	private static final Powerset SINGLETON = new Powerset();

	public static Statement POWERSET;

	public static Statement POWERSET_NOT_EMPTY;

	public static Statement POWERSET_KEEPS_SUBSETS;

	public static Statement POWERSET_UNION;

	public static Statement POWERSET_UNION_2;

	public static Statement POWERSET_OF_INTERSECTION;

	private Powerset() {
		super("Powerset", SetTheory.SINGLETON);
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "powerset", null, "Potenzmenge", null);
			titleText(SINGLETON.unit(1), "powerset", null, "Potenzmenge", null);

			Statement powersetA = powerset(A);
			Statement powersetB = powerset(B);

			POWERSET = powerset(null);
			POWERSET.setReferences(References.wikiEn("Power_set"), References.wikiDe("Potenzmenge"), References.ml1("1.7.1"));
			POWERSET.be(setA);
			POWERSET.setMain(Logic.definedAs(powersetA, ClassesSets.classByPredicate(null, B, Subset.subset(B, A))));
			definition(POWERSET, "powerset", null, "Potenzmenge", "Die Menge aller Teilmengen.");
			MathMLGenerator.displayRule(POWERSET, new WriteOperation("P(", null, ")"));
			POWERSET.setExamples(//
					Logic.equals(powerset(Bool.BOOLEAN_SET), ClassesSets.explicitSetWithoutName(EMPTY_SET, ClassesSets.explicitSetWithoutName(Bool.VERUM),
							ClassesSets.explicitSetWithoutName(Bool.FALSUM), ClassesSets.explicitSetWithoutName(Bool.VERUM, Bool.FALSUM))),
					Logic.equals(powerset(EmptySet.EMPTY_SET), ClassesSets.explicitSetWithoutName(EMPTY_SET)),
					Basics.comment(
							"In der Statistik wird die (bzw. eine Teilmenge der) Potenzmenge des Ausgangsraum Ω als Ereignissystem bezeichnet ('System', da Menge von Mengen). Ein Element davon (eine Teilmenge von Ω) heißt Ereignis.")
			//
			);

			POWERSET_NOT_EMPTY = SINGLETON.normal("POWERSET_NOT_EMPTY");
			POWERSET_NOT_EMPTY.setReferences(References.ml1("1.7.3"));
			POWERSET_NOT_EMPTY.be(setA);
			POWERSET_NOT_EMPTY.setMain(EmptySet.notEmptySet(powersetA));
			POWERSET_NOT_EMPTY.setProofs(Bool.implies(Subset.subclass(EmptySet.EMPTY_SET, A), ClassesSets.elementOf(EmptySet.EMPTY_SET, powersetA)));
			lemma(POWERSET_NOT_EMPTY, null, null, "Potenzmenge nicht leer", "Jede Potenzmenge ist nicht leer");

			POWERSET_KEEPS_SUBSETS = SINGLETON.normal("POWERSET_KEEPS_SUBSETS");
			POWERSET_KEEPS_SUBSETS.setReferences(References.ml1("1.7.3"));
			POWERSET_KEEPS_SUBSETS.be(setA, setB);
			POWERSET_KEEPS_SUBSETS.setMain(Bool.iff(Subset.subset(A, B), Subset.subset(powersetA, powersetB)));
			lemma(POWERSET_KEEPS_SUBSETS, null, null, "Potenzmenge erhält Teilmengenbeziehung", null);
			POWERSET_KEEPS_SUBSETS.setProofs(
					Bool.iffByIf(//
						Bool.implies(Subset.subset(A, B), Subset.subset(powersetA, powersetB)),// 
						Bool.impliesMultiline(//
								ClassesSets.elementOf(X, powersetA), //
								Subset.subset(X, A), //
								Subset.subset(X, B), //
								ClassesSets.elementOf(X, powersetB)), //
					Bool.impliedBy(Subset.subset(A, B), Subset.subset(powersetA, powersetB)),
					Bool.impliesMultiline(//
							Subset.subset(A, A),
							ClassesSets.elementOf(A, powersetA), //
							ClassesSets.elementOf(A, powersetB), //
									Subset.subset(A, B)//
					)
			));

			POWERSET_UNION = SINGLETON.normal("POWERSET_UNION");
			POWERSET_UNION.setReferences(References.ml1("1.7.5"));
			POWERSET_UNION.be(setA, setB);
			POWERSET_UNION.setMain(Subset.subset(Union.union(powersetA, powersetB), powerset(AunionB)));
			lemma(POWERSET_UNION, null, null, "Vereinigung von Potenzmengen (1)", null);
			POWERSET_UNION.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(X, Union.union(powersetA, powersetB)), //
					Bool.or(Subset.subset(X, A), Subset.subset(X, B)), //
					Subset.subset(X, AunionB), //
					ClassesSets.elementOf(X, powerset(AunionB)) //
			));

			POWERSET_UNION_2 = SINGLETON.normal("POWERSET_UNION_2");
			POWERSET_UNION_2.setReferences(References.ml1("1.7.5"));
			POWERSET_UNION_2.be(setA, setB);
			Statement powerAunionPowerB = Union.union(powersetA, powersetB);
			Statement left = Logic.equals(powerAunionPowerB, powerset(AunionB));
			Statement right = Bool.or(AsubclassB, BsubclassA);
			POWERSET_UNION_2.setMain(Bool.iff(left, right));
			lemma(POWERSET_UNION_2, null, null, "Vereinigung von Potenzmengen (2)", null);
			POWERSET_UNION_2.setProofs(Bool.iffByIf(Bool.implies(left, right), //
					Bool.impliesMultiline(//
							Subset.subset(AunionB, AunionB), //
							ClassesSets.elementOf(AunionB, powerset(AunionB)), //
							Bool.or(ClassesSets.elementOf(AunionB, powerset(A)), ClassesSets.elementOf(AunionB, powerset(B))), //
							Bool.or(Subset.subset(AunionB, A), Subset.subset(AunionB, B)), //
							Bool.or(Subset.subclasses(B, AunionB, A), Subset.subclasses(A, AunionB, B)) //
					), //
					Bool.implies(right, left), //
					Bool.impliesMultiline(//
							Basics.blankSeparated(Basics.WLOG, Basics.BE, AsubclassB),
							Subset.subset(Logic.equals(powerset(AunionB), powersetB), powerAunionPowerB),
							Basics.proofline(Logic.equals(powerset(AunionB), powerAunionPowerB), POWERSET_UNION))//
			));

			POWERSET_OF_INTERSECTION = SINGLETON.normal("POWERSET_OF_INTERSECTION");
			POWERSET_OF_INTERSECTION.setReferences(References.ml1("1.7.8"));
			POWERSET_OF_INTERSECTION.be(setA, setB);
			POWERSET_OF_INTERSECTION.setMain(Logic.equals(powerset(AinterB), Intersection.intersection(powersetA, powersetB)));
			lemma(POWERSET_OF_INTERSECTION, null, null, "Potenzmenge eines Schnitts ist Schnitt der Potenzmengen", null);
			POWERSET_OF_INTERSECTION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(X, powerset(AinterB)), //
					Subset.subset(X, AinterB), //
					Bool.and(Subset.subset(X, A), Subset.subset(X, B)), //
					Bool.and(ClassesSets.elementOf(X, powersetA), ClassesSets.elementOf(X, powersetB)), //
					ClassesSets.elementOf(X, Intersection.intersection(powersetA, powersetB))
			//
			));


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}

	public static Statement powerset(Statement set) {
		return SINGLETON.normal("powerset", set);
	}

	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(POWERSET, POWERSET_NOT_EMPTY, POWERSET_KEEPS_SUBSETS, POWERSET_UNION, POWERSET_UNION_2, POWERSET_OF_INTERSECTION,
						Subset.SUBCLASS_RELATION),
				(List) Arrays.asList());
	}
	
}
