package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Union extends UnionFactory implements SetTheorySamples {


	public static Statement UNION;
	public static Statement DISJOINT_UNION;
	public static Statement UNION_IS_SUPERCLASS;
	public static Statement UNION_WITH_EMTPY_SET;
	public static Statement ASSOCIATIVE;
	public static Statement COMMUTATIVE;
	public static Statement UNION_AND_SUBCLASS;
	public static Statement UNION_IDEMPOTENT;
	public static Statement UNION_WITH_SUBCLASS;

	public static Statement ARBITRARY_UNION;
	public static Statement ARBITRARY_DISJOINT_UNION;
	public static Statement ARBITRARY_DISJOINT_UNION_WITHOUT_INDEX;
	public static Statement ARBITRARY_UNION_WITHOUT_INDEX;
	public static Statement ARBITRARY_UNION_FROM_TO;
	public static Statement ARBITRARY_UNION_IS_SUPERCLASS;
	public static Statement ARBITRARY_UNION_OF_SUBSET;
	public static Statement UNION_OF_UNIONS;
	public static Statement ARBITRARY_UNION_AND_SUBCLASS;
	public static Statement ARBITRARY_UNION_OF_SUBSETS;
	public static Statement PARTITION;

	private Union() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "Union", null, "Vereinigung(smenge)", null);



			Statement setOneTwo = ClassesSets.explicitSetWithoutName(ONE, TWO);
			
			Statement forAllB_BsubclassA = Logic.forAll(BelemI, BsubclassA);

			

			titleText(SINGLETON.unit(1), "Union (1)", null, "Vereinigung(smenge) (1)", null);

			DISJOINT_UNION = disjointUnion(null, null);
			definition(DISJOINT_UNION, "disjoint union", null, "disjunkte Vereinigung",
					"Die gewöhnliche Vereinigung, wobei die beiden Klassen aber disjunkt (d.h. mit leerer Schnittmenge) sind. ");
			MathMLGenerator.displayRule(DISJOINT_UNION, new WriteOperation("⊍"));

			UNION = union(A, B);
			UNION.setReferences(wikiEn("Union_(set_theory)"), wikiDe("Menge_(Mathematik)"), ml1("1.4.1"));
			UNION.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			UNION.setMain(
					Arrays.asList(Bool.definedAsEqualTo(union(A, B),
							ClassesSets.classByPredicate(null, x, Bool.or(xElemA, xElemB)))));
			definition(UNION, "Union", null, "Vereinigung",
					"Bei Mengen spricht man auch von der Vereinigungsmenge. Sind die beiden Klassen disjunkt (haben keine gemeinsamen Elemente) schreibt man auch ",
					disjointUnion(A, B));
			UNION.setExamples(//
					Logic.equals(union(setOneTwo, ClassesSets.explicitSetWithoutName(THREE, FOUR)), ClassesSets.explicitSetWithoutName(ONE, TWO, THREE, FOUR))//
					,
					Logic.equals(union(ClassesSets.explicitSetWithoutName(ONE, TWO, THREE), ClassesSets.explicitSetWithoutName(THREE, FOUR)),
							ClassesSets.explicitSetWithoutName(ONE, TWO, THREE, FOUR))//
					, Logic.equals(union(setOneTwo, setOneTwo), setOneTwo)//

			//
			);
			MathMLGenerator.displayRule(UNION, new WriteOperation("∪"));


			UNION_IS_SUPERCLASS = SINGLETON.normal("union is superclass");
			UNION_IS_SUPERCLASS.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			UNION_IS_SUPERCLASS.setMain(Subset.superclass(union(A, B), A));
			lemma(UNION_IS_SUPERCLASS, null, null, "Vereinigung ist Oberklasse", null);
			UNION_IS_SUPERCLASS.setProofs(Bool.impliesMultiline(//
					xElemA, Bool.or(xElemA, xElemB),
					ClassesSets.elementOf(x, union(A, B)) //
			));

			UNION_WITH_EMTPY_SET = SINGLETON.naive("union with empty set");
			UNION_WITH_EMTPY_SET.setReferences(wikiDe("Leere_Menge"), wikiEn("Empty_set"));
			UNION_WITH_EMTPY_SET.be(ClassesSets.clasz(A));
			UNION_WITH_EMTPY_SET.setMain(Logic.equals(union(A, EmptySet.EMPTY_SET), A));
			lemma(UNION_WITH_EMTPY_SET, null, null, "Vereinigung mit leerer Menge", null);
			UNION_WITH_EMTPY_SET.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, union(A, EmptySet.EMPTY_SET)), //
					Bool.or(xElemA, ClassesSets.elementOf(x, EmptySet.EMPTY_SET)), //
					Bool.or(xElemA, Logic.notEquals(x, x)), //
					Bool.or(xElemA, Bool.FALSUM), //
					xElemA//
			));

			ASSOCIATIVE = SINGLETON.normal("UNION_ASSOCIATIVE");
			ASSOCIATIVE.setReferences(wikiEn("Union_(set_theory)"));
			ASSOCIATIVE.be(ClassesSets.clasz(A), ClassesSets.clasz(B), ClassesSets.clasz(C));
			ASSOCIATIVE.setMain(Logic.equals(union(Logic.bracket(union(A, B)), C), union(A, Logic.bracket(union(B, C)))));
			lemma(ASSOCIATIVE, null, null, "Assoziativgesetz der Vereinigung ", null);
			ASSOCIATIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, union(Logic.bracket(union(A, B)), C)), //
					Bool.or( ClassesSets.elementOf(x, Logic.bracket(union(A, B))), ClassesSets.elementOf(x,C)), //
					Bool.or(Logic.bracket(Bool.or(xElemA, xElemB)), ClassesSets.elementOf(x, C)), //
					Bool.or(xElemA, Logic.bracket(Bool.or(xElemB, ClassesSets.elementOf(x, C)))), //
					Bool.or(xElemA, ClassesSets.elementOf(x, union(B, C))), //
					ClassesSets.elementOf(x, Logic.bracket(union(A, Logic.bracket(union(B, C))))) //
			));

			COMMUTATIVE = SINGLETON.normal("UNION_COMMUTATIVE");
			COMMUTATIVE.setReferences(wikiEn("Union_(set_theory)"));
			COMMUTATIVE.be(ClassesSets.clasz(A), ClassesSets.clasz(B));
			COMMUTATIVE.setMain(Logic.equals(union(A, B), union(B, A)));
			lemma(COMMUTATIVE, null, null, "Kommutativgesetz der Vereinigung ", null);
			COMMUTATIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, union(A, B)), //
					Bool.or(xElemA, xElemB), //
					Bool.or(xElemB, xElemA), //
					ClassesSets.elementOf(x, union(B, A)) //
			));

			UNION_AND_SUBCLASS = SINGLETON.normal("UNION_AND_SUBCLASS");
			UNION_AND_SUBCLASS.setReferences(ml1("1.4.9"));
			UNION_AND_SUBCLASS.be(ClassesSets.clasz(A), ClassesSets.clasz(B), ClassesSets.clasz(C));
			UNION_AND_SUBCLASS.setMain(Bool.iff(Bool.and(AsubclassC, BsubclassC), Subset.subclass(union(A, B), C)));
			lemma(UNION_AND_SUBCLASS, null, null, "Vereinigung und Teilklassen ", null);
			UNION_AND_SUBCLASS.setProofs(Bool.iffByIf(//
					Bool.implies(Bool.and(AsubclassC, BsubclassC), Subset.subclass(union(A, B), C)), //
					Basics.multiline(Basics.be(Bool.and(AsubclassC, BsubclassC)),
							Bool.impliesMultiline(//
									ClassesSets.elementOf(x, union(A, B)), //
									Bool.or(xElemA, xElemB), //
									Bool.or(ClassesSets.elementOf(x, C), ClassesSets.elementOf(x, C)), //
									ClassesSets.elementOf(x, C))),
					Bool.implies(Subset.subclass(union(A, B), C), Bool.and(AsubclassC, BsubclassC)), //
					Basics.multiline(Basics.be(Subset.subclass(union(A, B), C)),
							Bool.and(Subset.superclass(C, union(A, B), A), Subset.superclass(C, union(A, B), B)))));

			UNION_IDEMPOTENT = SINGLETON.naive("UNION_WITH_SELF");
			UNION_IDEMPOTENT.setReferences(ml1("1.4.11"));
			UNION_IDEMPOTENT.be(ClassesSets.clasz(A));
			UNION_IDEMPOTENT.setMain(Logic.equals(union(A, A), A));
			lemma(UNION_IDEMPOTENT, null, null, "Vereinigung ist idempotent", null);
			UNION_IDEMPOTENT.setProofs(Subset.equalsBySubclasses(//
					Basics.proofline(Subset.superclass(union(A, A), A), UNION_IS_SUPERCLASS), //
					Basics.proofline(Bool.implies(Bool.and(Subset.subclass(A, A), Subset.subclass(A, A)), Subset.subclass(union(A, A), A)),
							UNION_AND_SUBCLASS)//
			));

			UNION_WITH_SUBCLASS = SINGLETON.naive("UNION_WITH_SUBCLASS");
			UNION_WITH_SUBCLASS.setReferences(ml1("1.4.11"));
			UNION_WITH_SUBCLASS.be(ClassesSets.clasz(A));
			UNION_WITH_SUBCLASS.setMain(Bool.iff(Subset.subclass(B, A), Logic.equals(union(A, B), A)));
			lemma(UNION_WITH_SUBCLASS, null, null, "Vereinigung mit Teilklasse", null);
			UNION_WITH_SUBCLASS.setProofs(Bool.iffByIf(//
					Bool.implies(Subset.subclass(B, A), Logic.equals(union(A, B), A)),

					Subset.equalsBySubclasses(//
							Bool.impliesMultiline(Basics.be(ClassesSets.elementOf(x, union(A, B))), //
									Bool.or(xElemA, xElemB), //
											Basics.proofline(xElemA, Subset.subclass(B, A)) //
									), //
							Basics.proofline(Subset.superclass(union(A, B), A), UNION_IS_SUPERCLASS) //

					),

					Bool.implies(Logic.equals(union(A, B), A), Subset.subclass(B, A)),
					Basics.multiline(Basics.be(Logic.equals(union(A, B), A)),
							Bool.impliesMultiline(xElemB, //
									ClassesSets.elementOf(x, union(A, B)), //
									xElemA))

			));

			titleText(SINGLETON.unit(2), "Union (2)", null, "Vereinigung(smenge) (2)", null);

			ARBITRARY_DISJOINT_UNION_WITHOUT_INDEX = arbitraryDisjointUnion(null);
			definition(ARBITRARY_DISJOINT_UNION_WITHOUT_INDEX, null, null, "disjunkte Vereinigung",
					"Die gewöhnliche Vereinigung, wobei die je zwei Klassen aber disjunkt (d.h. mit leerer Schnittmenge) sind. ");
			MathMLGenerator.displayRule(ARBITRARY_DISJOINT_UNION_WITHOUT_INDEX, WriteOperation.prefix("⊍"));

			ARBITRARY_UNION_WITHOUT_INDEX = arbitraryUnion(null);
			MathMLGenerator.displayRule(ARBITRARY_UNION_WITHOUT_INDEX, WriteOperation.prefix("∪"));

			ARBITRARY_UNION_FROM_TO = arbitraryUnionFromTo(null, null, null, null);
			MathMLGenerator.displayRule(ARBITRARY_UNION_FROM_TO, writeIndexedFromTo("∪"));
			// MathMLGenerator.displayRule(ARBITRARY_UNION_FROM_TO, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
			// new Object[] { Basics.UNDEROVER, "∪", new Object[] { Logic.EQUALS, FIRST_VARIABLE, SECOND_VARIABLE }, THIRD_VARIABLE }, FOURTH_VARIABLE));

			ARBITRARY_DISJOINT_UNION = arbitraryDisjointUnion(null, null, null);
			MathMLGenerator.displayRule(ARBITRARY_DISJOINT_UNION,
					WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
							new Object[] { Basics.UNDEROVER, "⊍", new Object[] { ClassesSets.ELEMENT_OF, FIRST_VARIABLE, SECOND_VARIABLE }, ""/* NULL */ },
							THIRD_VARIABLE));

			ARBITRARY_UNION = arbitraryUnion(null, null, null);
			ARBITRARY_UNION.setReferences(wikiDe("Menge_(Mathematik)"), wikiEn("Union_(set_theory)"), ml1("1.5.2"), wt1("1.2.4"));
			ARBITRARY_UNION.be(ClassesSets.setOfSets(I), EmptySet.notEmptySet(I));
			ARBITRARY_UNION.setMain(Logic.multipleDefinitions(arbitraryUnion(I), arbitraryUnion(A, I, A),
					ClassesSets.classByPredicate(null, x, Logic.exists(AelemI, xElemA))));
			lemma(ARBITRARY_UNION, "arbitrary union", null, "Verallgemeinerte Vereinigung",
					"Man verwendet auch (wie beim Schnitt) die Schreibungen über Indexmengen ", arbitraryUnion(i, I, A_i), ", ",
					arbitraryUnionFromTo(i, ONE, n, A_i), ". Ist I eine paarweise disjunkte Mengenfamilie schreibt man auch ", arbitraryDisjointUnion(I),
					". Ist ", Logic.equals(I, NaturalNumbers.SET_OF_NATURAL_NUMBERS), " oder ", Logic.equals(I, NaturalNumbers.upTo(n)),
					" verwendet man auch das Summenzeichen ∑ und spricht von der Summe der Mengen. Für eine endliche Summe schreibt man auch ", A_1, " + ",
					Basics.DOTS, "+", A_n, ". Für eine unendliche Summe schreibt man auch ", A_1, " + ", A_2, " + ", Basics.DOTS);
			Statement A_1_2 = ClassesSets.explicitSet(null, A_1, A_2);
			MathMLGenerator.displayRule(ARBITRARY_UNION,
					WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
							new Object[] { Basics.UNDEROVER, "∪", new Object[] { ClassesSets.ELEMENT_OF, FIRST_VARIABLE, SECOND_VARIABLE }, ""/* NULL */ },
							THIRD_VARIABLE));
			ARBITRARY_UNION.setExamples(Logic.equals(arbitraryUnion(A_1_2),
					ClassesSets.classByPredicate(null, x, Logic.exists(ClassesSets.elementOf(A, A_1_2), xElemA)),
					ClassesSets.classByPredicate(null, x, Bool.or(ClassesSets.elementOf(x, A_1), ClassesSets.elementOf(x, A_2))), union(A_1, A_2)));

			ARBITRARY_UNION_IS_SUPERCLASS = SINGLETON.normal("ARBITRARY_UNION_IS_SUPERCLASS");
			ARBITRARY_UNION_IS_SUPERCLASS.setReferences(ml1("1.5.6"));
			ARBITRARY_UNION_IS_SUPERCLASS.be(ClassesSets.setOfSets(I), EmptySet.notEmptySet(I), ClassesSets.elementOf(B, I));
			ARBITRARY_UNION_IS_SUPERCLASS.setMain(Subset.superclass(arbitraryUnion(I), B));
			lemma(ARBITRARY_UNION_IS_SUPERCLASS, null, null, "Vereinigung ist Obermenge", null);
			ARBITRARY_UNION_IS_SUPERCLASS
					.setProofs(Bool.impliesMultiline(//
							xElemB,
							Basics.proofline(Logic.exists(AelemI, xElemA),
									(Basics.commaSeparated(Logic.definedAs(A, B), ClassesSets.elementOf(B, I)))),
							ClassesSets.elementOf(x, arbitraryUnion(I))//
			));

			ARBITRARY_UNION_OF_SUBSET = SINGLETON.normal("ARBITRARY_UNION_OF_SUBSET");
			ARBITRARY_UNION_OF_SUBSET.setReferences(ml1("1.5.6"));
			ARBITRARY_UNION_OF_SUBSET.be(ClassesSets.setOfSets(I), Subset.subset(J, I), EmptySet.notEmptySet(J));
			ARBITRARY_UNION_OF_SUBSET.setMain(Subset.subclass(arbitraryUnion(J), arbitraryUnion(I)));
			lemma(ARBITRARY_UNION_OF_SUBSET, null, null, "Vereinigung über Teilmenge ist kleiner", null);
			ARBITRARY_UNION_OF_SUBSET.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, arbitraryUnion(J)), Logic.exists(ClassesSets.elementOf(A, J), xElemA),
					Basics.proofline(Logic.exists(AelemI, xElemA), Subset.subset(J, I)), ClassesSets.elementOf(x, arbitraryUnion(I))//
			));
			
			UNION_OF_UNIONS = SINGLETON.normal("UNION_OF_UNIONS");
			UNION_OF_UNIONS.setReferences(ml1("1.5.6"));
			UNION_OF_UNIONS.be(ClassesSets.setOfSets(I), EmptySet.notEmptySet(I), ClassesSets.setOfSets(J), EmptySet.notEmptySet(J));
			UNION_OF_UNIONS.setMain(
					Logic.equals(union(Logic.bracket(arbitraryUnion(A, I, A)), Logic.bracket(arbitraryUnion(A, J, A))), arbitraryUnion(A, union(I, J), A)));
			lemma(UNION_OF_UNIONS, null, null, "Vereinigung zweier verallgemeinerter Vereinigugngen", null);
			UNION_OF_UNIONS.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, arbitraryUnion(A, union(I, J), A)), //
					Logic.exists(ClassesSets.elementOf(A, union(I, J)), xElemA), //
					Bool.orWithBrackets(Logic.exists(AelemI, xElemA), Logic.exists(ClassesSets.elementOf(A, J), xElemA)), //
					Bool.orWithBrackets(ClassesSets.elementOf(x, arbitraryUnion(A, I, A)), ClassesSets.elementOf(x, arbitraryUnion(A, J, A))), //
					ClassesSets.elementOf(x, union(Logic.bracket(arbitraryUnion(A, I, A)), Logic.bracket(arbitraryUnion(A, J, A))))));

			
			ARBITRARY_UNION_AND_SUBCLASS = SINGLETON.normal("ARBITRARY_UNION_AND_SUBCLASS");
			ARBITRARY_UNION_AND_SUBCLASS.setReferences(ml1("1.5.10"));
			ARBITRARY_UNION_AND_SUBCLASS.be(ClassesSets.clasz(A), ClassesSets.setOfSets(I), EmptySet.notEmptySet(I));
			ARBITRARY_UNION_AND_SUBCLASS.setMain(Bool.iff(forAllB_BsubclassA, Subset.subclass(arbitraryUnionIB, A)));
			lemma(ARBITRARY_UNION_AND_SUBCLASS, null, null, "Verallgemeinerte Vereinigung und Teilklassen ", null);
			ARBITRARY_UNION_AND_SUBCLASS.setProofs(Bool.iffByIf(//
					Bool.implies(forAllB_BsubclassA, Subset.subclass(arbitraryUnionIB, A)), //
					Basics.multiline(Basics.be(forAllB_BsubclassA),
							Bool.impliesMultiline(//
									ClassesSets.elementOf(x, arbitraryUnionIB), //
									Logic.exists(BelemI, xElemB), //
									Logic.exists(BelemI, xElemA), //
									xElemA)),
					Bool.implies(Subset.subclass(arbitraryUnionIB, A), forAllB_BsubclassA), //
					Basics.multiline(//
							Basics.be(Basics.commaSeparated(Subset.subclass(arbitraryUnionIB, A), BelemI)), //
							Bool.impliesMultiline(//
									xElemB, //
									ClassesSets.elementOf(x, arbitraryUnionIB), //
									xElemA//
									)//
							)
			));
			
			ARBITRARY_UNION_OF_SUBSETS = SINGLETON.normal("ARBITRARY_UNION_OF_SUBSETS");
			ARBITRARY_UNION_OF_SUBSETS.setReferences(ml1("1.5.11"));
			ARBITRARY_UNION_OF_SUBSETS.be(nonEmptySetI, Logic.forAll(iElemI,
					Basics.commaSeparated(ClassesSets.clasz(A_i).cloneWithDisplayIdentifyingName(), ClassesSets.clasz(B_i).cloneWithDisplayIdentifyingName())));
			ARBITRARY_UNION_OF_SUBSETS.setMain(Bool.implies(Logic.forAll(iElemI, Subset.subclass(A_i, B_i)),
					Subset.subclass(arbitraryUnionAi, arbitraryUnionBi)));
			lemma(ARBITRARY_UNION_OF_SUBSETS, null, null, "Verallgemeinerte Vereinigung von Teilklassen ", null);
			ARBITRARY_UNION_OF_SUBSETS.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(x, arbitraryUnionAi), //
					Logic.exists(iElemI, ClassesSets.elementOf(x, A_i)), //
					Logic.exists(iElemI, ClassesSets.elementOf(x, B_i)), //
					ClassesSets.elementOf(x, arbitraryUnionBi)//
			//
			));
			
			PARTITION = partition(null, null);
			PARTITION.setReferences(wikiEn("Partition_of_a_set"), wikiDe("Partition_(Mengenlehre)"), wt1("1.2.5"));
			PARTITION.be(ClassesSets.setOfSets(I), setU, Logic.forAll(BelemI, BsubclassU));
			PARTITION.setMain(Bool.definedAsEqualTo(partition(I, U), Logic.equals(U, arbitraryDisjointUnion(I))));
			definition(PARTITION, "partition", null, "Partition",
					"Statt Partition spricht man auch von einer Zerlegung von U. Teilweise wird auch noch verlangt, das keine der Mengen aus I leer sein darf.");
			MathMLGenerator.displayRule(PARTITION, new WriteOperation(" Partition von "));


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(UNION, UNION_IS_SUPERCLASS, UNION_WITH_EMTPY_SET, ASSOCIATIVE, COMMUTATIVE, UNION_AND_SUBCLASS, UNION_IDEMPOTENT,
						UNION_WITH_SUBCLASS),
				(List) Arrays.asList(DISJOINT_UNION));
	}

	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2,
				Arrays.asList(ARBITRARY_UNION, ARBITRARY_UNION_IS_SUPERCLASS, ARBITRARY_UNION_OF_SUBSET, UNION_OF_UNIONS, ARBITRARY_UNION_AND_SUBCLASS,
						ARBITRARY_UNION_OF_SUBSETS, PARTITION),
				Arrays.asList(ARBITRARY_UNION_WITHOUT_INDEX, ARBITRARY_DISJOINT_UNION_WITHOUT_INDEX, ARBITRARY_DISJOINT_UNION));
	}

}
