package net.sf.gluebooster.demos.pojo.math.library.setTheory.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class UnionFactory extends Statements {

	protected static final UnionFactory SINGLETON = new UnionFactory();


	protected UnionFactory() {
		super("union", SetTheory.SINGLETON);
	}


	public static Statement union(Statement class1, Statement class2) {
		return SINGLETON.normal("union", Arrays.asList(class1, class2));
	}

	public static Statement disjointUnion(Statement class1, Statement class2) {
		return SINGLETON.normal("disjointUnion", Arrays.asList(class1, class2));
	}

	public static Statement unionWithBrackets(Statement class1, Statement class2) {
		return union(Logic.bracket(class1), Logic.bracket(class2));
	}


	public static Statement arbitraryUnion(Statement index, Statement indexSet, Statement indexedSet) {
		return SINGLETON.normal("arbitraryUnion", index, indexSet, indexedSet);
	}

	public static Statement arbitraryUnion(Statement setOfSets) {
		return SINGLETON.normal("arbitraryUnion2", setOfSets);
	}

	public static Statement arbitraryDisjointUnion(Statement setOfSets) {
		return SINGLETON.normal("arbitraryDisjointUnion", setOfSets);
	}

	public static Statement arbitraryDisjointUnion(Statement index, Statement indexSet, Statement indexedSet) {
		return SINGLETON.normal("arbitraryDisjointUnion2", index, indexSet, indexedSet);
	}

	public static Statement arbitraryUnionFromTo(Statement index, Statement from, Statement to, Statement indexedSet) {
		return SINGLETON.normal("arbitraryUnionFromTo", index, from, to, indexedSet);
	}


	public static Statement partition(Statement setOfSets, Statement universe) {
		return SINGLETON.normal("partition", setOfSets, universe);
	}
}
