package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.IdentityFunction;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class Composition extends CompositionFactory implements MappingsSamples {


	public static Statement COMPOSITE;

	public static Statement DOMAINS_OF_COMPOSITE;

	public static Statement ASSOCIATIVE;

	public static Statement INVERSE;

	public static Statement DOMAIN;

	public static Statement DOMAIN_EQUALS;

	public static Statement IMAGE;

	public static Statement IMAGE_EQUALS;

	public static Statement COMPOSITION_WITH_EMPTY_SET;

	public static Statement EMPTY_COMPOSITION;

	public static Statement COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION;

	public static Statement DOMAIN_OF_COMPOSITION;

	public static Statement VALUE_OF_COMPOSITION;

	public static Statement COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION;

	public static Statement COMPOSITION_WITH_INVERSE_FUNCTION;

	public static Statement COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION;

	private Composition() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "composition", null, "Komposition", null);
			titleText(SINGLETON.unit(1), "composition", null, "Komposition", null);


			COMPOSITE = composite(null, null);
			COMPOSITE.setReferences(References.wikiDe("Komposition_(Mathematik)"), References.wikiEn("Function_composition"), References.ml1("2.3.4"));
			Statement relationR = Relation.binary(true, R, G_R, A, B).setDisplayLevel(VERY_EXTENDED);
			Statement relationS = Relation.binary(true, S, G_S, C, D);
			COMPOSITE.be(relationR, relationS);
			COMPOSITE.main(Logic.definedAs(composite(S, R),
					ClassesSets.classByPredicate(a_c, Logic.exists(b, Bool.and(ClassesSets.elementOf(a_b, R), ClassesSets.elementOf(b_c, S))))));
			definition(COMPOSITE, "composition", null, "Komposition", "Anstelle von Komposition spricht man auch von einer Verknüpfung oder Verkettung.");
			MathMLGenerator.displayRule(COMPOSITE, new WriteOperation("∘"));

			DOMAINS_OF_COMPOSITE = SINGLETON.normal("DOMAINS_OF_COMPOSITE");
			DOMAINS_OF_COMPOSITE.setReferences(References.ml1("2.3.5"));
			DOMAINS_OF_COMPOSITE
					.main(Bool.implies(Bool.and(Subset.subclass(R, AcrossB), Subset.subclass(S, CcrossD)), Subset.subclass(composite(S, R), AcrossD)));
			lemma(DOMAINS_OF_COMPOSITE, null, null, "Bereiche der Komposition", null);
			DOMAINS_OF_COMPOSITE.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf( a_d, composite(S, R)), //
					Logic.exists(b, Bool.and(ClassesSets.elementOf(a_b, R), ClassesSets.elementOf(b_d, S))), //
					Bool.and(aElemA, dElemD), //
					ClassesSets.elementOf(a_d, AcrossD)
					//
					));
					
			
			ASSOCIATIVE = SINGLETON.normal("ASSOCIATIVE");
			ASSOCIATIVE.setReferences(References.ml1("2.3.7"));
			ASSOCIATIVE.be(Relation.binary(R), Relation.binary(S), Relation.binary(T));
			ASSOCIATIVE.main(Logic.equals(composite(T, Logic.bracket(composite(S, R))), composite(Logic.bracket(composite(T, S)), R)));
			lemma(ASSOCIATIVE, null, null, "Assoziativität der Komposition", null);
			ASSOCIATIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(a_b, composite(T, Logic.bracket(composite(S, R)))), //
					Logic.exists(c, Bool.and(ClassesSets.elementOf(a_c, composite(S, R)), ClassesSets.elementOf(c_b, T))), //
					Logic.exists(Basics.commaSeparated(c, d),
							Bool.and(ClassesSets.elementOf(a_d, R), ClassesSets.elementOf(d_c, S), ClassesSets.elementOf(c_b, T))), //
					Logic.exists(d, Bool.and(ClassesSets.elementOf(a_d, R), ClassesSets.elementOf(d_b, composite(T, S)))), //
					ClassesSets.elementOf(a_b, composite(Logic.bracket(composite(T, S)), R)) //
			//
			));

			Statement SafterR = composite(S, R);

			INVERSE = SINGLETON.normal("INVERSE");
			INVERSE.setReferences(References.ml1("2.3.8"));
			INVERSE.be(Relation.binary(R), Relation.binary(S));
			INVERSE.main(
					Logic.equals(InverseRelation.inverse(Logic.bracket(SafterR)), composite(InverseRelation.inverse(R), InverseRelation.inverse(S))));
			lemma(INVERSE, null, null, "Inverses der Komposition", null);
			INVERSE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(a_b, InverseRelation.inverse(Logic.bracket(SafterR))), //
					ClassesSets.elementOf(b_a, SafterR), //
					Logic.exists(c, Bool.and(ClassesSets.elementOf(b_c, R), ClassesSets.elementOf(c_a, S))), //
					Logic.exists(c, Bool.and(ClassesSets.elementOf(c_b, InverseRelation.inverse(R)), ClassesSets.elementOf(a_c, InverseRelation.inverse(S)))), //
					Logic.exists(c, Bool.and(ClassesSets.elementOf(a_c, InverseRelation.inverse(S)), ClassesSets.elementOf(c_b, InverseRelation.inverse(R)))), //
					ClassesSets.elementOf(a_b, composite(InverseRelation.inverse(R), InverseRelation.inverse(S)))//
			//
			));

			DOMAIN = SINGLETON.normal("DOMAIN");
			DOMAIN.setReferences(References.ml1("2.3.9"));
			DOMAIN.be(Relation.binary(R), Relation.binary(S));
			DOMAIN.main(Subset.subclass(RelationBinary.domain(SafterR), RelationBinary.domain(R)));
			lemma(DOMAIN, null, null, "Definitionsbereich der Komposition ist Teilmenge des Definitionsbereich der rechten Relation", null);
			DOMAIN.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(a, RelationBinary.domain(SafterR)), //
					Logic.exists(b, ClassesSets.elementOf(a_b, SafterR)), //
					Logic.exists(Basics.commaSeparated(b, c), Bool.and(ClassesSets.elementOf(a_c, R), ClassesSets.elementOf(c_b, S))), //
					ClassesSets.elementOf(a, RelationBinary.domain(R)) //
			));

			DOMAIN_EQUALS = SINGLETON.normal("DOMAIN_EQUALS");
			DOMAIN_EQUALS.setReferences(References.ml1("2.3.9"));
			DOMAIN_EQUALS.be(Relation.binary(R), Relation.binary(S));
			DOMAIN_EQUALS.main(Bool.implies(//
					Subset.subclass(RelationBinary.image(R), RelationBinary.domain(S)), //
					Logic.equals(RelationBinary.domain(composite(S, R)), RelationBinary.domain(R)) //
			));
			lemma(DOMAIN_EQUALS, null, null, "Definitionsbereich der Komposition ist Definitionsbereich der rechten Relation, wenn der Bildbereich passt.",
					null);
			DOMAIN_EQUALS.setProofs(Basics.multiline(//
					Basics.blankSeparated("Bereits gezeigt: ", Subset.subclass(RelationBinary.domain(SafterR), RelationBinary.domain(R))), //
					Basics.notSeparated(Basics.TO_PROOF, ": ", Subset.subclass(RelationBinary.domain(R), RelationBinary.domain(SafterR))), //
					Bool.impliesMultiline(//
							ClassesSets.elementOf(a, RelationBinary.domain(R)), //
							Logic.exists(ClassesSets.elementOf(b, RelationBinary.image(R)), ClassesSets.elementOf(a_b, R)), //
							Logic.exists(ClassesSets.elementOf(b, RelationBinary.domain(S)), ClassesSets.elementOf(a_b, R)), //
							Logic.exists(Basics.commaSeparated(b, c), Bool.and(ClassesSets.elementOf(a_b, R), ClassesSets.elementOf(b_c, S))), //
							Logic.exists(c, ClassesSets.elementOf(a_c, SafterR)), //
							ClassesSets.elementOf(a, RelationBinary.domain(SafterR))//
					)

			));

			IMAGE = SINGLETON.normal("IMAGE");
			IMAGE.setReferences(References.ml1("2.3.9"));
			IMAGE.be(Relation.binary(R), Relation.binary(S));
			IMAGE.main(Subset.subclass(RelationBinary.image(composite(S, R)), RelationBinary.image(S)));
			lemma(IMAGE, null, null, "Wertebereich der Komposition ist Teilmenge des Wertebereichs der linken Relation", null);
			IMAGE.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(b, RelationBinary.image(SafterR)), //
					Logic.exists(a, ClassesSets.elementOf(a_b, SafterR)), //
					Logic.exists(Basics.commaSeparated(a, c), Bool.and(ClassesSets.elementOf(a_c, R), ClassesSets.elementOf(c_b, S))), //
					ClassesSets.elementOf(b, RelationBinary.image(S)) //
			));

			IMAGE_EQUALS = SINGLETON.normal("IMAGE_EQUALS");
			IMAGE_EQUALS.setReferences(References.ml1("2.3.9"));
			IMAGE_EQUALS.be(Relation.binary(R), Relation.binary(S));
			IMAGE_EQUALS.main(Bool.implies(//
					Subset.subclass(RelationBinary.domain(S), RelationBinary.image(R)), //
					Logic.equals(RelationBinary.image(composite(S, R)), RelationBinary.image(S)) //
			));
			lemma(IMAGE_EQUALS, null, null, "Wertebereich der Komposition ist Wertebereich der linken Relation, wenn der Bildbereich passt.", null);
			IMAGE_EQUALS.setProofs(Basics.multiline(//
					Basics.blankSeparated("Bereits gezeigt: ", Subset.subclass(RelationBinary.image(composite(S, R)), RelationBinary.image(S))), //
					Basics.notSeparated(Basics.TO_PROOF, ": ", Subset.subclass(RelationBinary.image(S), RelationBinary.image(composite(S, R)))), //
					Bool.impliesMultiline(//
							ClassesSets.elementOf(b, RelationBinary.image(S)), //
							Logic.exists(ClassesSets.elementOf(a, RelationBinary.domain(S)), ClassesSets.elementOf(a_b, S)), //
							Logic.exists(ClassesSets.elementOf(a, RelationBinary.image(R)), ClassesSets.elementOf(a_b, S)), //
							Logic.exists(Basics.commaSeparated(a, c), Bool.and(ClassesSets.elementOf(c_a, R), ClassesSets.elementOf(a_b, S))), //
							Logic.exists(c, ClassesSets.elementOf(c_b, SafterR)), //
							ClassesSets.elementOf(b, RelationBinary.image(SafterR))//
					)

			));

			COMPOSITION_WITH_EMPTY_SET = SINGLETON.normal("COMPOSITION_WITH_EMPTY_SET");
			COMPOSITION_WITH_EMPTY_SET.setReferences(References.ml1("2.3.9"));
			COMPOSITION_WITH_EMPTY_SET.be(Relation.binary(R));
			COMPOSITION_WITH_EMPTY_SET.main(Logic.equals(//
					composite(R, EmptySet.EMPTY_SET), EmptySet.EMPTY_SET, composite(EmptySet.EMPTY_SET, R)) //
			);
			lemma(COMPOSITION_WITH_EMPTY_SET, null, null, "Komposition mit leerer Menge ist leere Menge.", null);
			COMPOSITION_WITH_EMPTY_SET
					.setProofs(Logic.proofByContradiction(Bool.impliesMultiline(//
							Logic.notEquals(composite(R, EmptySet.EMPTY_SET), EmptySet.EMPTY_SET), //
							Logic.exists(Basics.commaSeparated(a, b), ClassesSets.elementOf(a_b, composite(R, EmptySet.EMPTY_SET))), //
							Logic.exists(Basics.commaSeparated(a, b, c),
									Bool.and(ClassesSets.elementOf(a_c, EmptySet.EMPTY_SET), ClassesSets.elementOf(c_b, R))), //
							Logic.exists(Basics.commaSeparated(a, c), ClassesSets.elementOf(a_c, EmptySet.EMPTY_SET)), //
							Basics.CONTRADICTION
			//
			)), Basics.analogous(Logic.equals(EmptySet.EMPTY_SET, composite(EmptySet.EMPTY_SET, R))));

			EMPTY_COMPOSITION = SINGLETON.normal("EMPTY_COMPOSITION");
			EMPTY_COMPOSITION.setReferences(References.ml1("2.3.9"));
			EMPTY_COMPOSITION.be(Relation.binary(R), Relation.binary(S));
			EMPTY_COMPOSITION.main(Bool.iffMultiline(Logic.equals(composite(S, R), EmptySet.EMPTY_SET), //
					Logic.equals(Intersection.intersection(RelationBinary.image(R), RelationBinary.domain(S)), EmptySet.EMPTY_SET) //
			));
			lemma(EMPTY_COMPOSITION, null, null, "Wann ist Komposition leere Menge?", null);
			EMPTY_COMPOSITION.setProofs(Bool.iffMultiline(//
					Logic.notEquals(Intersection.intersection(RelationBinary.image(R), RelationBinary.domain(S)), EmptySet.EMPTY_SET), //
					Logic.exists(b, ClassesSets.elementOf(b, Intersection.intersection(RelationBinary.image(R), RelationBinary.domain(S)))), // ))
					Logic.exists(b, Bool.and(ClassesSets.elementOf(b, RelationBinary.image(R)), ClassesSets.elementOf(b, RelationBinary.domain(S)))), //
					Logic.exists(b, Bool.andWithBrackets(Logic.exists(a, ClassesSets.elementOf(a_b, R)), Logic.exists(c, ClassesSets.elementOf(b_c, S)))), // ))
					Logic.exists(Basics.commaSeparated(b, a, c), Bool.and(ClassesSets.elementOf(a_b, R), ClassesSets.elementOf(b_c, S))), // ))
					Logic.exists(Basics.commaSeparated(b, a, c), ClassesSets.elementOf(a_c, SafterR)), // ))
					Logic.exists(Basics.commaSeparated(a, c), ClassesSets.elementOf(a_c, SafterR)), // ))
					Logic.notEquals(SafterR, EmptySet.EMPTY_SET) //
			//
			));

			COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION = SINGLETON.normal("COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION");
			COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION.setReferences(References.ml1("2.5.1"));
			// COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION.be();
			COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION.main(Bool
					.implies(Bool.and(RelationBinary.partialFunction(F), RelationBinary.partialFunction(G)), RelationBinary.partialFunction(composite(F, G))));
			lemma(COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION, null, null, "Komposition partieller Funktionen ist partielle Funktion", null);
			COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION.setProofs(Bool.impliesMultiline(//
					Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a, b_1), FafterG), ClassesSets.elementOf(Tuples.tuple(a, b_2), FafterG)), //
					Logic.exists(Basics.commaSeparated(c_1, c_2), Bool.and(aGc1, c1Fb1, aGc2, c2Fb2)), //
					Basics.proofline(Logic.equals(c_1, c_2), RelationBinary.partialFunction(G)), //
					Basics.proofline(Logic.equals(b_1, b_2), RelationBinary.partialFunction(F)) //
			));
			
			DOMAIN_OF_COMPOSITION = SINGLETON.normal("DOMAIN_OF_COMPOSITION");
			DOMAIN_OF_COMPOSITION.setReferences(References.ml1("2.5.1"));
			DOMAIN_OF_COMPOSITION.be(RelationBinary.partialFunction(F), RelationBinary.partialFunction(G));
			DOMAIN_OF_COMPOSITION.main(Logic.equals(RelationBinary.domain(composite(F, G)),
					ClassesSets.classByPredicate(x, Bool.and(xElemDG, ClassesSets.elementOf(Gofx, domF)))));
			lemma(DOMAIN_OF_COMPOSITION, null, null, "Definitionsbereich der Komposition partieller Funktionen", null);
			DOMAIN_OF_COMPOSITION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(a, RelationBinary.domain(FafterG)), //
					Logic.exists(b, ClassesSets.elementOf(a_b, FafterG)), //
					Logic.exists(Basics.commaSeparated(b, c), Bool.and(aGc, cFb)), //
					Logic.exists(Basics.commaSeparated(b, c), Bool.and(ClassesSets.elementOf(a, domG), Logic.equals(c, Gofa), cFb)), //
					Bool.and(ClassesSets.elementOf(a, domG), ClassesSets.elementOf(Gofa, domF))
			//
			));

			VALUE_OF_COMPOSITION = SINGLETON.normal("VALUE_OF_COMPOSITION");
			VALUE_OF_COMPOSITION.setReferences(References.ml1("2.5.1"));
			VALUE_OF_COMPOSITION.be(RelationBinary.partialFunction(F), RelationBinary.partialFunction(G));
			VALUE_OF_COMPOSITION.main(
					Logic.equals(RelationBinary.functionValueAt(Logic.bracket(composite(F, G)), a),
							RelationBinary.functionValueAt(F, RelationBinary.functionValueAt(G, a))));
			lemma(VALUE_OF_COMPOSITION, null, null, "Funktionswert der Komposition partieller Funktionen", null);
			VALUE_OF_COMPOSITION.setProofs(Bool.iffMultiline(//
					Logic.equals(b, RelationBinary.functionValueAt(Logic.bracket(FafterG), a)), //
					Basics.notSeparated(a, Logic.bracket(FafterG), b), //
					Logic.exists(c, Bool.and(aGc, cFb)), //
					Logic.exists(c, Bool.and(Logic.equals(c, Gofa), cFb)), //
					Basics.notSeparated(Gofa, F, b), //
					Logic.equals(RelationBinary.functionValueAt(F, Gofa), b)));

			COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION = SINGLETON
					.normal("COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION");
			COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION.setReferences(References.ml1("2.5.12"));
			// COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION.be();
			COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION
					.main(Bool.implies(Bool.and(RelationBinary.one2onePartialFunction(F), RelationBinary.one2onePartialFunction(G)),
							RelationBinary.one2onePartialFunction(composite(F, G))));
			lemma(COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION, null, null,
					"Komposition eineindeutiger partieller Funktionen ist eineindeutige partielle Funktion", null);
			COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION.setProofs(Basics.MISSING_PROOF);

			COMPOSITION_WITH_INVERSE_FUNCTION = SINGLETON.normal("COMPOSITION_WITH_INVERSE_FUNCTION");
			COMPOSITION_WITH_INVERSE_FUNCTION.setReferences(References.ml1("2.5.15"));
			COMPOSITION_WITH_INVERSE_FUNCTION.be(RelationBinary.partialFunction(F));
			COMPOSITION_WITH_INVERSE_FUNCTION
					.main(Logic.equals(composite(F, InverseRelation.inverse(F)), IdentityFunction.idRelation(RelationBinary.image(F))));
			lemma(COMPOSITION_WITH_INVERSE_FUNCTION, null, null, "Komposition mit inverser Funktion", null);
			COMPOSITION_WITH_INVERSE_FUNCTION.setProofs(Basics.MISSING_PROOF);

			COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION = SINGLETON.normal("COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION");
			COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION.setReferences(References.ml1("2.5.15"));
			COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION.be(RelationBinary.partialFunction(F));
			COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION.main(Bool.iff(RelationBinary.one2onePartialFunction(F),
					Logic.equals(composite(InverseRelation.inverse(F), F), IdentityFunction.idRelation(domF))));
			lemma(COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION, null, null, "Komposition bei eineindeutiger Funktion", null);
			COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION.setProofs(Basics.MISSING_PROOF);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(COMPOSITE, DOMAINS_OF_COMPOSITE, ASSOCIATIVE, INVERSE, DOMAIN, DOMAIN_EQUALS, IMAGE, IMAGE_EQUALS, COMPOSITION_WITH_EMPTY_SET,
						EMPTY_COMPOSITION, IdentityFunction.COMPOSITION, Subset.SUBCLASS_RELATION_TRANSITIVE,
						COMPOSITION_OF_PARTIAL_FUNCTIONS_IS_PARTIAL_FUNCTION, DOMAIN_OF_COMPOSITION, VALUE_OF_COMPOSITION,
						COMPOSITION_OF_1_TO_1_PARTIAL_FUNCTIONS_IS_1_TO_1_PARTIAL_FUNCTION,
						COMPOSITION_WITH_INVERSE_FUNCTION, COMPOSITION_WITH_1_TO_1_INVERSE_FUNCTION),
				(List) Arrays.asList());
	}

}
