package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class CompositionFactory extends Statements {

	public static final CompositionFactory SINGLETON = new CompositionFactory();

	protected CompositionFactory() {
		super("composition", Relation.SINGLETON);

	}

	public static Statement composite(Statement relation1, Statement relation2) {
		return SINGLETON.normal("composite", relation1, relation2);
	}



}
