package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.Arrays;
import java.util.Collections;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.IdentityFunction;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProductFactory;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class InverseRelation extends InverseRelationFactory implements SetTheorySamples {

	public static Statement INVERSE_RELATION;

	public static Statement INVERSE_RELATION_IS_RELATION;

	public static Statement DOUBLE_INVERSE_IS_RELATION;

	public static Statement DOMAIN;

	public static Statement IMAGE;

	public static Statement INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE;
	public static Statement INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE;
	public static Statement INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1;

	public static Statement FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION;

	public static Statement INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION;

	static {
		try {
			Statement relationR = Relation.binary(true, R, G_R, A, B);

			titleText(SINGLETON.unit(1), "Inverse Relation ", null, "Umkehrrelation");

			INVERSE_RELATION = inverse(null);
			INVERSE_RELATION.setReferences(References.wikiDe("Relation_(Mathematik)#Umkehrrelation"), References.wikiEn("Inverse_relation"), References.ml1("2.3.1"));
			INVERSE_RELATION.be(relationR);
			INVERSE_RELATION.main(Logic.definedAs(inverse(R), ClassesSets.classByPredicate(Tuples.tuple(b, a), ClassesSets.elementOf(a_b, R))));
			definition(INVERSE_RELATION, "inverse relation", null, "Umkehrrelation", "Eine Umkehrrelation heißt auch konverse/inverse Relation.");
			MathMLGenerator.displayRule(INVERSE_RELATION, writeExponent(FIRST_VARIABLE, MINUS_ONE));

			
			INVERSE_RELATION_IS_RELATION = SINGLETON.normal("INVERSE_RELATION_IS_RELATION");
			INVERSE_RELATION_IS_RELATION.setReferences(References.ml1("2.3.2"));
			INVERSE_RELATION_IS_RELATION.be(relationR);
			lemma(INVERSE_RELATION_IS_RELATION, null, null, "Umkehrrelation ist Relation", "Die Umkehrrelation einer Relation zwischen A und B ist eine Relation zwischen B und A");
			//INVERSE_RELATION_IS_RELATION.main(Bool.definedAsEqualTo(inverse(R), ClassesSets.classByPredicate(Tuples.tuple(b, a), ClassesSets.elementOf(a_b, R))));
			INVERSE_RELATION_IS_RELATION.setProofs(Bool.impliesMultiline(//
					ClassesSets.elementOf(b_a, inverse(R)), //
					ClassesSets.elementOf(a_b, R), //
					Bool.and(aElemA, bElemB), //
					ClassesSets.elementOf(b_a, BcrossA) //
			//
			));
			
			DOMAIN = SINGLETON.normal("DOMAIN");
			DOMAIN.setReferences(References.ml1("2.3.9"));
			DOMAIN.be(Relation.binary(R));
			DOMAIN.main(Logic.equals(RelationBinary.domain(inverse(R)), RelationBinary.image(R)));
			lemma(DOMAIN, null, null, "Definitionsbereich der Konversen ist Wertebereich des Originals", null);
			DOMAIN.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(b, RelationBinary.image(R)), //
					Logic.exists(a, ClassesSets.elementOf(a_b, R)), //
					Logic.exists(a, ClassesSets.elementOf(b_a, inverse(R))), //
					ClassesSets.elementOf(b, RelationBinary.domain(inverse(R))) //
			//
			));

			IMAGE = SINGLETON.normal("IMAGE");
			IMAGE.setReferences(References.ml1("2.3.9"));
			IMAGE.be(Relation.binary(R));
			IMAGE.main(Logic.equals(RelationBinary.image(inverse(R)), RelationBinary.domain(R)));
			lemma(IMAGE, null, null, "Wertebereich der Konversen ist Definitionsbereich des Originals", null);
			IMAGE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(a, RelationBinary.domain(R)), //
					Logic.exists(b, ClassesSets.elementOf(a_b, R)), //
					Logic.exists(b, ClassesSets.elementOf(b_a, inverse(R))), //
					ClassesSets.elementOf(a, RelationBinary.image(inverse(R))) //
			//
			));

			DOUBLE_INVERSE_IS_RELATION = SINGLETON.normal("DOUBLE_INVERSE_IS_RELATION");
			DOUBLE_INVERSE_IS_RELATION.setReferences(References.ml1("2.3.2"));
			DOUBLE_INVERSE_IS_RELATION.be(relationR);
			DOUBLE_INVERSE_IS_RELATION.main(Logic.equals(R, inverse(Logic.bracket(inverse(R)))));
			lemma(DOUBLE_INVERSE_IS_RELATION, null, null, "Doppelte Konverse ist Originalrelation", null);
			DOUBLE_INVERSE_IS_RELATION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(a_b, inverse(Logic.bracket(inverse(R)))), //
					ClassesSets.elementOf(b_a, inverse(R)), //
					ClassesSets.elementOf(a_b, R) //
			//
			));

			INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE = SINGLETON.normal("INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE");
			// INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE.setReferences(References.ml1("2.3.2"));
			INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE.be(RelationFactory.binary(R));
			INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE
					.main(Bool.iff(RelationBinaryFactory.rightUnique(inverse(R)), RelationBinaryFactory.leftUnique(R)));
			lemma(INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE, null, null, "Inverse Relation rechtseindeutig, wenn Original linkseindeutig",
					null);
			INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE.setProofs(Bool.iffMultiline(//
					Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a, b_1), inverse(R)), ClassesSets.elementOf(Tuples.tuple(a, b_2), inverse(R))), //
					Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(b_1, a), R), ClassesSets.elementOf(Tuples.tuple(b_2, a), R)) //
			//
			));

			INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE = SINGLETON.normal("INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE");
			// INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE.setReferences(References.ml1("2.3.2"));
			INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE.be(RelationFactory.binary(R));
			INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE
					.main(Bool.iff(RelationBinaryFactory.leftUnique(inverse(R)), RelationBinaryFactory.rightUnique(R)));
			lemma(INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE, null, null, "Inverse Relation linkseindeutig, wenn Original rechtseindeutig",
					null);
			INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE.setProofs(Bool.iffMultiline(//
					Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a_1, b), inverse(R)), ClassesSets.elementOf(Tuples.tuple(a_2, b), inverse(R))), //
					Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(b, a_1), R), ClassesSets.elementOf(Tuples.tuple(b, a_2), R)) //
			//
			));

			INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1 = SINGLETON.normal("INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1");
			// INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE.setReferences(References.ml1("2.3.2"));
			INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1.be(RelationFactory.binary(R));
			INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1.main(Bool.iff(RelationBinaryFactory.one2one(inverse(R)), RelationBinaryFactory.one2one(R)));
			lemma(INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1, null, null, "Inverse Relation eineindeutig, wenn Original eineindeutig", null);
			INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1.setProofs(Basics.comment(
					"Da zwischen Original- und inverser Relation Rechts- und Linkseindeutigkeit vertauscht werden, Eineindeutigkeit aber bedeutet, dass beides vorliegt, ist die Äquivialenz trivial."));

			FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION = SINGLETON.normal("FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION");
			FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION.setReferences(References.ml1("2.5.6"));
			FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION.be(RelationBinary.partialFunction(F));
			FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION.main(Bool.iff(RelationBinaryFactory.one2one(F), RelationBinaryFactory.partialFunction(inverse(F))));
			lemma(FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION, null, null, "Partielle Funktion eineindeutig, gdw. inverse partielle Funktion",
					"In diesem Fall nennt man ", inverse(F), " auch Umkehrfunktion.");
			FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION.setProofs(Basics.MISSING_PROOF);

			INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION = SINGLETON.normal("INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION");
			INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION.setReferences(References.ml1("2.5.12"));
			// INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION.be(RelationBinary.partialFunction(F));
			INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION
					.main(Bool.iff(RelationBinaryFactory.one2onePartialFunction(F), RelationBinaryFactory.one2onePartialFunction(inverse(F))));
			lemma(INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION, null, null,
					"Inverse einer eineindeutigen partiellen Funktion ist ebenfalls eineindeutige partielle Funktion", null);
			INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION.setProofs(Basics.MISSING_PROOF);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(INVERSE_RELATION, INVERSE_RELATION_IS_RELATION, DOMAIN, IMAGE, DOUBLE_INVERSE_IS_RELATION,
						IdentityFunction.INVERSE_OF_IDENTITY_RELATION_IS_ID,
						EmptySet.INVERSE_OF_EMPTY_SET_IS_EMPTY_SET, CartesianProduct.INVERSE_OF_BINARY_PRODUCT,
						INVERSE_RELATION_IS_RIGHT_UNIQUE_IFF_RELATION_LEFT_UNIQUE, INVERSE_RELATION_IS_LEFT_UNIQUE_IFF_RELATION_RIGHT_UNIQUE,
						INVERSE_RELATION_IS_1_TO_1_IFF_RELATION_1_TO_1, FUNCTION_IS_1_TO_1_IFF_INVERSE_IS_FUNCTION,
						INVERSE_OF_1_TO_1_FUNCTION_IS_1_TO_1_FUNCTION),
				Collections.EMPTY_LIST);
	}

}
