package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;


import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.IdentityFunction;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Powerset;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Relation extends RelationFactory {


	public static Statement N_ARY_RELATION;

	public static Statement UNARY_RELATION;

	public static Statement BINARY_RELATION;

	public static Statement HOMOGENOUS_RELATION;

	static {
		try {
			Statement more = Basics.comment("...");
			Statement one = Logic.var("1");
			Statement two = Logic.var("2");
			Statement n = Logic.var("n");
			Statement i = Logic.var("i");
			Statement x = Logic.var("x");
			Statement x1 = Logic.var("x", one);
			Statement xi = Logic.var("x", i);
			Statement xn = Logic.var("x", n);
			Statement y = Logic.var("y");
			Statement A1 = Logic.var("A", one);
			Statement A2 = Logic.var("A", two);
			Statement An = Logic.var("A", n);
			Statement Ai = Logic.var("A", i);


			titleText(SINGLETON.getCategory(), "Finitary relation ", null, "Relationen", null);
			titleText(SINGLETON.unit(1), "Finitary relation (1) ", null, "Relationen (1)", null);
			
			N_ARY_RELATION = nAryRelation(null, null);
			N_ARY_RELATION.setReferences(References.wikiEn("Finitary_relation"), References.wikiDe("Relation_(Mathematik)"));
			N_ARY_RELATION.be(ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS), ClassesSets.clasz(A1), more, ClassesSets.clasz(An),
					Subset.subclass(G_R, CartesianProduct.nFold(A1, more, An)));
			// N_ARY_RELATION.main(nAryRelation(R, Gr, A1, more, An));
			definition(N_ARY_RELATION, "Finitary Relation", null, "N-stellige Relation", "Eine n-stellige Relation R ist eine Teilmenge ", G_R, " von ",
					CartesianProduct.nFold(A1, more, An), ". ", G_R, " wird als Graph von R bezeichnet. Hier verwendet wird die formalere Definition als Tupel ",
					Relation.nAryRelation(true, R, G_R, A1, more, An));
			MathMLGenerator.displayRule(N_ARY_RELATION, MathMLGenerator.WRITE_NAME_OF_INSTANCE);
			N_ARY_RELATION.setExamples(//
					Basics.blankSeparated("Die Leere Menge", EmptySet.EMPTY_SET, "ist eine Relation auf beliebigen", A1, more, An,
							". Sie wird auch als leere Relation bezeichnet."), //
					//
					Basics.blankSeparated("Die Relation", CartesianProduct.nFold(A1, more, An), " heißt Allrelation."));

			UNARY_RELATION = unaryRelation(null, null, null);
			UNARY_RELATION.setReferences(References.wikiEn("Finitary_relation"), References.wikiDe("Relation_(Mathematik)"));
			UNARY_RELATION.be(ClassesSets.clasz(A), Subset.subclass(G_R, A));
			Statement unary = unaryRelation(true, R, G_R, A);
			unary.setDisplayIdentifyingName(true);
			UNARY_RELATION.main(unary);
			// N_ARY_RELATION.main(nAryRelation(R, Gr, A1, more, An));
			definition(UNARY_RELATION, "unary relation", null, "einstellige Relation", "Eine einstellige Relation ", unaryRelation(R, G_R, A),
					" wird auch als Eigenschaft bezeichnet. Sie ist ein n-fache Relation für n=1");
			MathMLGenerator.displayRule(UNARY_RELATION, MathMLGenerator.WRITE_NAME_OF_INSTANCE);

			BINARY_RELATION = binary(null, null, null, null);
			BINARY_RELATION.setReferences(References.wikiEn("Binary_relation"), References.wikiDe("Relation_(Mathematik)"));
			BINARY_RELATION.be(ClassesSets.clasz(A1), ClassesSets.clasz(A2), Subset.subclass(G_R, CartesianProduct.binary(A1, A2)),
					binary(true, R, G_R, A1, A2));
			// N_ARY_RELATION.main(nAryRelation(R, Gr, A1, more, An));
			definition(BINARY_RELATION, "binary relation", null, "zweistellige Relation", "Eine zweistellige Relation ", binary(R, G_R, A1, A2),
					" ist Teilmenge von ", CartesianProduct.binary(A1, A2), ". Sie ist eine n-fache Relation für n=2. Für ", ClassesSets.elementOf(a_b, R),
					" schreibt man auch a R b.");
			MathMLGenerator.displayRule(BINARY_RELATION, MathMLGenerator.SHORT_NAME_DEFAULT_TUPLE_EXTENDED_DEFINED);
			// MathMLGenerator.displayRule(BINARY_RELATION, MathMLGenerator.WRITE_NAME_OF_INSTANCE);
			BINARY_RELATION.setExamples( //
					Basics.blankSeparated(Basics.comment("Die Negation in der Boolschen Menge lässt sich als zweistellige Relation "),
					binary(null, ClassesSets.explicitSetWithoutName(Tuples.tuple(Bool.VERUM, Bool.FALSUM), Tuples.tuple(Bool.FALSUM, Bool.VERUM)),
							Bool.BOOLEAN_SET, Bool.BOOLEAN_SET),
							Basics.comment("formulieren.")), //
					Basics.blankSeparated(
							"Die Vergleiche zweier Zahlen (<, >, =) sind binäre Relationen auf der jeweiligen Zahlenmenge. Hier sieht man den Sinn hinter der zweiten Schreibweise mit z.B. a<b als Schreibung für (a,b)"
									+ ClassesSets.ELEMENT,
							"<")

			);

			HOMOGENOUS_RELATION = homogenousRelation(null, null, null, null);
			HOMOGENOUS_RELATION.setReferences(References.url("https://simple.wikipedia.org/wiki/Relation_(mathematics)"));
			HOMOGENOUS_RELATION.be(ClassesSets.clasz(A), ClassesSets.elementOf(n, NaturalNumbers.SET_OF_NATURAL_NUMBERS),
					Subset.subclass(G_R, CartesianProduct.power(A, n)));
			Statement homogenous = homogenousRelation(null, G_R, A, n);
			// homogenous.setDisplayIdentifyingName(true);
			homogenous.setDisplayLevel(EXTENDED);
			// HOMOGENOUS_RELATION.main(homogenous);
			definition(HOMOGENOUS_RELATION, "homogenous relation", null, "homogene Relation",
					"Eine homogene Relation ist eine mehrstellige Relation auf der gleichen Klasse ", homogenous,
					". Insbesondere ist jede einstellige Relation homogen (n=1).");
			MathMLGenerator.displayRule(HOMOGENOUS_RELATION,
					WriteExtended.defaultExtended(MathMLGenerator.WRITE_NAME_OF_INSTANCE, new WriteAfterStatementTransformation(RuleTransformation
							.create(new Object[] { Logic.BRACKET, FIRST_VARIABLE,
									new Object[] { CartesianProduct.POWER, SECOND_VARIABLE, THIRD_VARIABLE } }))));
			HOMOGENOUS_RELATION.setExamples(//
					Basics.blankSeparated(Basics.comment("Die Negation in der Boolschen Menge ist die homogene Relation "),
					homogenousRelation(null, ClassesSets.explicitSetWithoutName(Tuples.tuple(Bool.VERUM, Bool.FALSUM), Tuples.tuple(Bool.FALSUM, Bool.VERUM)),
							Bool.BOOLEAN_SET, TWO).setDisplayLevel(EXTENDED),
							Basics.comment(".")), //
					//
					Basics.blankSeparated(Basics.comment("Die UND-Operation in der Boolschen Menge kann man als folgende homogene Relation auffassen"),
							homogenousRelation(null,
									ClassesSets.explicitSetWithoutName(Tuples.tuple(Bool.VERUM, Bool.FALSUM, Bool.FALSUM),
											Tuples.tuple(Bool.VERUM, Bool.VERUM, Bool.VERUM), Tuples.tuple(Bool.FALSUM, Bool.FALSUM, Bool.FALSUM),
											Tuples.tuple(Bool.FALSUM, Bool.VERUM, Bool.FALSUM)),
									Bool.BOOLEAN_SET, THREE).setDisplayLevel(EXTENDED),
							Basics.comment(".")), //
					//
					Basics.blankSeparated(Basics.comment("Die ODER-Operation in der Boolschen Menge kann man als folgende homogene Relation auffassen"),
							homogenousRelation(null,
									ClassesSets.explicitSetWithoutName(Tuples.tuple(Bool.VERUM, Bool.FALSUM, Bool.VERUM),
											Tuples.tuple(Bool.VERUM, Bool.VERUM, Bool.VERUM), Tuples.tuple(Bool.FALSUM, Bool.FALSUM, Bool.FALSUM),
											Tuples.tuple(Bool.FALSUM, Bool.VERUM, Bool.VERUM)),
									Bool.BOOLEAN_SET, THREE).setDisplayLevel(EXTENDED),
							Basics.comment(".")), //
					//
					Basics.blankSeparated("Die Gleichheitsrelation (Diagonale) einer Klasse A: ", IdentityFunction.idRelation(A).setDisplayLevel(EXTENDED))
			// Basics.blankSeparated("Die Teilklassenrelation einer Menge C: ", Subset.subclassRelation(C).setDisplayLevel(EXTENDED),
			// " ist eine Relation auf der Potenzmenge ", Powerset.powerset(C))

			);
			// default: name extended (Graph, An) homogene relation

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public Relation() {
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(N_ARY_RELATION, UNARY_RELATION, BINARY_RELATION, EmptySet.EMPTY_SET_IS_BINARY_RELATION, HOMOGENOUS_RELATION),
				(List) Arrays.asList(IdentityFunction.IDENTITY_RELATION));
	}


}
