package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.Arrays;
import java.util.Collections;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.IdentityFunction;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class RelationBinary extends RelationBinaryFactory implements SetTheorySamples {

	/**
	 * Naive description of a function without math logic.
	 */
	public static Statement FUNCTION_NAIVE;

	public static Statement PARTIAL_FUNCTION;

	public static Statement PARTIAL_FUNCTION_EQUALITY;

	/**
	 * Eine Funktion ist eine spezielle, nämlich eine linkstotale und rechtseindeutige (zweistellige) Relation Relation_(Mathematik)
	 */
	public static Statement FUNCTION;

	public static Statement INDEXED_FAMILY;

	public static Statement INDEXED_FAMILY_FINITE;

	public static Statement LEFT_UNIQUE;

	public static Statement RIGHT_UNIQUE;

	public static Statement ONE_TO_ONE;

	public static Statement ONE_TO_ONE_PARTIAL_FUNCTION;

	public static Statement LEFT_TOTAL;

	public static Statement RIGHT_TOTAL;

	public static Statement DOMAIN;

	public static Statement IMAGE;

	public static Statement COMPOSITION;

	/**
	 * The value of a function at a given input
	 */
	public static Statement FUNCTION_VALUE_AT;

	public static Statement FUNCTION_VALUES_OF;


	public static Statement ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION;

	private RelationBinary() {
	}



	static {
		try {
			titleText(SINGLETON.getCategory(), null, null, "Funktionen", null);

			titleText(SINGLETON.unit(1), "Functions", null, "Funktionen",
					"An dieser Stelle erfolgen naive, informelle Definitionen/Begriffsklärungen. Mathematisch exakte Definitionen erfolgen später.");

			FUNCTION_NAIVE = SINGLETON.naive("function (naive)");
			FUNCTION_NAIVE.setReferences(wikiDe("Funktion (Mathematik)"), wikiEn("Function (mathematics)"));
			titleText(FUNCTION_NAIVE, "Function", null, "Funktion",
					"Eine Funktion (Abbildung/Operation) ist eine Regel, wie aus einem oder mehreren Ausgangswerten ein neuer Wert ermittelt wird. Ein typisches Symbol für eine Funktion ist f.");

			
			titleText(SINGLETON.unit(2), "Binary relations", null, "Zweistellige Relationen, Funktionen",
					"Je nach Autor werden auch leicht abweichende Definitionen und Begriffe verwendet. Beispiele hierfür sind Funktion - Abbildung, Wertebereich-Bildbereich-Zielbereich.");
			
			LEFT_UNIQUE = leftUnique(null);
			LEFT_UNIQUE.setReferences(wikiDe("Relation_(Mathematik)#Zweistellige_Relation"), wikiEn("Binary_relation"));
			LEFT_UNIQUE.be(Relation.binary(true, R, G_R, A, B));
			LEFT_UNIQUE.main(Bool.definedAsEqualTo(leftUnique(R),
							Logic.forAll(
							bElemB,
									Logic.forAll(ClassesSets.elementOf(Basics.commaSeparated(a_1, a_2), A),
											Bool.implies(
									Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a_1, b), R), ClassesSets.elementOf(Tuples.tuple(a_2, b), R)),
									Logic.equals(a_1, a_2))))));
			definition(LEFT_UNIQUE, "left-unique relation", "An injective relation is also called injective", "linkseindeutige Relation",
					"Eine linkseindeutige Relation heißt auch voreindeutig bzw. injektiv.");

			
			RIGHT_UNIQUE = rightUnique(null);
			RIGHT_UNIQUE.setReferences(wikiDe("Relation_(Mathematik)#Zweistellige_Relation"), wikiDe("Partielle_Funktion"), wikiEn("Binary_relation"),
					ml1("2.4.2"));
			RIGHT_UNIQUE.be(Relation.binary(true, R, G_R, A, B));
			RIGHT_UNIQUE.main(Bool.definedAsEqualTo(rightUnique(R),
					Logic.forAll(ClassesSets.elementOf(a, A),
							Logic.forAll(ClassesSets.elementOf(Basics.commaSeparated(b_1, b_2), B), Bool.implies(
									Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a, b_1), R), ClassesSets.elementOf(Tuples.tuple(a, b_2), R)),
									Logic.equals(b_1, b_2))))));
			definition(RIGHT_UNIQUE, "right-unique relation", "A right unique relation is also called functional/univalent/right-definite",
					"rechtseindeutige Relation",
					"Eine rechtseindeutige Relation heißt auch eindeutige bzw. nacheindeutige bzw. funktionale Relation oder partielle Funktion. Manchmal wird sie auch bereits als Funktion bezeichnet.");

			ONE_TO_ONE = one2one(null);
			ONE_TO_ONE.setReferences(wikiDe("Relation_(Mathematik)#Eigenschaften_zweistelliger_Relationen"), wikiEn("Binary_relation"));
			ONE_TO_ONE.be(Relation.binary(R));
			ONE_TO_ONE.main(Bool.definedAsEqualTo(one2one(R), Bool.and(leftUnique(R), rightUnique(R))));
			definition(ONE_TO_ONE, "1-to-1 relation", null, "eineindeutige Relation",
					"Für jedes Element aus A gibt es maximal eines aus B und umgekehrt, so dass das Paar in der Relation enthalten ist.");

			ONE_TO_ONE_PARTIAL_FUNCTION = one2onePartialFunction(null);
			definition(ONE_TO_ONE_PARTIAL_FUNCTION, null, null, "eineindeutige partielle Funktion", null);
			;

			FUNCTION_VALUE_AT = functionValueAt(null, null);
			FUNCTION_VALUE_AT.setReferences(ml1("2.4.9"));
			FUNCTION_VALUE_AT.be(rightUnique(F), ClassesSets.elementOf(a_b, F));
			FUNCTION_VALUE_AT.main(Logic.definedAs(functionValueAt(F, a), b));
			definition(FUNCTION_VALUE_AT, null, null, "Funktionswert", "Da ", F, " rechtseindeutig, ist der Wert eindeutig bestimmt.");
			MathMLGenerator.displayRule(FUNCTION_VALUE_AT, new WriteMulti(FIRST_VARIABLE, "(", SECOND_VARIABLE, ")"));

			FUNCTION_VALUES_OF = functionValuesOf(null, null);
			// FUNCTION_VALUES_OF.setReferences(ml1("2.4.9"));
			FUNCTION_VALUES_OF.be(rightUnique(Subset.subclass(F, AcrossB)), Subset.subclass(A_1, A));
			FUNCTION_VALUES_OF.main(Logic.definedAs(functionValuesOf(F, A_1),
					ClassesSets.classByPredicate(functionValueAt(F, a), ClassesSets.elementOf(a, Intersection.intersection(A_1, domF)))));
			definition(FUNCTION_VALUES_OF, null, null, "Funktionswert einer Teilmenge", null);
			MathMLGenerator.displayRule(FUNCTION_VALUES_OF, new WriteMulti(FIRST_VARIABLE, "(", SECOND_VARIABLE, ")"));

			PARTIAL_FUNCTION = partialFunction(null);
			PARTIAL_FUNCTION.setMain(Bool.definedAsEqualTo(partialFunction(R), rightUnique(R)));
			definition(PARTIAL_FUNCTION, "partial function", null, "partielle Funktion", null);

			ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION = SINGLETON.normal("ALTERNATIVE_FUNCTION_DESCRIPTION");
			ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION.setReferences(References.ml1("2.4.10"));
			ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION.be(RelationBinaryFactory.partialFunction(F));
			ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION
					.main(Logic.equals(F, ClassesSets.classByPredicate(Tuples.tuple(x, functionValueAt(F, x)), ClassesSets.elementOf(x, domain(F)))));
			lemma(ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION, null, null, "Alternative Definitionen einer partiellen Funktion", null);
			ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION.setProofs(Subset.equalsBySubclasses(
					// proofLeftSubsetRight,
					Bool.implies(ClassesSets.elementOf(x_y, F), Bool.and(ClassesSets.elementOf(x, domain(F)), Logic.equals(y, functionValueAt(F, x)))),
					// proofRightSubsetLeft
					Bool.implies(ClassesSets.elementOf(x, domain(F)), ClassesSets.elementOf(Tuples.tuple(x, functionValueAt(F, x)), F))));

			PARTIAL_FUNCTION_EQUALITY = SINGLETON.normal("PARTIAL_FUNCTION_EQUALITY");
			PARTIAL_FUNCTION_EQUALITY.setReferences(References.ml1("2.4.11"));
			PARTIAL_FUNCTION_EQUALITY.be(RelationBinaryFactory.partialFunction(F), RelationBinaryFactory.partialFunction(G));
			Statement left = Logic.equals(F, G);
			Statement right = Bool.and(Logic.equals(domain(F), domain(G)),
					Logic.forAll(ClassesSets.elementOf(x, domain(F)), Logic.equals(functionValueAt(F, x), functionValueAt(G, x))));
			PARTIAL_FUNCTION_EQUALITY.main(Bool.iff(left, right));
			lemma(PARTIAL_FUNCTION_EQUALITY, null, null, "Gleichheit partieller Funktionen", null);
			PARTIAL_FUNCTION_EQUALITY.setProofs(Bool.iffByIf(//
					Bool.implies(left, right), //
					Basics.TRIVIAL, //
					Bool.implies(right, left), //
					Logic.equalsMultiline(F, //
							ClassesSets.classByPredicate(Tuples.tuple(x, functionValueAt(F, x)), ClassesSets.elementOf(x, domain(F))), //
							ClassesSets.classByPredicate(Tuples.tuple(x, functionValueAt(G, x)), ClassesSets.elementOf(x, domain(G))), //
							G) //
			));

			LEFT_TOTAL = leftTotal(null);
			LEFT_TOTAL.setReferences(wikiDe("Relation_(Mathematik)#Zweistellige_Relation"), wikiEn("Binary_relation"));
			LEFT_TOTAL.be(Relation.binary(true, R, G_R, A, B));
			LEFT_TOTAL.main(Bool.definedAsEqualTo(leftTotal(R),
					Logic.forAll(ClassesSets.elementOf(a, A), Logic.exists(ClassesSets.elementOf(b, B), ClassesSets.elementOf(Tuples.tuple(a, b), R)))));
			definition(LEFT_TOTAL, "left-total relation", null, "linkstotale Relation",
					"Eine linkstotale Relation heißt auch definal. Die Bedingung läßt sich kürzer schreiben als ", Logic.equals(domR, A));

			RIGHT_TOTAL = rightTotal(null);
			RIGHT_TOTAL.setReferences(wikiDe("Relation_(Mathematik)#Zweistellige_Relation"), wikiEn("Binary_relation"));
			RIGHT_TOTAL.be(Relation.binary(true, R, G_R, A, B));
			RIGHT_TOTAL.main(Bool.definedAsEqualTo(rightTotal(R),
					Logic.forAll(ClassesSets.elementOf(b, B),
							Logic.exists(aElemA /* ClassesSets.isElementOf(a, A) */, ClassesSets.elementOf(Tuples.tuple(a, b), R)))));
			definition(RIGHT_TOTAL, "right-total relation", null, "rechtstotale Relation",
					"Eine rechtstotale Relation heißt auch surjektiv. Die Bedingung läßt sich kürzer schreiben als ", Logic.equals(image(R), B));

			FUNCTION = function(null);
			FUNCTION.setReferences(wikiDe("Relation_(Mathematik)#Zweistellige_Relation"), wikiEn("Binary_relation"));
			FUNCTION.be(Relation.binary(true, R, G_R, A, B));
			FUNCTION.main(Bool.definedAsEqualTo(function(R), Bool.and(leftTotal(R), rightUnique(R))));
			definition(FUNCTION, "function", null, "Funktion",
					"Eine linkstotale, rechtseindeutige Relation heißt Funktion. Sie ist somit eine linkstotale partielle Funktion. Zur Abgrenzung zur partiellen Funktion spricht man auch von einer totalen Funktion.");


			DOMAIN = domain(null);
			DOMAIN.setReferences(wikiDe("Definitionsmenge"), wikiEn("Domain_of_a_function"), ml1("2.2.7"));
			DOMAIN.be(Relation.binary(true, R, G_R, A, B));
			DOMAIN.main(Logic.definedAs(domain(R),
					Logic.equals(ClassesSets.classByPredicate(null, aElemA, Logic.exists(bElemB, ClassesSets.elementOf(a_b, G_R))),
							ClassesSets.classByPredicate(null, a, Logic.exists(b, ClassesSets.elementOf(a_b, G_R))))));
			definition(DOMAIN, "domain", null, "Definitionsbereich", "Handelt es sich um eine Menge, spricht man auch von Definitionsmenge");
			MathMLGenerator.displayRule(DOMAIN, new WriteOperation("D(", ", ", ")"));

			IMAGE = image(null);
			IMAGE.setReferences(wikiDe("Wertemenge"), wikiDe("Bild_(Mathematik)"), wikiEn("Image_(mathematics)"), ml1("2.2.7"));
			IMAGE.be(Relation.binary(true, R, G_R, A, B));
			IMAGE.main(Logic.definedAs(image(R),
					Logic.equals(ClassesSets.classByPredicate(null, bElemB, Logic.exists(aElemA, ClassesSets.elementOf(a_b, G_R))),
							ClassesSets.classByPredicate(null, b, Logic.exists(a, ClassesSets.elementOf(a_b, G_R))))));
			definition(IMAGE, "image", null, "Wertebereich",
					"Handelt es sich um eine Menge, spricht man auch von der Wertemenge. Ebenfalls verwendet werden die Begriffe Bildbereich, Bildmenge, Bild.");
			MathMLGenerator.displayRule(IMAGE, new WriteOperation("W(", ", ", ")"));


			INDEXED_FAMILY = indexedFamily(null, null, null, null);
			INDEXED_FAMILY.setReferences(wikiDe("Familie_(Mathematik)"), wikiEn("Indexed_family"));
			INDEXED_FAMILY.be(function(F), Logic.notEquals(EmptySet.EMPTY_SET, Logic.definedAs(I, domain(F))), Logic.definedAs(a_i, functionValueAt(F, i)));
			// INDEXED_FAMILY.main(Boolean.definedAsEqualTo(function(R), Boolean.and(leftTotal(R), rightUnique(R))));
			definition(INDEXED_FAMILY, "indexed family", null, "Familie", "Eine besondere Schreibweise für eine Funktion ", F,
					", ist die Schreibweise als Familie, die wie folgt lautet: ", indexedFamily(a_i, i, I, F),
					". Ist es eine endliche Familie und kommt es auf die Indizierung nicht an, werden die Elemente manchmal einfach nur aufgezählt, z.B. ",
					indexedFamilyFinite(f_1, f_2, f_3), " oder ", indexedFamilyFinite(f, g, h), ". ", I,
					" heißt Indexbereich oder Indexmenge (wenn es eine Menge ist). ", a_i, " heißt Mitglied oder Term der Familie.");
			MathMLGenerator.displayRule(INDEXED_FAMILY, WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT,
					new Object[] { Logic.BRACKET, FIRST_VARIABLE }, new Object[] { ClassesSets.ELEMENT_OF, SECOND_VARIABLE, THIRD_VARIABLE }, ""));
			INDEXED_FAMILY.setExamples(//
					Basics.blankSeparated("Handelt es sich bei den Funktionswerten um Mengen, so spricht man von einer Mengenfamilie (Familie von Mengen) (aus",
							image(F), ")."), //
					Basics.blankSeparated("Handelt es sich bei der Indexmenge um die natürlichen Zahlen, spricht man von einer Folge."), //
					Basics.blankSeparated(
							"Handelt es sich bei der Indexmenge um eine endliche Teilmenge der natürlichen Zahlen, spricht man von einer endlichen Folge."), //
					Basics.blankSeparated(
							"Handelt es sich bei der Indexmenge um die natürlichen Zahlen und bei den Termen um Mengen, spricht man von einer Mengenfolge."), //
					Basics.blankSeparated("Sind bei einer Mengenfolge alle Terme Teilmengen einer Menge M, spricht man von einer Mengenfolge in M.") //

			//
			);

			INDEXED_FAMILY_FINITE = indexedFamilyFinite();
			MathMLGenerator.displayRule(INDEXED_FAMILY_FINITE, WriteAfterStatementTransformation.ruleTransformation(Basics.COMMA_SEPARATED, ALL_VARIABLES));


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, Arrays.asList(FUNCTION_NAIVE/* , FUNCTION_VALUE_AT */), Collections.EMPTY_LIST);
	}

	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2,
				Arrays.asList(DOMAIN, IMAGE, LEFT_UNIQUE, EmptySet.EMPTY_SET_IS_LEFT_UNIQUE, IdentityFunction.IDENTITY_RELATION_IS_LEFT_UNIQUE, RIGHT_UNIQUE,
						EmptySet.EMPTY_SET_IS_RIGHT_UNIQUE, IdentityFunction.IDENTITY_RELATION_IS_RIGHT_UNIQUE, ONE_TO_ONE, EmptySet.EMPTY_SET_IS_1_TO_1,
						IdentityFunction.IDENTITY_RELATION_IS_1_TO_1,
						FUNCTION_VALUE_AT, FUNCTION_VALUES_OF, ALTERNATIVE_PARTIAL_FUNCTION_DESCRIPTION, PARTIAL_FUNCTION_EQUALITY, LEFT_TOTAL, RIGHT_TOTAL,
						FUNCTION, INDEXED_FAMILY),
				Arrays.asList(PARTIAL_FUNCTION, INDEXED_FAMILY_FINITE, ONE_TO_ONE_PARTIAL_FUNCTION));
	}

	/*
	 * 
	 * use Graph, funktionsartiger Graph Abbildung f:= (M,F,N) F Funktion Bildbereich N Teilmenge des Wertebereichs von F M = Definitionsbereich von F (warum
	 * nicht Teilmenge davon?)
	 * 
	 * Korrespondenz
	 * 
	 * Relation by
	 * 
	 */


}
