package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class RelationBinaryFactory extends Statements {

	public static final RelationBinaryFactory SINGLETON = new RelationBinaryFactory();



	protected RelationBinaryFactory() {
		super("binary relations", Relation.SINGLETON);
	}



	public static Statement functionValueAt(Statement function, Statement input) {
		Statement result = SINGLETON.normal("functionValueAt", function, input);
		return result;
	}

	public static Statement functionValuesOf(Statement function, Statement input) {
		Statement result = SINGLETON.normal("functionValuesOf", function, input);
		return result;
	}

	public static Statement function(Statement relation) throws Exception {
		return SINGLETON.normal("function", relation);
	}
	
	public static Statement indexedFamily(Statement indexedElement, Statement index, Statement domain, Statement function) throws Exception {
		return SINGLETON.normal("indexedFamily", indexedElement, index, domain, function);

	}

	public static Statement indexedFamilyFinite(Statement... elements) {
		return SINGLETON.normal("indexedFamilyFinite", elements);

	}

	public static Statement domain(Statement relation) {
		return SINGLETON.normal("domain", relation);
	}

	public static Statement image(Statement relation) throws Exception {
		return SINGLETON.normal("image", relation);
	}
	

	public static Statement leftUnique(Statement binaryRelation) {
		Statement result = SINGLETON.normal("leftUnique", binaryRelation);
		return result;
	}

	public static Statement rightUnique(Statement binaryRelation) {
		Statement result = SINGLETON.normal("right unique", binaryRelation);
		return result;
	}

	public static Statement one2one(Statement binaryRelation) {
		Statement result = SINGLETON.normal("one2one", binaryRelation);
		return result;
	}

	public static Statement one2onePartialFunction(Statement binaryRelation) {
		Statement result = SINGLETON.normal("one2onePartialFunction", binaryRelation);
		return result;
	}

	public static Statement partialFunction(Statement binaryRelation) {
		Statement result = SINGLETON.normal("partial function", binaryRelation);
		return result;
	}

	public static Statement leftTotal(Statement binaryRelation) {
		Statement result = SINGLETON.normal("left total", binaryRelation);
		return result;
	}

	public static Statement rightTotal(Statement binaryRelation) {
		Statement result = SINGLETON.normal("right total", binaryRelation);
		return result;
	}



}
