package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class RelationFactory extends Statements {

	protected static final RelationFactory SINGLETON = new RelationFactory();



	protected RelationFactory() {
		super("relation", SetTheory.SINGLETON);
	}


	public static Statement nAryRelation(Statement nameOfRelation, Statement graph, Statement... classes) {
		Statement[] graphAndClasses = new Statement[classes.length + 1];
		graphAndClasses[0] = graph;
		System.arraycopy(classes, 0, graphAndClasses, 1, classes.length);
		Statement result = SINGLETON.normal(nameOfRelation, "nAryRelation", graphAndClasses);
		result.setDisplayIdentifyingNameInPrecondition(true);
		return result;
	}

	public static Statement nAryRelation(boolean extendedDisplay, Statement nameOfRelation, Statement graph, Statement... classes) {
		Statement result = nAryRelation(nameOfRelation, graph, classes);
		result.setDisplayLevel(EXTENDED);
		return result;
	}

	public static Statement unaryRelation(Statement nameOfRelation, Statement graph, Statement clasz) {
		Statement result = SINGLETON.normal(nameOfRelation, "unaryRelation", graph, clasz);
		result.setDisplayIdentifyingNameInPrecondition(true);
		return result;
	}

	public static Statement unaryRelation(boolean extendedDisplay, Statement nameOfRelation, Statement graph, Statement clasz) {
		Statement result = unaryRelation(nameOfRelation, graph, clasz);
		result.setDisplayLevel(EXTENDED);
		return result;
	}

	public static Statement homogenousRelation(Statement nameOfRelation, Statement graph, Statement clasz, Statement n) {
		Statement result = SINGLETON.normal(nameOfRelation, "homogenousRelation", graph, clasz, n);
		return result;

	}

	/**
	 * Create a binary relation.
	 * 
	 * @param nameOfRelation
	 * @param graph
	 * @param clasz1
	 * @param clasz2
	 * @return
	 */
	public static Statement binary(Statement nameOfRelation, Statement graph, Statement clasz1, Statement clasz2) {
		Statement result = SINGLETON.normal(nameOfRelation, "binaryRelation", graph, clasz1, clasz2);
		result.setDisplayIdentifyingNameInPrecondition(true);
		return result;
	}

	public static Statement binary(boolean extendedDisplay, Statement nameOfRelation, Statement graph, Statement clasz1, Statement clasz2) {
		Statement result = binary(nameOfRelation, graph, clasz1, clasz2);
		if (extendedDisplay) {
			result.setDisplayLevel(EXTENDED);
		}
		return result;

	}


	public static Statement binary(Statement nameOfRelation) {
		Statement result = binary(nameOfRelation, null, null, null);
		result.setDisplayLevel(SHORT);
		return result;
	}
}
