package net.sf.gluebooster.demos.pojo.math.library.setTheory.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;


import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class RelationSpecial extends Statements {

	public static final RelationSpecial SINGLETON = new RelationSpecial();

	public static Statement EXPLICIT_RELATION;

	static {
		try {

			// Explizit_relation is binary relation if at least two columns (last column is used as B)
		EXPLICIT_RELATION = explicitRelation(null, null);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public RelationSpecial() {
		super("relation special", SetTheory.SINGLETON);
	}


	/**
	 * 
	 * @param nameOfRelation
	 *            if the relation is a function then the name should be a statement that accepts arguments (the function parameters).
	 * @param collectionOfTuples
	 *            collectionOfTuples[0] is the first tuple the last 
	 * @return
	 */
	public static Statement explicitRelation(Statement nameOfRelation, Object[][] collectionOfTuples) {
		Statement result = SINGLETON.naive("explicitRelation");
		result.setNameOfInstance(nameOfRelation);
		result.setDefinition();// because it is defined here
		result.setRawData(collectionOfTuples);
		// TODO find a better representation from statements (UNION of tuples
		// ...) to be able to do logic operations
		return result;
	}

	public static Set<Object> getColumn(Statement relation, int index) {
		HashSet<Object> result = new HashSet();
		for (List<Object> row : getCollectionOfTuples(relation)) {
			result.add(row.get(index));
		}
		return result;
	}

	/**
	 * Splits the relation into two lists. The first contains the first columns excluding an index-column, the second the remaining
	 * 
	 * @param relation
	 * @param index
	 * @return
	 */
	public static Pair<List<Object>, List<Object>> splitAtColumn(Statement relation, int index) {
		List<Object> firstColumns = new ArrayList();
		List<Object> secondColumns = new ArrayList();
		for (List<Object> row : getCollectionOfTuples(relation)) {
			firstColumns.add(row.subList(0, index));
			secondColumns.add(row.subList(index, row.size()));
		}
		return new MutablePair<List<Object>, List<Object>>(firstColumns, secondColumns);
	}

	/**
	 * 
	 * @param relation
	 * @return Collection of rows
	 */
	public static Collection<List<Object>> getCollectionOfTuples(Statement relation) {
		if (EXPLICIT_RELATION.is(relation)) {
			ArrayList<List<Object>> result = new ArrayList();
			for (Object[] row : (Object[][]) relation.getRawData()) {
				result.add(Arrays.asList(row));
			}
			return result;

		} else {
			throw new IllegalStateException("relation not yet supported " + relation);
		}
	}


}
