package net.sf.gluebooster.demos.pojo.math.library.topology;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Powerset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleStatementCreator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class Topology extends TopologyFactory implements TopologySamples {

	public static Statement TOPOLOGY;

	public static Statement INDISCRETE_TOPOLOGY;

	public static Statement DISCRETE_TOPOLOGY;

	public static Statement TOPOLOGICAL_SPACE;

	public static Statement SIERPINSKI_SPACE;

	public static Statement TOPOLOGY_OF_SUBSET;

	public static Statement TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY;

	private Topology() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "topology", null, "Topologie", null);
			titleText(SINGLETON.unit(1), "topology (1)", null, "Topologie (1)", null);



			TOPOLOGY = topology(null, null, null);
			TOPOLOGY.setReferences(References.wikiEn("Topological_space"), References.wikiDe("Topologischer_Raum"), References.top1_1("1.1.1"));
			TOPOLOGY.be(setX, Subset.subset(τ, Powerset.powerset(X)));
			TOPOLOGY.setMain(Bool.definedAsEqualToMultiline(topologyτX,
					Bool.andMultiline( //
							Basics.proofline(ClassesSets.elementOf(X, τ), top1), //
							Basics.proofline(emptyElemTau, top2), //
							Basics.proofline(topologyCondition3, top3), //
							Basics.proofline(Logic.bracket(Bool.implies(Subset.subset(A, τ), ClassesSets.elementOf(Union.arbitraryUnion(A), τ))),
									top4)//
					)));
			definition(TOPOLOGY, "topology", null, "Topologie", "Eine Topologie ", τ1, "heißt kleiner (gröber) als ", τ2, " genau dann wenn ",
					Subset.subclass(τ1, τ2), ". In diesem Fall heißt ", τ2, " größer (feiner) als ", τ1, ".");
			MathMLGenerator.displayRule(TOPOLOGY, WriteExtended.shortDefault(MathMLGenerator.WRITE_NAME_OF_INSTANCE, new WriteOperation(" Topologie auf ")));

			Statement topologyWithVerum = ClassesSets.explicitSetWithoutName(EMPTY_SET, ClassesSets.explicitSetWithoutName(Bool.VERUM), Bool.BOOLEAN_SET);

			TOPOLOGY.setExamples(//
					Basics.notSeparated(Basics.comment("Topologien auf "), Bool.BOOLEAN_SET, Basics.comment(" sind: "),
							ClassesSets.explicitSetWithoutName(EMPTY_SET, Bool.BOOLEAN_SET), Basics.comment(", "),
							topologyWithVerum, Basics.comment(", "),
							ClassesSets.explicitSetWithoutName(EMPTY_SET, ClassesSets.explicitSetWithoutName(Bool.FALSUM), Bool.BOOLEAN_SET),
							Basics.comment(", "), ClassesSets.explicitSetWithoutName(EMPTY_SET, ClassesSets.explicitSetWithoutName(Bool.VERUM),
									ClassesSets.explicitSetWithoutName(Bool.FALSUM), Bool.BOOLEAN_SET))
			//
			);

			INDISCRETE_TOPOLOGY = indiscreteTopology(null);
			INDISCRETE_TOPOLOGY.setReferences(References.wikiEn("Topological_space"), References.wikiEn("Trivial_topology"),
					References.wikiDe("Topologischer_Raum"), References.wikiDe("Triviale_Topologie"), References.top1_1("1.1.2"));
			INDISCRETE_TOPOLOGY.be(setX);
			INDISCRETE_TOPOLOGY.setMain(Logic.definedAs(indiscreteTopology(X), ClassesSets.explicitSetWithoutName(EmptySet.EMPTY_SET, X)));
			definition(INDISCRETE_TOPOLOGY, "indiscrete topology", "trivial topology", "indiskrete Topologie",
					"Die indiskrete Topologie wird auch als triviale Topologie oder Klumpentopologie bezeichnet.");
			// proof
			MathMLGenerator.displayRule(INDISCRETE_TOPOLOGY, new WriteMulti(Logic.var("τ", ZERO), "(", FIRST_VARIABLE, ")"));

			DISCRETE_TOPOLOGY = discreteTopology(null);
			DISCRETE_TOPOLOGY.setReferences(References.wikiEn("Topological_space"), References.wikiEn("Discrete_space"),
					References.wikiDe("Diskrete_Topologie"), References.top1_1("1.1.2"));
			DISCRETE_TOPOLOGY.be(setX);
			// DISCRETE_TOPOLOGY.setMain(Logic.definedAs(discreteTopology(X), Powerset.powerset(X)));
			definition(DISCRETE_TOPOLOGY, "discrete topology", null, "diskrete Topologie", "Die Potenzmenge ", Powerset.powerset(X),
					" bildet die sogenannte diskrete Topologie.");
			// proof
			MathMLGenerator.displayRule(DISCRETE_TOPOLOGY, new WriteOperation("diskrete Topologie P(", null, ")"));


			TOPOLOGICAL_SPACE = topologicalSpace(null, null, null);
			TOPOLOGICAL_SPACE.setReferences(References.wikiEn("Topological_space"), References.wikiDe("Topologischer_Raum"), References.top1_1("1.1.1"));
			TOPOLOGICAL_SPACE.be(topologyτX);
			// TOPOLOGICAL_SPACE.setMain(Logic.definedAs(topologicalSpaceXτExtendedType/* , Tuples.pair(X, topologyτXShort) */));// TODO use structure
			definition(TOPOLOGICAL_SPACE, "topological space", null, "topologischer Raum",
					"Eine topologischer Raum", topologicalSpaceXτExtended,
					" ist eine Struktur erster Stufe ohne Funktionen, nur mit Relationen (den Elementen der Topologie). X heißt Trägermenge, die Elemente von X heißen Punkte in ",
					topologicalSpaceXτ, ", die Elemente von τ heißen offen in ", topologicalSpaceXτ);
			// MathMLGenerator.displayRule(TOPOLOGICAL_SPACE, new WriteOperation(" Topologie auf "));
			TOPOLOGICAL_SPACE.setExamples(//
					Basics.comment(
							"Ein topologischer Raum, der aus einer Menge X und der dazugehörigen indiskreten Topologie besteht heißt indiskreter topologischer Raum mit Trägermenge X"), //
					Basics.comment(
							"Ein topologischer Raum, der aus einer Menge X und der dazugehörigen diskreten Topologie besteht heißt diskreter topologischer Raum mit Trägermenge X") //
			//
			);
			MathMLGenerator.displayRule(TOPOLOGICAL_SPACE, MathMLGenerator.SHORT_NAME_DEFAULT_TUPLE_EXTENDED_DEFINED);
			// WriteExtended.defaultExtended(MathMLGenerator.WRITE_NAME_OF_INSTANCE, MathMLGenerator.WRITE_NAME_DEFINED_AS_FIRST_SECOND));

			// Finite_topological_space

			SIERPINSKI_SPACE = SINGLETON.normal("SIERPINSKI_SPACE");
			SIERPINSKI_SPACE.setReferences(References.wikiEn("Sierpiński_space"), References.wikiDe("Sierpiński-Raum"), References.top1_1("1.1.2"));
			SIERPINSKI_SPACE
					.setMain(Logic.definedAs(SIERPINSKI_SPACE, topologicalSpace(null, Bool.BOOLEAN_SET, topology(null, topologyWithVerum, Bool.BOOLEAN_SET))));
			definition(SIERPINSKI_SPACE, "sierpiński space", null, "Sierpiński-Raum", "Der kleinste Topologische Raum, der weder diskret noch indiskret ist.");
			// proof
			MathMLGenerator.displayRule(SIERPINSKI_SPACE, new WriteMulti("$_"));

			TOPOLOGY_OF_SUBSET = topologyOfSubset(null, null);
			TOPOLOGY_OF_SUBSET.setReferences(References.top1_1("1.1.6"));
			TOPOLOGY_OF_SUBSET.be(setX, Subset.subset(A, X));
			definition(TOPOLOGY_OF_SUBSET, null, null, "Algorithmus zur Topologieerzeugung", Basics.multiline(//
							Logic.definedAs(A_1, Union.union(A, ClassesSets.explicitSetWithoutName(EmptySet.EMPTY_SET, X))),
							Logic.definedAs(A_2, Basics.notSeparated(Basics.comment("Die Menge aller endlichen Schnitte von Elementen aus "), A_1)),
					Logic.definedAs(t_A, Basics.notSeparated(Basics.comment("Die Menge aller Vereinigungen von Elementen aus "), A_2)),
					Basics.notSeparated(t_A, " ist Topologie")

			));
			// proof
			MathMLGenerator.displayRule(TOPOLOGY_OF_SUBSET,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, "τ", FIRST_VARIABLE, ""));
			TOPOLOGY_OF_SUBSET.setProofs(Basics.multiline(//
					Basics.notSeparated(Subset.subset(A_1, A_2), ": Da jedes Element mit sich selbst geschnitten wieder sich selbst ergibt."), //
					Basics.notSeparated(Subset.subset(A_2, t_A), ": Da jedes Element mit sich selbst vereinigt wieder sich selbst ergibt."), //
					Basics.notSeparated(ClassesSets.elementOf(X, t_A), ", ", ClassesSets.elementOf(EmptySet.EMPTY_SET, t_A), " da sie bereits in ", A_1,
							" enthalten sind."), //
					Basics.notSeparated(Logic.bracket(Bool.implies(Subset.subset(B, t_A), ClassesSets.elementOf(Union.arbitraryUnion(B), t_A))),
							"da die Elemente von B Vereinigungen aus ", A_2, " sind, ist auch deren Vereinigung eine Vereinigung von Elementen aus ", A_2)//
					,
					Basics.notSeparated(Basics.BE, ClassesSets.elementOf(arbitraryUnionIB, t_A), ", ", ClassesSets.elementOf(arbitraryUnionJC, t_A),
							". Dann ist ",
							Logic.equals(Intersection.intersection(arbitraryUnionIB, arbitraryUnionJC),
									Union.arbitraryUnion(B, I, Union.arbitraryUnion(C, J, Logic.bracket(Intersection.intersection(B, C))))),
							". Da B und C als Elemente von ", A_2,
							" jeweils endliche Schnitte sind, ist auch deren Schnitt ein endlicher Schnitt und somit in ",
							A_2, " enthalten. Damit ist die Vereinigungsmenge bereits in ", A_3, " enthalten.")//
					));

			TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY = SINGLETON.normal("TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY");
			TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY.setReferences(References.top1_1("1.1.6"));
			lemma(TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY, null, null, "kleinste Topologie, die Mengenfamilie enthält", t_A,
					" ist die kleinste Topologie, die A enthält.");
			TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY.setProofs(Bool.impliesMultiline(//
					Basics.notSeparated(Basics.BE, topologyτXExtendedType, ", ", Subset.subset(A, tau)), //
					Subset.subset(A_1, tau), Subset.subset(A_2, tau), Subset.subset(A_3, tau)
			//
			));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(TOPOLOGY, INDISCRETE_TOPOLOGY, DISCRETE_TOPOLOGY, TOPOLOGICAL_SPACE, SIERPINSKI_SPACE, TOPOLOGY_OF_SUBSET,
						TOPOLOGY_OF_SUBSET_IS_SMALLEST_TOPOLOGY),
				(List) Arrays.asList());
	}

}
