package net.sf.gluebooster.demos.pojo.math.library.topology;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Powerset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class TopologyBase extends TopologyBaseFactory implements TopologySamples {


	public static Statement SUBBASE;

	public static Statement BASE;

	public static Statement TOPOLOGY_IS_BASE;

	public static Statement BASE_IS_SUBBASE;

	public static Statement BASE_ALTERNATIVE;

	public static Statement BASE_OF_DISCRETE_TOPOLOGY;

	public static Statement SUBBASE_ALTERNATIVE;

	public static Statement BASE_CHARACTERISTICS;

	private TopologyBase() {
	}


	static {
		try {
			titleText(SINGLETON.unit(1), "base for topology", null, "Basis eines topologischen Raums", null);

			BASE = base(null, null);
			BASE.setReferences(References.wikiEn("Base_(topology)"), References.wikiDe("Basis_(Topologie)"), References.top1_1("1.1.7"));
			BASE.be(topologyτXExtendedType, Asubsetτ);
			definition(BASE, "base", null, "Basis", "A heißt Basis von ", tau, " bzw. ", topologicalSpaceXτShort,
					"  wenn τ die Menge aller Vereinigungenen von Teilmengen von A ist.");
			MathMLGenerator.displayRule(BASE, new WriteOperation(" Basis von "));
			// example tau ist basis von tau

			SUBBASE = subbase(null, null);
			SUBBASE.setReferences(References.wikiEn("Subbase"), References.wikiDe("Subbasis"), References.top1_1("1.1.7"));
			SUBBASE.be(topologyτXExtendedType, Asubsetτ);
			definition(SUBBASE, "subbase", null, "Subbasis", "A heißt Subbasis von ", tau, " bzw. ", topologicalSpaceXτShort, "  wenn ", Logic.equals(t_A, tau),
					". Damit gibt es zu A auch nur eine einzige Topologie, von der A Subbasis ist. ", tau, " heißt die von A erzeugt Topologie.");
			MathMLGenerator.displayRule(SUBBASE, new WriteOperation(" Subbasis von "));

			TOPOLOGY_IS_BASE = SINGLETON.normal("TOPOLOGY_IS_BASE");
			TOPOLOGY_IS_BASE.be(topologicalSpaceXτExtendedType);
			TOPOLOGY_IS_BASE.setMain(base(tau, topologicalSpaceXτ));
			lemma(TOPOLOGY_IS_BASE, null, null, "Topolgie ist Basis", null);
			TOPOLOGY_IS_BASE.setProofs(Basics.comment("Ergibt sich aus der Definition einer Topologie."));

			BASE_IS_SUBBASE = SINGLETON.normal("BASE_IS_SUBBASE");
			BASE_IS_SUBBASE.be(topologicalSpaceXτExtendedType);
			BASE_IS_SUBBASE.setMain(Bool.implies(base(A, topologicalSpaceXτ), subbase(A, topologicalSpaceXτ)));
			lemma(BASE_IS_SUBBASE, null, null, "Basis ist Subbasis", null);
			BASE_IS_SUBBASE.setProofs(Basics.blankSeparated(Basics.comment("Ergibt sich aus der Konstruktion von"), t_A));

			BASE_ALTERNATIVE = SINGLETON.normal("BASE_ALTERNATIVE");
			BASE_ALTERNATIVE.setReferences(References.top1_1("1.1.9"));
			BASE_ALTERNATIVE.be(topologicalSpaceXτExtendedType, AboldSubsetτ);
			Statement right = Logic.forAll(Belemτ, Logic.forAll(xElemB, Logic.exists(AelemAbold, ClassesSets.elementOf(x, Subset.subclass(A, B)))));
			BASE_ALTERNATIVE.setMain(
					Bool.iff(base(Abold, topologicalSpaceXτ), right));
			lemma(BASE_ALTERNATIVE, null, null, "Alternative Basisdefinition", null);
			BASE_ALTERNATIVE.setProofs(Bool.iffMultiline(base(Abold, topologicalSpaceXτ), //
					Basics.blankSeparated("τ die Menge aller Vereinigungenen von Teilmengen von ", Abold, "ist."), //
					Logic.forAll(Belemτ, Basics.blankSeparated("B ist Menge von Vereinigungenen von Teilmengen von ", Abold)), //
					Logic.forAll(Belemτ, Logic.exists(Subset.subset(Aapos, Abold), Logic.equals(B, Union.arbitraryUnion(Aapos)))), //
					right
			//
			));

			BASE_OF_DISCRETE_TOPOLOGY = SINGLETON.normal("BASE_OF_DISCRETE_TOPOLOGY");
			BASE_OF_DISCRETE_TOPOLOGY.setReferences(References.top1_1("1.1.10"));
			BASE_OF_DISCRETE_TOPOLOGY.be(setX);
			BASE_OF_DISCRETE_TOPOLOGY.setMain(base(ClassesSets.classByPredicate(ClassesSets.explicitSetWithoutName(x), xElemX), Topology.discreteTopology(X)));
			lemma(BASE_OF_DISCRETE_TOPOLOGY, null, null, "Einelementige Mengen sind Basis der diskreten Topologie", null);
			BASE_OF_DISCRETE_TOPOLOGY
					.setProofs(
							Bool.impliesMultiline(//
									Logic.forAll(Belemτ,
											Logic.forAll(xElemB, ClassesSets.elementOf(x, Subset.subclass(ClassesSets.explicitSetWithoutName(x), B)))), //
									Logic.forAll(Belemτ,
											Logic.forAll(xElemB,
													Logic.exists(
															ClassesSets.elementOf(A,
																	ClassesSets.classByPredicate(ClassesSets.explicitSetWithoutName(x), xElemX)),
															ClassesSets.elementOf(x, Subset.subclass(A, B)))))//

			//
							));

			SUBBASE_ALTERNATIVE = SINGLETON.normal("SUBBASE_ALTERNATIVE");
			SUBBASE_ALTERNATIVE.setReferences(References.top1_1("1.1.9"));
			SUBBASE_ALTERNATIVE.be(topologicalSpaceXτExtendedType, AboldSubsetτ);
			Statement left = subbase(Abold, topologicalSpaceXτ);
			right = Logic.forAll(Basics.blankSeparated(Belemτ, Logic.notEquals(B, X)),
					Logic.forAll(xElemB, Logic.exists(Basics.blankSeparated("endliche Teilmenge", Subset.subset(Aapos, Abold)),
							ClassesSets.elementOf(x, Subset.subclass(Intersection.arbitraryIntersection(Aapos), B)))));
			SUBBASE_ALTERNATIVE.setMain(Bool.iff(left, right));
			lemma(SUBBASE_ALTERNATIVE, null, null, "Alternative Subbasisdefinition", null);
			SUBBASE_ALTERNATIVE.setProofs(Bool.iffMultiline(left, //
					Logic.equals(Topology.topologyOfSubset(Abold, X), tau), //
					Basics.proofline(Logic.equals(tau, Basics.blankSeparated("Die Menge aller Vereinigungen von Elementen aus", A_2)),
							Basics.blankSeparated("Laut Konstruktion von", Topology.topologyOfSubset(Abold, X))),
					base(A_2, topologicalSpaceXτ), //
					Logic.forAll(Belemτ, Logic.forAll(xElemB, Logic.exists(ClassesSets.elementOf(A, A_2), ClassesSets.elementOf(x, Subset.subclass(A, B))))), //
					Logic.forAll(Belemτ, Logic.forAll(xElemB,
											Logic.exists(
													ClassesSets
															.elementOf(A,
																	ClassesSets.explicitSetWithoutName(
																			Basics.blankSeparated("Die Menge aller endlichen Schnitte von Elementen aus ",
																					Union.union(A,
																							ClassesSets.explicitSetWithoutName(EmptySet.EMPTY_SET, X))))),
									ClassesSets.elementOf(x, Subset.subclass(A, B))))), //
					Basics.proofline(right, Logic.equals(A, Intersection.arbitraryIntersection(Aapos)))

			//
			));

			BASE_CHARACTERISTICS = SINGLETON.normal("BASE_CHARACTERISTICS");
			BASE_CHARACTERISTICS.setReferences(References.top1_1("1.1.13"));
			BASE_CHARACTERISTICS.be(setX, Subset.subset(Abold, X));
			left = Basics.blankSeparated(Abold, " ist Basis einer geeigneten Topologie", tau, "auf X");
			right = Bool.andMultiline(//
					Basics.proofline(Logic.forAllExists(xElemX, AelemAbold, xElemA), CONDITION_1), //
					Basics.proofline(Logic.forAllExists(Basics.commaSeparated(AelemAbold, BelemAbold, ClassesSets.elementOf(x, AinterB)), CelemAbold,
							ClassesSets.elementOf(x, Subset.subset(C, AinterB))), CONDITION_2));
			BASE_CHARACTERISTICS.setMain(Bool.iffMultiline(left, right));
			lemma(BASE_CHARACTERISTICS, null, null, "Basischarakterisierung", null);
			BASE_CHARACTERISTICS.setProofs(Bool.iffByIf( //
					Bool.implies(base(Abold, topologicalSpaceXτ), Bool.and(CONDITION_1, CONDITION_2)), //
					Basics.multiline( //
							Basics.subproof(Basics.notSeparated(CONDITION_1, ":"), //
									Bool.impliesMultiline(//
											XelemTau, //
											Basics.proofline(Logic.equals(X, Union.arbitraryUnionAapos),
													Basics.blankSeparated(Subset.subset(Aapos, Abold), " geeignet gewählt")), //
											Logic.forAllExists(xElemX, ClassesSets.elementOf(A, Subset.subset(Aapos, Abold)), xElemA)//

									)), //
							Basics.subproof(Basics.notSeparated(CONDITION_2, ":"),
									Bool.impliesMultiline(//
											ClassesSets.elementOf(Basics.commaSeparated(A, B), Abold), //
											ClassesSets.elementOf(Basics.commaSeparated(A, B), tau), //
											ClassesSets.elementOf(AinterB, tau), //
											Basics.proofline(Logic.equals(AinterB, Union.arbitraryUnionCapos),
													Basics.blankSeparated(Subset.subset(Capos, Abold), " geeignet gewählt")), //
											Logic.forAllExists(ClassesSets.elementOf(x, AinterB), ClassesSets.elementOf(C, Subset.subset(Capos, Abold)),
													ClassesSets.elementOf(x, Subset.subset(C, AinterB)))//
									)) //
					), //
					Bool.impliedBy(Bool.and(CONDITION_1, CONDITION_2), base(Abold, topologicalSpaceXτ)), //
					Basics.multiline(Basics.subproof(Basics.notSeparated(top1, ":"), Basics.blankSeparated(XelemTau, "gilt wegen ", CONDITION_1)), //
							Basics.subproof(Basics.notSeparated(top2, ":"),
									Basics.blankSeparated(emptyElemTau, "gilt wegen ", Subset.subset(EMPTY_SET, Abold))), //
							Basics.subproof(Basics.notSeparated(top3, ":"), Basics.blankSeparated(topologyCondition3, " gilt wegen ", CONDITION_2)), //
							Basics.subproof(Basics.notSeparated(top4, ":"),
									Basics.blankSeparated("Beliebige Vereinigung gilt, da ", tau, " so definiert wurde."))//
					) //
			));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(BASE, SUBBASE, TOPOLOGY_IS_BASE, BASE_IS_SUBBASE, BASE_ALTERNATIVE, BASE_OF_DISCRETE_TOPOLOGY, SUBBASE_ALTERNATIVE,
						BASE_CHARACTERISTICS),
				(List) Arrays.asList());
	}

}
