package net.sf.gluebooster.demos.pojo.math.library.topology;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Powerset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class TopologyFactory extends Statements {

	protected static final TopologyFactory SINGLETON = new TopologyFactory();


	protected TopologyFactory() {
		super("Topology", null);
	}


	public static Statement topology(Statement name, Statement subsets, Statement set) {
		return SINGLETON.normal(name, "topology", subsets, set);
	}

	public static Statement indiscreteTopology(Statement set) {
		return SINGLETON.normal("indiscreteTopology", set);
	}

	public static Statement discreteTopology(Statement set) {
		return SINGLETON.normal("discreteTopology", set);
	}

	public static Statement topologicalSpace(Statement name, Statement set, Statement topology) {
		if (name == null && set != null) {
			// name = set;
			name = Basics.notSeparated(set, "_"); // TODO underover
			// name = Basics.underOver(set, Basics.comment("-"), null);
		}
		return SINGLETON.normal(name, "topologicalSpace", set, topology);
	}

	public static Statement topologyOfSubset(Statement subset, Statement set) {
		return SINGLETON.normal("topologyOfSubset", subset, set);

	}

}
