package net.sf.gluebooster.demos.pojo.math.library.topology;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;

public interface TopologySamples extends SetTheorySamples {

	Statement top1 = Basics.comment("Top1");
	Statement top2 = Basics.comment("Top2");
	Statement top3 = Basics.comment("Top3");
	Statement top4 = Basics.comment("Top4");

	Statement topologyCondition3 = Logic.bracket(
			Bool.implies(Bool.and(ClassesSets.elementOf(A, τ), ClassesSets.elementOf(B, τ)), ClassesSets.elementOf(Intersection.intersection(A, B), τ)));

	Statement topologyτX = TopologyFactory.topology(τ, τ, X);
	Statement topologyτXShort = TopologyFactory.topology(τ, τ, X).copy().setDisplayLevel(Statements.SHORT);
	Statement topologyτXExtended = TopologyFactory.topology(τ, τ, X).copy().setDisplayLevel(Statements.EXTENDED);
	Statement topologyτXExtendedType = TopologyFactory.topology(τ, τ, X).copy().setDisplayLevel(Statements.VERY_EXTENDED);

	Statement topologicalSpaceXτ = TopologyFactory.topologicalSpace(null, X, topologyτXShort);
	Statement topologicalSpaceXτShort = topologicalSpaceXτ.copy().setDisplayLevel(Statements.SHORT);
	Statement topologicalSpaceXτExtended = topologicalSpaceXτ.copy().setDisplayLevel(Statements.EXTENDED);
	Statement topologicalSpaceXτExtendedType = topologicalSpaceXτ.copy().setDisplayLevel(Statements.VERY_EXTENDED);

	Statement t_A = TopologyFactory.topologyOfSubset(A, X);

	Statement Asubsetτ = Subset.subset(A, τ);
	Statement AboldSubsetτ = Subset.subset(Abold, τ);

	Statement Belemτ = ClassesSets.elementOf(B, τ);

	Statement AelemAbold = ClassesSets.elementOf(A, Abold);
	Statement BelemAbold = ClassesSets.elementOf(B, Abold);
	Statement CelemAbold = ClassesSets.elementOf(C, Abold);

	Statement XelemTau = ClassesSets.elementOf(X, tau);
	Statement emptyElemTau = ClassesSets.elementOf(EmptySet.EMPTY_SET, τ);

}
