package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.swing.text.html.HTML.Tag;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.MathML;
import net.sf.gluebooster.demos.pojo.math.MathStudies;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.VariableExamples;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Numbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Relation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.java.booster.basic.meta.DocumentationContext;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.meta.objects.TextDescription;
import net.sf.gluebooster.java.booster.essentials.utils.Check;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.DomBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;
import net.sourceforge.jeuclid.elements.generic.MathImpl;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.script.Mmultiscripts;
import net.sourceforge.jeuclid.elements.presentation.script.Munderover;
import net.sourceforge.jeuclid.elements.presentation.script.None;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;

/**
 * Transforms Statements into MathML.
 * 
 * @see https://de.wikipedia.org/wiki/Unicodeblock_Mathematische_Operatoren
 * @see http://xahlee.info/comp/unicode_math_font.html
 * @see https://developer.mozilla.org/en-US/docs/Web/MathML/Element
 * @see https://www.w3.org/TR/MathML/chapter3.html
 * @author cbauer
 *
 */
public class MathMLGenerator extends CallableAbstraction<Object, Node> implements VariableExamples {

	private Statement breakpoint = Relation.BINARY_RELATION;//
	/**
	 * The used markup
	 */
	private MathML mathml = MathML.createPreferredMarkup();

	private DocumentationContext contextWithLanguage;

	private static Object USE_VARIABLES = RuleSelect.USE_VARIABLES;
	private static Object NULL = RuleSelect.NULL;
	private static Object FIRST_VARIABLE = RuleSelect.FIRST_VARIABLE;
	private static Object SECOND_VARIABLE = RuleSelect.SECOND_VARIABLE;
	private static Object THIRD_VARIABLE = RuleSelect.THIRD_VARIABLE;
	private static Object FOURTH_VARIABLE = RuleSelect.FOURTH_VARIABLE;
	private static Object NAME = RuleSelect.NAME;
	private static Object NAME_OF_FIRST_VARIABLE = RuleSelect.NAME_OF_FIRST_VARIABLE;
	private static Object FIRST_VARIABLE_OF_FIRST_VARIABLE = RuleSelect.FIRST_VARIABLE_OF_FIRST_VARIABLE;
	private static Object SELF = RuleSelect.SELF;
	private static Object AFTER_FIRST_VARIABLE = RuleSelect.AFTER_FIRST_VARIABLE;
	private static Object ALL_VARIABLES = RuleSelect.ALL_VARIABLES;

	/**
	 * Statements that are operation like (with prefix, infixes between parts and suffix)
	 */
	private static Map<Statement, WriteOperation> OPERATIONS;


	/**
	 * Templates for the display in simple form and for extended display;
	 */
	private static Map<Statement, Callable<RuleContext<Statement>, Node>> RULES = new HashMap();

	/**
	 * Transformations from one statement into another statement. The first element of the array is the template of the statement. The other are the variables.
	 * If there are any arrays within, they interpreted as a inner transformation
	 * 
	 */

	// Create a transformation that returns the name of the definition of this object
	public static RuleTransformation NAME_OF_DEFINITION;// = new RuleTransformation(Basics.DEF_NAMES, SELF);
	public static Write WRITE_NAME_OF_DEFINITION;// = new WriteAfterStatementTransformation(NAME_OF_DEFINITION);

	// Create a transformation that returns the name of the instance of this object
	public static RuleTransformation NAME_OF_INSTANCE;// = new RuleTransformation(Basics.NOT_SEPARATED, NAME);
	public static Write WRITE_NAME_OF_INSTANCE;// = new WriteAfterStatementTransformation(NAME_OF_INSTANCE);

	public static final Write WRITE_NAME = new WriteMulti(NAME);
	public static final Write WRITE_NAME_DEFINED_AS_FIRST_SECOND = new WriteMulti(NAME, ":= (", FIRST_VARIABLE, ",", SECOND_VARIABLE, ")");
	public static final Write WRITE_NAME_DEFINED_AS_FIRST_SECOND_THIRD = new WriteMulti(NAME, ":= (", FIRST_VARIABLE, ",", SECOND_VARIABLE, ",",
			THIRD_VARIABLE, ")");

	public static final Write WRITE_OPERATION_COMMA_SEPARATED = new WriteOperation(", ");
	// public static final WriteOperation WRITE_OPERATION_AND = new WriteOperation("∧");
	public static final Write WRITE_OPERATION_EQUALS = new WriteOperation("=");
	public static final Write WRITE_OPERATION_BRACKETS_AND_COMMA = new WriteOperation("(", ", ", ")");

	public static Write SHORT_NAME_DEFAULT_TUPLE_EXTENDED_DEFINED;// = WriteExtended.shortDefault(MathMLGenerator.WRITE_NAME,
	// WRITE_OPERATION_BRACKETS_AND_COMMA, new WriteMulti(NAME, ":= ", WRITE_OPERATION_BRACKETS_AND_COMMA),
	// new WriteMulti(NAME, ":= ", WRITE_OPERATION_BRACKETS_AND_COMMA, " ", WRITE_NAME_OF_DEFINITION));

	public static Callable selectFirstVariable = new RuleSelect(FIRST_VARIABLE);

	public static Write WRITE_DELEGATE_TO_FIRST_VARIABLE; // = WriteExtended.shortDefault(
	// WriteAfterStatementTransformation.selectThenWrite(selectFirstVariable, WRITE_NAME), //
	// WriteAfterStatementTransformation.selectThenWrite(selectFirstVariable, WRITE_OPERATION_BRACKETS_AND_COMMA), //
	// WriteAfterStatementTransformation.selectThenWrite(selectFirstVariable, new WriteMulti(NAME, ":= ", WRITE_OPERATION_BRACKETS_AND_COMMA)), //
	// new WriteMulti(
	// WriteAfterStatementTransformation.selectThenWrite(selectFirstVariable, new WriteMulti(NAME, ":= ", WRITE_OPERATION_BRACKETS_AND_COMMA)),
	// " ", WRITE_NAME_OF_DEFINITION)//
	// );

	public static final CallableAbstraction<RuleContext<Statement>, Node> MISSING_DISPLAY = new WriteMulti("MISSING DISPLAY !!!");

	public static CallableAbstraction<RuleContext<Statement>, Node> writeMultiline(Statement operator) {

		return new WriteOperation(//
				GraphElementDescription.createNestedParentElementsWithIndex(0, Mtable.ELEMENT, Mtr.ELEMENT, Mtd.ELEMENT), //
				GraphElementDescription.createNestedParentElementsWithIndex(1, Mtr.ELEMENT, Mtd.ELEMENT, operator), //
				null);
	}

	public static CallableAbstraction<RuleContext<Statement>, Node> writeMultilineOperatorSeparate(Statement operator) {

		return new WriteOperation(//
				GraphElementDescription.createNestedParentElementsWithIndex(0, Mtable.ELEMENT, Mtr.ELEMENT, Mtd.ELEMENT), //
				new Object[] { GraphElementDescription.createNestedParentElementsWithIndex(1, Mtr.ELEMENT, Mtd.ELEMENT, operator), // operator separate
						GraphElementDescription.createNestedParentElementsWithIndex(1, Mtr.ELEMENT, Mtd.ELEMENT),// a new line
				}, //
				null);
	}

	public MathMLGenerator() {

		// operations with optional prefix, infix, suffix
		Object[][] operationsArray = { // statements and their pre-/in-/suffix
				{ Basics.COMMA_SEPARATED, RelationBinary.INDEXED_FAMILY_FINITE, Tuples.TUPLE_WITHOUT_BRACKETS }, { WRITE_OPERATION_COMMA_SEPARATED }//
				, { Basics.BLANK_SEPARATED }, { new WriteOperation(TextBoostUtils.NON_BREAKING_SPACE) }//
				, { Basics.NOT_SEPARATED }, { new WriteOperation(null) }//
				, { Basics.MULTILINE },
				{ new WriteOperation(GraphElementDescription.createNestedParentElementsWithIndex(0, Mtable.ELEMENT, Mtr.ELEMENT, Mtd.ELEMENT),
						GraphElementDescription.createNestedParentElements(Mtr.ELEMENT, Mtd.ELEMENT), null) }//
				, { Basics.MANTISSA_INDEX_EXPONENT },
				{ new WriteOperation(GraphElementDescription.createNestedParentElements(Mmultiscripts.ELEMENT),
						GraphElementDescription.createNestedParentElements(Mrow.ELEMENT), null) }//
				, { Basics.UNDEROVER },
				{ new WriteOperation(GraphElementDescription.createNestedParentElements(Munderover.ELEMENT),
						GraphElementDescription.createNestedParentElements(Mrow.ELEMENT), null) }//

				, { Logic.BRACKET, Tuples.ORDERED_PAIR, Tuples.TUPLE, Relation.N_ARY_RELATION, Relation.UNARY_RELATION, Relation.BINARY_RELATION },
				{ WRITE_OPERATION_BRACKETS_AND_COMMA }//
				};




		OPERATIONS = new HashMap<Statement, WriteOperation>();
		for (int i = 0; i < operationsArray.length; i = i + 2) {
			Object[] statements = operationsArray[i];
			Object[] rule = operationsArray[i + 1];
			for (Object statement : statements) {
				OPERATIONS.put((Statement) statement, (WriteOperation) rule[0]);
			}
		}

	}

	public MathMLGenerator(DocumentationContext contextWithLanguage) {
		this();
		this.contextWithLanguage = contextWithLanguage;
	}

	private Element addTag(Document doc, Node parent, String tag) throws Exception {
		return DomBoostUtils.appendElement(doc, parent, tag);
	}


	/**
	 * 
	 * @param doc
	 * @param parent
	 * @param returnElementIndex
	 *            return the element created from the element with that index. Null = return last
	 * @param elements
	 * @param original
	 *            may be used to transform the elements
	 * @return
	 * @throws Exception
	 */
	public Node addNestedElements(Document doc, Node parent, Integer returnElementIndex, Statement original, Object... elements) throws Exception {
		int size = elements.length;
		int returnIndex = (returnElementIndex == null) ? Integer.MAX_VALUE : returnElementIndex;
		Node result = parent;
		for (int i = 0; i < size; i++){
			Object element = elements[i];
			if ((element instanceof String) && i < size - 1) {
				element = GraphElementDescription.createNestedParentElements(element);
				// to create a tag instead of a text
			}
			parent = callWith(new RuleContext(doc, parent, element, original, false, this));
			if (i <= returnIndex) {
				result = parent;
			}
		}
		
		return result;
	}

	private Node addElement(Document doc, Node parent, Statement anchor, String tag, Object content) throws Exception {
		return addNestedElements(doc, parent, null, null, GraphElementDescription.createReference(anchor), tag, content);

		// parent = addElement(doc, parent, GraphElementDescription.createReference(anchor));
		// return addElement(doc, parent, tag, content);
	}

	private Node addElement(Document doc, Node parent, GraphElementDescription element) throws Exception {
		Object[] elements = element.getElements();
		if (elements == null || elements.length == 0) {
			// nothing to do
			return parent;
		}

		// if (elements.length > 1) {
		// getLog().debug("test, delete later");
		// }


		if (element.isReference()) {
			if (elements.length != 1) {
				throw new IllegalStateException("only one reference supported yet");
			}
			return addAnchor(doc, parent, (Statement) elements[0]);
		} else if (element.isParent()) {
			// create tags
			boolean nested = element.isElementsNested();

			Integer indexToReturn = element.getMostImportantElementIndex();
			int maxIndex = indexToReturn == null ? Integer.MAX_VALUE : indexToReturn;
			int index = 0;
			Node part;
			for (Object elem : elements) {
				if (elem instanceof String) {
					part = addTag(doc, parent, (String) elem);
				} else {
					part = callWith(new RuleContext(doc, parent, elem, null, false, this));
				}
				if (nested && part != null && index <= maxIndex) {
					parent = part;
				}
				index++;
			}
			return parent;
		} else {
			throw new IllegalStateException("GraphElementDescription not yet supported");
		}
	}

	@Override
	protected Node callImpl(Object... documentNodeStatement) throws Exception {
		Document doc = (Document) documentNodeStatement[0];
		Node parent = (Node) documentNodeStatement[1];
		Object statements = documentNodeStatement[2];
		Node result = addTag(doc, parent, MathImpl.ELEMENT);
		callWith(new RuleContext(doc, result, statements, null, false, this));
		// return "
		// <mpadded><msup><mi></mi><mn>∞</mn></msup><mo>=</mo><mn>116</mn><mo>×</mo><mroot><mfrac><mi>Y</mi><msub><mi>Y</mi><mn>n</mn></msub></mfrac><mn>3</mn></mroot><mo>-</mo><mn>16</mn></mpadded></math>";
		return result;
	}

	/**
	 * @param doc
	 * @param parent
	 * @param original
	 *            the original statement that may be used to evaluate the parameter
	 * @param parameter
	 * @throws Exception
	 * @return created node
	 */
	public Node callWith(RuleContext context) throws Exception {
		Document doc = context.getDoc();
		Node parent = context.getParent();
		Object parameter = context.getToTransform();
		Statement original = context.getOriginal();
		boolean mathmlResultNeeded = context.isMathmlResultNeeded();
		
		// // symbols must have a nameOfInstance that is used to identify them
		// Map<Statement, String> symbols = ContainerBoostUtils.createMap(//Boolean.BOOLEAN_SET, "\u23b9B" // new String(new int[] { 0x1d539 }, 0, 1)
		// // \u23b9 is a vertical line
		// // , EmptySet.EMPTY_SET, "\u2205"//
		// // , NaturalNumbers.SET_OF_NATURAL_NUMBERS_INFORMAL, "\u2115"//
		// );
		
		Node returnValue = null;

		if (parameter == null) {
			return parent;// nothing to do
		} else if (parameter instanceof String) {
			if (mathmlResultNeeded) {
				return addNestedElements(doc, parent, 0, null, Mo.ELEMENT, parameter);
				// maybe another element instead of Mo would be better
			} else {
				return DomBoostUtils.appendText(doc, parent, (String) parameter);
			}
		} else if (parameter instanceof Tag) {
			if (mathmlResultNeeded) {
				return addNestedElements(doc, parent, null, null, Mo.ELEMENT, parameter);
				// maybe another element instead of Mo would be better
			} else {
				return DomBoostUtils.appendElement(doc, parent, parameter);
			}

			// return append(doc, parent, parameter, true);

		} else if (parameter instanceof Collection) {

			for (Object param : ((Collection) parameter)) {
				returnValue = callWith(new RuleContext(doc, parent, param, null, false, this));
			}
			return returnValue;
		} else if (parameter.getClass().isArray()) {
			return callWith(new RuleContext(doc, parent, transform(original, (Object[]) parameter), null, false, this));
		} else if (parameter instanceof GraphElementDescription) {
			return addElement(doc, parent, (GraphElementDescription) parameter);
		} else if (parameter instanceof Statement) {
			Node result = null;
			Statement statement = (Statement) parameter;
			String identifier = statement.getIdentifier().toString();
			Statement nameOfInstance = statement.getNameOfInstance();

			if (statement.getDisplayVariant() != null) {
				if (!statement.getDisplayVariant().getVariant().isEmpty()) {
				String xxx = "not empty";
				}
			}

			if (breakpoint != null && breakpoint.is(statement)) {
				System.out.println("debug here");
			}

			List<Statement> variables = statement.getVariables();
			if (variables == null) {
				variables = Collections.EMPTY_LIST;
			}
			Statement var0 = null;
			Statement var1 = null;
			
			if (!variables.isEmpty()) {
				int size = variables.size();
				var0 = variables.get(0);
				if (size > 1){
					var1 = variables.get(1);
				}
			}
			
			// first more specific symbols and name displays, then the general operations
			
			if (Basics.COMMENT.is(statement) || Numbers.NUMBER_INFORMAL.is(statement)) {
				result = append(doc, parent, statement.getDescription(), false);
			} else if (Basics.DEF_NAMES.is(statement)) {
				boolean init = true;
				for (Statement var : variables) {
					if (!init) {
						append(doc, parent, ", ", true);
					} else {
						init = false;
					}
					returnValue = callWith(new RuleContext(doc, parent, MathStudies.translateTermDefinition(contextWithLanguage, var), null, false, this));

				}
				result = returnValue;
			}

			


			// operations
			if (result == null) {
				for (Map.Entry<Statement, WriteOperation> operation : OPERATIONS.entrySet()) {
					if (operation == null) {
						throw new NullPointerException("operator must not be null");
					} else if (operation.getKey() == null) {
						throw new NullPointerException("operator key must not be null of " + operation);
					} else if (operation.getKey().is(statement)) {
						result = operation.getValue()
								.call(new RuleContext(doc, parent, statement/* new Statement(null, variables) */, original, mathmlResultNeeded, this));
						break;
						// return operation(doc, parent, operation.getValue(), variables, mathmlResultNeeded);
					}
				}
			}
			
			if (result == null) {
			for (Entry<Statement, Callable<RuleContext<Statement>, Node>> template : RULES.entrySet()) {
				
				if (template.getKey().is(statement)) {
					if (breakpoint.is(statement)) {
						getLog().debug("breakpoint");
					}

						result = template.getValue().call(new RuleContext<Statement>(doc, parent, statement, original, mathmlResultNeeded, this));
						break;
				}
			}
			}
			
			if (result == null) {

				if (Basics.MATH_TABLE.is(statement)) {
					result = callWith(new RuleContext(doc, parent, Basics.toTable(statement), null, false, this));

				} else if (Basics.TABLE.is(statement)) {
					Element table = DomBoostUtils.appendElement(doc, parent, "table", ContainerBoostUtils.createMap("border", "1px"));
					Element head = DomBoostUtils.appendElement(doc, table, "thead");
					Element body = DomBoostUtils.appendElement(doc, table, "tbody");

					Object[][] matrix = statement.getRawData();
					boolean firstRow = true;
					for (Object[] row : matrix) {
						Element node = firstRow ? head : body;
						firstRow = false;
						Element tr = DomBoostUtils.appendElement(doc, node, "tr");
						for (Object col : row) {
							String tag = firstRow ? "th" : "td";
							Element td = DomBoostUtils.appendElement(doc, tr, tag);
							callWith(new RuleContext(doc, td, col, null, false, this));
						}
					}

					result = table;
				} else if (Logic.VARIABLE.is(statement) || ClassesSets.CLASS.is(statement)) {
					// boolean test = Logic.VARIABLE.is(statement);
					// test = Classes.CLASS.is(statement);
					String name = statement.getIdentifier().get(3);
					Statement index = null;
					if (!variables.isEmpty()) {
						index = Basics.blankSeparated(variables);
					}


					result = addMultiscript(doc, parent, original, name, index, null, null, null);

				} else if (References.REFERENCE.is(statement)) {
					List<Statement> parts = statement.getVariables();
					Statement baseReference = parts.get(0);
					if (baseReference == null) {
						// more detailed
						Statement url = parts.get(3);
						Node node = parent;
						String text = null;

						if (url != null) {
							String urlText = url.getIdentifier().get(3);
							text = urlText;
							node = DomBoostUtils.appendElement(doc, parent, "a",
									ContainerBoostUtils.createMap("rel", "noopener", "target", "_blank", "href", urlText));
						}

						if (parts.get(1) != null) {
							text = parts.get(1).getIdentifier().get(3);
						}
						result = DomBoostUtils.appendText(doc, node, text); // name

					} else {
						// less detailed, because it is assumed that the base is stated elsewhere in detail
						Statement urlPrefix = baseReference.getVariables().get(4);
						Statement urlSuffix = parts.get(5);
						Statement[] url = null;
						boolean hasUrl = urlPrefix != null && urlSuffix != null;
						if (hasUrl) {
							url = new Statement[] { urlPrefix, urlSuffix };
						} else {
							if (parts.get(3) != null) {
								url = new Statement[] { parts.get(3) };
							}
						}

						Node node = parent;
						if (url != null) {
							StringBuilder href = new StringBuilder();
							for (Statement part : url) {
								href.append(part.getIdentifier().get(3));
							}
							node = DomBoostUtils.appendElement(doc, parent, "a",
									ContainerBoostUtils.createMap("rel", "noopener", "target", "_blank", "href", href));
						}

						// go up the reference chain and display the short name of each
						Statement ref = statement;
						StringBuilder shortnames = new StringBuilder();

						while (ref != null) {
							if (shortnames.length() > 0) {
								shortnames.insert(0, " ");
							}
							shortnames.insert(0, ref.getVariables().get(2).getIdentifier().get(3));
							ref = ref.getVariables().get(0);
						}
						result = DomBoostUtils.appendText(doc, node, shortnames);

						// DomBoostUtils.appendText(doc, node, baseReference.getVariables().get(2).getIdentifier().get(3)); // base.shortname
						// DomBoostUtils.appendText(doc, node, parts.get(2).getIdentifier().get(3));// statement.shortname

						// builder.append("sub reference <a target='_blank' href='http://www.heise.de'>test</a>");
					 }
				} else {
					// default: print the property
					if (var0 != null) {
						callWith(new RuleContext(doc, parent, var0, null, false, this));
						callWith(new RuleContext(doc, parent, TextBoostUtils.NON_BREAKING_SPACE, null, false, this));
					}
					result = callWith(new RuleContext(doc, parent, MathStudies.translateTermDefinition(contextWithLanguage, parameter), null, false, this));

					// boolean test = true;
					// if (test) {
					// callWith(doc, parent, parameter);
					// }
					//
					// throw new IllegalStateException("statement not (yet)supported: " + statement.getIdentifier());

				}
			}

			TextDescription variants = statement.getDisplayVariant();
			if (result != null && (result instanceof Element) && variants != null && !variants.getVariant().isEmpty()) {
				Element element = (Element) result;
				Set<Object> values = variants.getVariant();
				if (values.contains(TextDescription.BOLD)) {
					element.setAttribute("mathvariant", "bold");
				}
			}
			return result;

		} else {
			throw new IllegalStateException("parameter not supported: " + parameter.getClass().getSimpleName());
		}
	}



	private Element addAnchor(Document doc, Node parent, Statement definition) throws Exception {
		Element result = addTag(doc, parent, "a");
		result.setAttribute("href", "#" + definition.getIdentifyingName());
		return result;
	}

	/**
	 * Add operator
	 * 
	 * @param doc
	 * @param parent
	 * @param operator
	 * @return
	 */
	private Node addMo(Document doc, Node parent, Object operator, Statement anchorRef) throws Exception {
		return addNestedElements(doc, parent, null, null, GraphElementDescription.createReference(anchorRef), Mo.ELEMENT, operator);

	}

	/**
	 * Adds a element with index and exponent before and after the element.
	 * 
	 * @param doc
	 * @param parent
	 * @param original
	 * @param mantissa
	 * @param index
	 * @param exponent
	 * @param preIndex
	 * @param preExponent
	 * @return
	 * @throws Exception
	 */
	private Node addMultiscript(Document doc, Node parent, Statement original, Object mantissa, Object index, Object exponent, Object preIndex,
			Object preExponent) throws Exception {
		if (preIndex != null || preExponent != null){
			throw new IllegalStateException("not yet implemented");
		}
		
		Node root = parent;
		boolean scriptsAreNull = Check.allNull(false, null, index, exponent, preIndex, preExponent);
		
		if (!scriptsAreNull) {
			root = addTag(doc, parent, Mmultiscripts.ELEMENT);
		}


		Node mantissaElement = callWith(new RuleContext(doc, root, mantissa, original, true, this));

		if (scriptsAreNull) {
			return mantissaElement;
		}


		// indices
		if (index != null) {
			callWith(new RuleContext(doc, root, index, original, true, this));
		} else {
			addTag(doc, root, None.ELEMENT);
		}
		// Collection indices;
		// if (index == null) {
		// indices = Collections.EMPTY_LIST;
		// } else if (index instanceof Collection) {
		// indices = (Collection) index;
		// } else if (index.getClass().isArray()) {
		// indices = Arrays.asList(ContainerBoostUtils.toObjectArray(index));
		// } else {
		// indices = Arrays.asList(index);
		// }
		// if (indices.isEmpty()) {
		// addTag(doc, root, None.ELEMENT);
		// } else {
		// Element mi = addTag(doc, root, Mi.ELEMENT);
		// for (Object ind : indices) {
		// callWith(doc, mi, ind, original, false);
		// }
		// }

		// exponent
		if (exponent != null) {
			callWith(new RuleContext(doc, root, exponent, original, true, this));
		} else {
			addTag(doc, root, None.ELEMENT);
		}

		// Collection exponents;
		// if (exponent == null) {
		// exponents = Collections.EMPTY_LIST;
		// } else if (exponent instanceof Collection) {
		// exponents = (Collection) index;
		// } else if (exponent.getClass().isArray()) {
		// exponents = Arrays.asList(ContainerBoostUtils.toObjectArray(exponent));
		// } else {
		// exponents = Arrays.asList(exponent);
		// }
		// if (exponents.isEmpty()) {
		// addTag(doc, root, None.ELEMENT);
		// } else {
		// Element mi = addTag(doc, root, Mi.ELEMENT);
		// for (Object ind : exponents) {
		// callWith(doc, mi, ind, null, false);
		// }
		// }


		return root;

	}



	/**
	 * Appends one object
	 * 
	 * @param doc
	 * @param parent
	 * @param toBeAppended
	 * @return
	 */
	private Node append(Document doc, Node parent, Object toBeAppended, boolean throwExceptionIfNull) {
		if (toBeAppended == null) {
			if (throwExceptionIfNull) {
				Check.notNull(toBeAppended, "toBeAppended");
			} else {
				return null; // nothing has been done
			}
		}

		if (toBeAppended instanceof String) {
			return DomBoostUtils.appendText(doc, parent, (String) toBeAppended);
		} else if (toBeAppended instanceof Tag) {
			return DomBoostUtils.appendElement(doc, parent, toBeAppended);
		}

		throw new IllegalStateException("type not supported yet: " + toBeAppended.getClass().getSimpleName());
	}

	/**
	 * Append nodes that describe the operation. Only one node is appeded to the parent. This node may have multiple subnodes.
	 * 
	 * @param doc
	 * @param parent
	 * @param operation
	 * @param args
	 * @return the root node of the operation.
	 * @throws Exception
	 */
	// private Node operation(Document doc, Node parent, OperationRule operation, List<Statement> args, boolean mathmlResultNeeded)
	// throws Exception {
	//
	// return operation.call(new RuleContext(doc, parent, new Statement(null, args), null, mathmlResultNeeded, this));
	// }

	private Statement transform(Statement original, Object[] transformationRule) throws Exception {
		return RuleTransformation.create(transformationRule).call(new RuleContext(null, null, original, original, false, this));

	}

	public static void displayRule(Statement statement, Callable<RuleContext<Statement>, Node> rule) throws Exception {
		Object name = rule.getName();

		if (name == null) {
			rule.setName(statement);
		} else {
			rule.setName("" + name + "(" + statement + ")");
		}

		MathMLGenerator.RULES.put(statement, rule);
	}

	public void setBreakpoint(Statement breakpoint) {
		this.breakpoint = breakpoint;
	}

}
