package net.sf.gluebooster.demos.pojo.math.studies;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;

public class RuleContext<ToTransform> implements Cloneable {

	private Document doc;
	private Node parent;
	private ToTransform toTransform;
	private Statement original;
	private boolean mathmlResultNeeded;
	private MathMLGenerator mathMlGenerator;

	private RuleContext() {
	}

	public RuleContext(Document doc, Node parent, ToTransform toTransform, Statement original, boolean mathmlResultNeeded, MathMLGenerator mathmlGenerator) {
		super();
		this.doc = doc;
		this.parent = parent;
		this.toTransform = toTransform;
		this.original = original;
		this.mathmlResultNeeded = mathmlResultNeeded;
		this.mathMlGenerator = mathmlGenerator;
	}

	public Document getDoc() {
		return doc;
	}

	public void setDoc(Document doc) {
		this.doc = doc;
	}

	public Node getParent() {
		return parent;
	}

	public void setParent(Node parent) {
		this.parent = parent;
	}


	public Statement getOriginal() {
		return original;
	}

	public void setOriginal(Statement original) {
		this.original = original;
	}

	public boolean isMathmlResultNeeded() {
		return mathmlResultNeeded;
	}

	public void setMathmlResultNeeded(boolean mathmlResultNeeded) {
		this.mathmlResultNeeded = mathmlResultNeeded;
	}

	public ToTransform getToTransform() {
		return toTransform;
	}

	public void setToTransform(ToTransform toTransform) {
		this.toTransform = toTransform;
	}

	public MathMLGenerator getMathMlGenerator() {
		return mathMlGenerator;
	}

	public void setMathMlGenerator(MathMLGenerator mathMlGenerator) {
		this.mathMlGenerator = mathMlGenerator;
	}

	public <NewTransform> RuleContext<NewTransform> cloneMe(NewTransform toTransform) throws Exception {
		RuleContext result = (RuleContext) clone();
		result.toTransform = toTransform;
		return result;
	}
}
