package net.sf.gluebooster.demos.pojo.math.studies;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;

public class RuleContextSelect extends CallableAbstraction<RuleContext<Statement>, Statement> {

	private Callable<Statement, Statement> trafo;

	public RuleContextSelect(Callable<Statement, Statement> trafo) {
		this.trafo = trafo;
	}

	@Override
	protected Statement callImpl(RuleContext<Statement>... parameters) throws Exception {
		RuleContext<Statement> context = parameters[0];
		return (Statement) trafo.call(context.getToTransform());
	}

}
