package net.sf.gluebooster.demos.pojo.math.studies;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.utils.Check;

public class RuleDisplaytype extends CallableAbstraction<Statement, Statement> {

	private Callable<Statement, Statement> shortDisplayRule;
	private Callable<Statement, Statement> normalDisplayRule;
	private Callable<Statement, Statement> extendedDisplayRule;

	private RuleDisplaytype() {
	}

	public RuleDisplaytype(Callable<Statement, Statement> normalDisplay) {
		this(normalDisplay, normalDisplay, normalDisplay);
	}

	public RuleDisplaytype(Callable<Statement, Statement> shortDisplayRule, Callable<Statement, Statement> normalDisplayRule,
			Callable<Statement, Statement> extendedDisplayRule) {
		Check.notNull(normalDisplayRule, "normalDisplayRule");

		if (shortDisplayRule != null) {
			this.shortDisplayRule = shortDisplayRule;
		} else {
			this.shortDisplayRule = normalDisplayRule;
		}

		this.normalDisplayRule = normalDisplayRule;

		if (extendedDisplayRule != null) {
			this.extendedDisplayRule = extendedDisplayRule;
		} else {
			this.extendedDisplayRule = normalDisplayRule;
		}
	}

	@Override
	protected Statement callImpl(Statement... parameters) throws Exception {
		if (parameters.length != 1) {
			throw new IllegalStateException("only 1 parameter expected");
		}
		Statement original = parameters[0];

		Callable<Statement, Statement> rule;

		if (Statements.EXTENDED == original.getDisplayLevel()) {
			rule = extendedDisplayRule;
		} else if (Statements.SHORT == original.getDisplayLevel()) {
			rule = shortDisplayRule;
		} else {
			rule = normalDisplayRule;
		}

		return rule.call(original);
	}

}
