package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;

/**
 * Rule for operations with a mantissa and indices, exponents before/after. ??Needed, because there is already a multiscript rule in mathml generator.
 * 
 * @author cbauer
 *
 */
public class RuleMultiscript extends CallableAbstraction<RuleContext<Statement>, Node> {

	private Object mantissa;
	private Object index;
	private Object exponent;
	private Object preIndex;
	private Object preExponent;

	private RuleMultiscript() {
	}

	public RuleMultiscript(Object mantissa) {
		this.mantissa = mantissa;
	}

	public RuleMultiscript(Object mantissa, Object index, Object exponent, Object preIndex, Object preExponent) {
		super();
		this.mantissa = mantissa;
		this.index = index;
		this.exponent = exponent;
		this.preIndex = preIndex;
		this.preExponent = preExponent;
	}

	public static RuleMultiscript index(Object mantissa, Object index) {
		return new RuleMultiscript(mantissa, index, null, null, null);
	}

	public static RuleMultiscript exponent(Object mantissa, Object exponent) {
		return new RuleMultiscript(mantissa, null, exponent, null, null);
	}


	@Override
	protected Node callImpl(RuleContext<Statement>... parameters) throws Exception {
		RuleContext<Statement> context = parameters[0];
		Node parent = context.getParent();
		boolean mathmlResultNeeded = context.isMathmlResultNeeded();
		Document doc = context.getDoc();
		MathMLGenerator mathml = context.getMathMlGenerator();

		throw new UnsupportedOperationException("not yet implemented");
	}

}
