package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;

public class RuleSelect extends CallableAbstraction<Statement, Object> {

	public static Object NULL = "::NULL";
	public static Object USE_VARIABLES = "use variables";
	public static Object FIRST_VARIABLE = "::first variable";
	public static Object SECOND_VARIABLE = "::second variable";
	public static Object THIRD_VARIABLE = "::third variable";
	public static Object FOURTH_VARIABLE = "::fourth variable";
	public static Object FIFTH_VARIABLE = "::fifth variable";
	public static Object NAME = "::name";
	public static Object NAME_OF_FIRST_VARIABLE = "::name of first variable";
	public static Object FIRST_VARIABLE_OF_FIRST_VARIABLE = "::first variable of first variable";
	public static Object SELF = "::self";
	public static Object AFTER_FIRST_VARIABLE = "::after first variable";
	public static Object ALL_VARIABLES = "::all variables";

	/**
	 * One of the constants to select something special or any other object that will be returned as selection.
	 */
	private Object select;

	/**
	 * Should a select of class string be converted into a comment statement.
	 */
	private boolean stringToComment = true;

	private RuleSelect() {
	}
	
	/**
	 * The result of the call will always be a statement
	 * 
	 * @param selectionRule
	 */
	public RuleSelect(Object selectionRule) {
		setSelect(selectionRule);
	}



	public RuleSelect(Object select, boolean stringToComment) {
		this.select = select;
		this.stringToComment = stringToComment;
	}



	public <Result> Result getSelect() {
		return (Result) select;
	}

	public void setSelect(Object select) {
		this.select = select;
	}


	public Statement transform(Statement original) throws Exception {

		return select(original, select, stringToComment);

	}

	/**
	 * 
	 * @param statement
	 *            may be null, then the selector will be returned (as comment)
	 * @param selector
	 * @param stringToComment
	 *            should a string be converted into a comment
	 * @return
	 */
	public static <Result> Result select(Statement statement, Object selector, boolean stringToComment) throws Exception {
		// Check.notNull(statement, "statement");//statement may be null, then the selector will be returned (commented)
		List<Statement> variables = null;
		if (statement != null) {
			variables = statement.getVariables();
		}

		if (USE_VARIABLES.equals(selector)) {
			return (Result) statement.getVariables();
		} else if (FIRST_VARIABLE.equals(selector)) {
			return ContainerBoostUtils.getFromList(variables, 0);
		} else if (SECOND_VARIABLE.equals(selector)) {
			return ContainerBoostUtils.getFromList(variables, 1);
		} else if (THIRD_VARIABLE.equals(selector)) {
			return ContainerBoostUtils.getFromList(variables, 2);
		} else if (FOURTH_VARIABLE.equals(selector)) {
			return ContainerBoostUtils.getFromList(variables, 3);
		} else if (FIFTH_VARIABLE.equals(selector)) {
			return ContainerBoostUtils.getFromList(variables, 4);
		} else if (NAME.equals(selector)) {
			return (Result) statement.getNameOfInstance();
		} else if (NAME_OF_FIRST_VARIABLE.equals(selector)) {
			return (Result) variables.get(0).getNameOfInstance();
		} else if (FIRST_VARIABLE_OF_FIRST_VARIABLE.equals(selector)) {
			return (Result) variables.get(0).getVariables().get(0);
		} else if (AFTER_FIRST_VARIABLE.equals(selector)) {
			return (Result) variables.subList(1, variables.size());
		} else if (ALL_VARIABLES.equals(selector)) {
			return (Result) variables;
		} else if (SELF.equals(selector)) {
			return (Result) statement;
		} else if (NULL.equals(selector)) {
			return null;
		} else if (selector instanceof Callable) {
			return (Result) ((Callable) selector).call(new RuleContext(null, null, statement, null, false, null));
		} else {
			if (stringToComment && (selector instanceof String)) {
				return (Result) Basics.comment((String) selector);
			} else {
				return (Result) selector;
			}
		}

	}

	@Override
	protected Object callImpl(Statement... onlyOneStatementAllowed) throws Exception {
		Statement statement = null;
		if (onlyOneStatementAllowed.length > 0) {
			statement = onlyOneStatementAllowed[0];
		}
		return select(statement, select, stringToComment);
	}

}
