package net.sf.gluebooster.demos.pojo.math.studies;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;

/**
 * Creates a new Statement by using the identifier of a template and optionally a name of instance.
 * 
 * @author cbauer
 *
 */
public class RuleStatementCreator extends CallableAbstraction<Statement, Statement> {

	private Object nameOfInstance;
	private Statement template;

	private RuleStatementCreator() {
	}

	public RuleStatementCreator(Statement template) {
		this.template = template;
	}

	public RuleStatementCreator(Statement template, Object nameOfInstance) {
		this.nameOfInstance = nameOfInstance;
		this.template = template;
	}

	public <Result> Result getNameOfInstance() {
		return (Result) nameOfInstance;
	}
	public <Result> Result getTemplate() {
		return (Result) template;
	}
	public void setNameOfInstance(Object nameOfInstance) {
		this.nameOfInstance = nameOfInstance;
	}
	public void setTemplate(Statement template) {
		this.template = template;
	}

	@Override
	protected Statement callImpl(Statement... parameters) throws Exception {
		Statement original = null;
		if (parameters.length > 0) {
			original = parameters[0];
		}

		Object instancename = null;
		if (nameOfInstance == null) {
			instancename = template.getNameOfInstance();
		} else {
			instancename = nameOfInstance;
		}
		if (instancename != null) {
			if (instancename instanceof Callable) {
				instancename = ((Callable) instancename).call(original);
			} else if (!(instancename instanceof Statement)) {
				instancename = RuleSelect.select(original, instancename, true);
			}
		}

		// if (nameOfInstance instanceof String) {
		// getLog().error("remove me");
		// }

		Statement result = new Statement(template.getIdentifier(), (Statement) instancename);

		return result;

	}

	@Override
	public String toString() {
		return "Create statement " + template.getIdentifier() + " with name " + nameOfInstance;
	}
}
