package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Relation;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;

public class RuleTransformation extends CallableAbstraction<RuleContext<Statement>, Statement> {

	private Object statementCreatorRule;
	private Object[] variableRules;
	private Object nameRule;


	private RuleTransformation() {
	}

	public RuleTransformation(Object statementCreatorRule, Object... variableRules) {
		this.statementCreatorRule = statementCreatorRule;
		this.variableRules = variableRules;
	}

	public static RuleTransformation createWithName(Object statementCreatorRule, Object nameRule, Object... variableRules) {
		RuleTransformation result = new RuleTransformation(statementCreatorRule, variableRules);
		result.nameRule = nameRule;
		return result;
	}


	public static RuleTransformation create(Object[] statementAndVariables) {
		Object[] variableRules = {};
		if (statementAndVariables.length > 1) {
			variableRules = Arrays.copyOfRange(statementAndVariables, 1, statementAndVariables.length);
		}
		return new RuleTransformation(statementAndVariables[0], variableRules);
	}

	private void checkBreakpoint(Statement toCheck) {
		Statement breakpoint = Relation.HOMOGENOUS_RELATION;
		if (breakpoint == null) {
			// nothing to do
		} else {
			if (breakpoint.is(toCheck)) {
				getLog().debug("breakpoint");
			}
		}

	}

	@Override
	protected Statement callImpl(RuleContext<Statement>... maxOneContext) throws Exception {

		Statement toTransform = null;
		RuleContext<Statement> context = null;
		if (maxOneContext.length > 0) {
			context = maxOneContext[0];
			if (context != null) {
				toTransform = context.getToTransform();
			}
		}

		boolean displayIdentifyingName = false;
		if (toTransform != null) {
			displayIdentifyingName = toTransform.isDisplayIdentifyingName();
		}


		checkBreakpoint(toTransform);
		Callable<Statement, Statement> trafoRule;

		if (statementCreatorRule instanceof Statement) {
			trafoRule = new RuleStatementCreator((Statement) statementCreatorRule);
		} else {
			trafoRule = (Callable) statementCreatorRule;
		}
		Statement result = trafoRule.call(toTransform);

		ArrayList<Statement> variables = new ArrayList<Statement>();
		for (int i = 0; i < variableRules.length; i++) {
			Object variable = useRule(variableRules[i], displayIdentifyingName, toTransform, context);

			// Object variable;// will be a statement or a collection of statements
			//
			// Object rule = variableRules[i];
			// if (rule == null) {
			// variable = null;
			// } else if (rule.getClass().isArray()) {
			//
			// if (displayIdentifyingName) {
			// // change this for nested calls, because otherwise the name will be displayed multiple times
			// toTransform.setDisplayIdentifyingName(false);
			// }
			//
			// variable = create((Object[]) rule).call(context);
			//
			// if (displayIdentifyingName) {
			// // change back
			// toTransform.setDisplayIdentifyingName(true);
			// }
			//
			// } else {
			// variable = RuleSelect.select(toTransform, rule, true);
			// }
			if (variable == null || variable instanceof Statement) {
				variables.add((Statement) variable);
			} else if (variable instanceof Collection) {
				variables.addAll((Collection) variable);
			}
		}

		result.setVariables(variables);

		if (nameRule != null) {
			result.setNameOfInstance((Statement) useRule(nameRule, false, toTransform, context));
		}

		if (displayIdentifyingName) {
				result = Basics.blankSeparated(result, Basics.defNames(toTransform));
		}

		return result;

	}

	private Object useRule(Object rule, boolean displayIdentifyingName, Statement toTransform, RuleContext<Statement> context) throws Exception {
		Object variable;// will be a statement or a collection of statements

		if (rule == null) {
			variable = null;
		} else if (rule.getClass().isArray()) {

			if (displayIdentifyingName) {
				// change this for nested calls, because otherwise the name will be displayed multiple times
				toTransform.setDisplayIdentifyingName(false);
			}

			variable = create((Object[]) rule).call(context);

			if (displayIdentifyingName) {
				// change back
				toTransform.setDisplayIdentifyingName(true);
			}

		} else {
			variable = RuleSelect.select(toTransform, rule, true);
		}

		return variable;

	}


	@Override
	public String toString() {
		return getClass().getSimpleName() + ": " + statementCreatorRule + " " + Arrays.asList(variableRules);
	}
}
