package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.ResourceBundle;

import javax.naming.CompoundName;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.basic.container.BoostedListResourceBundle;
import net.sf.gluebooster.java.booster.basic.container.HierarchicalResourceBundle;
import net.sf.gluebooster.java.booster.essentials.utils.Check;

public class StudyResourceBundle extends HierarchicalResourceBundle {

	private static final String ID_SEPARATOR = Statement.INDENTIFIER_SEPARATOR;

	public StudyResourceBundle(ResourceBundle backend) {
		super(backend, ID_SEPARATOR, 1);
	}

	public StudyResourceBundle(Object[][] listResources) {
		this(new BoostedListResourceBundle(listResources));
	}

	protected static String id(Statement statement, int maxLength) {
		Check.notNull(statement, "statement");
		CompoundName identifying = statement.getIdentifyingName();
		if (identifying == null) {
			throw new IllegalStateException("statement.getIdentifyingName() == null");
		}
		return getKeypartOfMaxLength(identifying.toString(), maxLength, ID_SEPARATOR);
	}

	public static String id2(Statement statement) {
		return id(statement, 2);
	}

	protected static String id3(Statement statement) {
		return id(statement, 3);
	}

}
