package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;

public class StudyUnit {

	private Statements origin;
	private String name;

	/**
	 * The main statements of this unit;
	 */
	private List<Statement> statements;

	/**
	 * Additional statements that are needed because of technical reasons. These statement should not be displayed, but may be needed for automated proof
	 * generation.
	 */
	private List<Statement> unimportantStatements;

	private StudyUnit() {
	}

	public StudyUnit(Statements unit, int part, /* String name, */ List<Statement> statements, List<Statement> unimportantStatements) {
		origin = unit;
		this.name = unit.unit(part);
		this.statements = statements;
		this.unimportantStatements = unimportantStatements;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List<Statement> getStatements() {
		return statements;
	}

	public void setStatements(List<Statement> statements) {
		this.statements = statements;
	}

	@Override
	public String toString() {

		return name;
	}

	public List<Statement> getUnimportantStatements() {
		return unimportantStatements;
	}

	public void setUnimportantStatements(List<Statement> unimportantStatements) {
		this.unimportantStatements = unimportantStatements;
	}

	public Statements getOrigin() {
		return origin;
	}

	public void setOrigin(Statements origin) {
		this.origin = origin;
	}

}
