package net.sf.gluebooster.demos.pojo.math.studies;

import java.lang.reflect.Array;
import java.util.Collection;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.basic.meta.DocumentationContext;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.utils.DomBoostUtils;

public class TextWithMathMLGenerator extends CallableAbstraction<Object, Node> {

	private MathMLGenerator mathMLGenerator;

	private TextWithMathMLGenerator() {
		mathMLGenerator = new MathMLGenerator();
	}

	public TextWithMathMLGenerator(DocumentationContext contextWithLanguage) {
		mathMLGenerator = new MathMLGenerator(contextWithLanguage);
	}
	/**
	 * @param parameters
	 *            Document, parentNode, statements or text
	 * @param return
	 *            the parentNode
	 */
	@Override
	protected Node callImpl(Object... parameters) throws Exception {

		Document doc = (Document) parameters[0];
		Node parent = (Node) parameters[1];
		Object elementsToChange = parameters[2];
		// StringBuilder result = new StringBuilder();
		callWith(doc, parent, elementsToChange);
		return parent;
	}

	private void callWith(Document doc, Node parent, Object parameter) throws Exception {
		if (parameter == null) {
			// nothing to do
		} else if (parameter instanceof Collection) {

			for (Object param : ((Collection) parameter)) {
				callWith(doc, parent, param);
			}
		} else if (parameter.getClass().isArray()) {
			int size = Array.getLength(parameter);
			for (int i = 0; i < size; i++) {
				callWith(doc, parent, Array.get(parameter, i));
			}

		} else if (parameter instanceof Statement) {
			mathMLGenerator.call(doc, parent, (Statement) parameter);
		} else {
			if (parameter != null) {
				DomBoostUtils.appendText(doc, parent, parameter.toString());
			}
		}
	}

}
