package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.Arrays;

import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;

public class WriteAfterStatementTransformation extends Write {

	private Callable<RuleContext<Statement>, Statement> transformation;

	private Callable<RuleContext<Statement>, Node> writer;

	private WriteAfterStatementTransformation() {
	}

	public WriteAfterStatementTransformation(Callable<RuleContext<Statement>, Statement> transformation) {
		this.transformation = transformation;
	}

	public WriteAfterStatementTransformation(Callable<RuleContext<Statement>, Statement> transformation, Callable<RuleContext<Statement>, Node> writer) {
		this.transformation = transformation;
		this.writer = writer;
	}

	public static WriteAfterStatementTransformation selectThenWrite(Callable<Statement, Statement> transformation,
			Callable<RuleContext<Statement>, Node> writer) {
		return new WriteAfterStatementTransformation(new RuleContextSelect(transformation), writer);
	}

	public static WriteAfterStatementTransformation ruleTransformation(Object[] statementCreatorRuleAndVariableRules) {
		Object statementCreatorRule = statementCreatorRuleAndVariableRules[0];
		Object[] variableRules = {};
		if (statementCreatorRuleAndVariableRules.length > 1) {
			variableRules = Arrays.copyOfRange(statementCreatorRuleAndVariableRules, 1, statementCreatorRuleAndVariableRules.length);
		}
		return ruleTransformation(statementCreatorRule, variableRules);

	}

	public static WriteAfterStatementTransformation ruleTransformation(Object statementCreatorRule, Object... variableRules) {
		return new WriteAfterStatementTransformation(new RuleTransformation(statementCreatorRule, variableRules));
	}

	public static WriteAfterStatementTransformation ruleTransformationWithName(Object statementCreatorRule,Object nameRule, Object... variableRules) {
		return new WriteAfterStatementTransformation(RuleTransformation.createWithName(statementCreatorRule, nameRule, variableRules));
	}

	@Override
	protected Node callImpl(RuleContext<Statement>... parameters) throws Exception {
		RuleContext<Statement> context = parameters[0];

		Statement transformed = transformation.call(context);

		RuleContext<Statement> newContext = context.cloneMe(transformed);
		if (writer == null) {
			return context.getMathMlGenerator().callWith(newContext);
		} else {
			return writer.call(newContext);
		}

	}

}
