package net.sf.gluebooster.demos.pojo.math.studies;

import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.utils.Check;

/**
 * Writes extended or short variants.
 * 
 * @author cbauer
 *
 */
public class WriteExtended extends Write {

	private Callable<RuleContext<Statement>, Node>[] variants;

	private WriteExtended() {
	}

	private WriteExtended(Callable<RuleContext<Statement>, Node>... variantsFromShortDefaultExtended) {
		variants = variantsFromShortDefaultExtended;
	}

	public static WriteExtended defaultExtended(Callable<RuleContext<Statement>, Node> defaultVariant,
			Callable<RuleContext<Statement>, Node> extendedVariant) {
		Check.notNull(defaultVariant, "defaultVariant");
		WriteExtended result = new WriteExtended(null, defaultVariant, extendedVariant);
		return result;
	}


	public static WriteExtended shortDefault(Callable<RuleContext<Statement>, Node>... shortDefaultOptionalExtendedVariant) {
		Check.notNull(shortDefaultOptionalExtendedVariant[0], "shortVariant");
		Check.notNull(shortDefaultOptionalExtendedVariant[1], "defaultVariant");
		WriteExtended result = new WriteExtended(shortDefaultOptionalExtendedVariant);
		return result;
	}


	/**
	 * @return the parent;
	 */
	@Override
	protected Node callImpl(RuleContext<Statement>... parameters) throws Exception {
		RuleContext<Statement> context = parameters[0];
		Statement statement = context.getToTransform();


		Callable<RuleContext<Statement>, Node> used = null;
		int displayLevel = statement.getDisplayLevel();

		used = getVariant(displayLevel);
		// if (variants.length >= displayLevel) {
		// used = variants[displayLevel];
		// }

		if (used == null) {
			used = variants[Statements.DEFAULT]; // TODO get something nearer to the display level
		}

		Check.notNull(used, "used");
		return used.call(context);

	}

	/**
	 * Gets the variant of (or nearest [from lower] to) the display level.
	 * 
	 * @param displayLevel
	 * @return
	 */
	private Callable<RuleContext<Statement>, Node> getVariant(int displayLevel) {
		Callable<RuleContext<Statement>, Node> used = null;

		if (displayLevel > -1) {

			if (variants.length > displayLevel) {
				used = variants[displayLevel];
			}

			if (used == null) {
				used = getVariant(displayLevel - 1);
			}
		}

		return used;

	}

}
