package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;

/**
 * Writes multiple parts.
 * 
 * @author cbauer
 *
 */
public class WriteMulti extends Write {

	private Object[] parts;

	private WriteMulti() {
	}

	public WriteMulti(Object... parts) {
		this.parts = parts;
	}




	/**
	 * @return the parent;
	 */
	@Override
	protected Node callImpl(RuleContext<Statement>... parameters) throws Exception {
		RuleContext<Statement> context = parameters[0];
		Node parent = context.getParent();
		boolean mathmlResultNeeded = context.isMathmlResultNeeded();
		Document doc = context.getDoc();
		MathMLGenerator mathml = context.getMathMlGenerator();
		Statement statement = context.getToTransform();
		Statement original = context.getOriginal();

		for (Object part : parts) {
			if (part instanceof Write) {
				((Write) part).call(context);
			} else {
				mathml.callWith(context.cloneMe(RuleSelect.select(statement, part, false)));
			}

		}

		return parent;
	}

}
