package net.sf.gluebooster.demos.pojo.math.studies;

import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;

/**
 * Rule for operations with prefix, infix, suffix.
 * 
 * @author cbauer
 *
 */
public class WriteOperation extends Write {

	private Object prefix;
	/**
	 * There may be multiple infixes (all below the same parent)
	 */
	private Object[] infix;
	private Object suffix;

	private WriteOperation() {
	}

	public WriteOperation(Object infix) {
		setInfix(infix);
	}

	public WriteOperation(Object prefix, Object infix, Object suffix) {
		this.prefix = prefix;
		setInfix(infix);
		this.suffix = suffix;
	}

	public static WriteOperation prefix(Object prefix) {
		return new WriteOperation(prefix, null, null);
	}

	public static WriteOperation suffix(Object suffix) {
		return new WriteOperation(null, null, suffix);
	}

	public Object getPrefix() {
		return prefix;
	}

	public void setPrefix(Object prefix) {
		this.prefix = prefix;
	}

	public Object[] getInfix() {
		return infix;
	}

	public void setInfix(Object infix) {
		if (infix != null) {
			if (infix instanceof Object[]) {
				this.infix = (Object[]) infix;
			} else {
				this.infix = new Object[] { infix };
			}
		} else {
			this.infix = null;
		}

	}

	public Object getSuffix() {
		return suffix;
	}

	public void setSuffix(Object suffix) {
		this.suffix = suffix;
	}

	@Override
	protected Node callImpl(RuleContext<Statement>... parameters) throws Exception {
		RuleContext<Statement> context = parameters[0];
		Node parent = context.getParent();
		boolean mathmlResultNeeded = true; // context.isMathmlResultNeeded();
		Document doc = context.getDoc();
		MathMLGenerator mathml = context.getMathMlGenerator();

		/*
		 * Document doc, Node parent, Map.Entry<Statement, Object[]> operation, List<Statement> args, boolean mathmlResultNeeded
		 */
		List<Statement> args = context.getToTransform().getVariables();
		if (args.isEmpty()) {
			int nullCounter = ContainerBoostUtils.countNulls(prefix, infix, suffix);

			if (nullCounter == 0) {
				return null; // nothing appended
			}

			int notNull = 3 - nullCounter;

			if (notNull > 1) {
				parent = mathml.addNestedElements(doc, parent, null, null, GraphElementDescription.createNestedParentElements(Mrow.ELEMENT));
				mathmlResultNeeded = false; // because the mathml mrow will be returned
			}

			Node first = mathml.callWith(new RuleContext(doc, parent, prefix, null, mathmlResultNeeded, mathml));
			Node second = null;
			if (infix != null) {
				for (Object inf : infix) {
					second = mathml.callWith(new RuleContext(doc, parent, inf, null, mathmlResultNeeded, mathml));
				}
			}

			Node third = mathml.callWith(new RuleContext(doc, parent, suffix, null, mathmlResultNeeded, mathml));

			if (notNull > 1) {
				return parent;
			} else {
				if (prefix != null) {
					return first;
				} else if (infix != null) {
					return second;
				} else { // if (suffix != null) {
					return third;
				}
			}
		} else {// args not empty

			GraphElementDescription operationReference = null;
			// GraphElementDescription.createReference(operation.getKey());
			// not yet supported because of too much unnecessary tags

			// if no prefix and suffix and only 1 arg, then the infix can be ignored and only the arg needs to be printed
			if (prefix == null && suffix == null && args.size() == 1) {
				return mathml.callWith(new RuleContext(doc, parent, args.get(0), null, mathmlResultNeeded, mathml));
			}

			Object[] elements;
			Integer elementsIndex = null;

			parent = mathml.addNestedElements(doc, parent, null, null, GraphElementDescription.createNestedParentElements(Mrow.ELEMENT));
			if (prefix == null) {
				elements = null; // new Object[]{GraphElementDescription.createNestedParentElements(Mrow.ELEMENT)};
			} else if (prefix instanceof String) {
				elements = new Object[] { operationReference, Mo.ELEMENT, prefix };
				elementsIndex = 0; // the mrow
			} else {
				elements = new Object[] { prefix };
			}

			if (elements != null) {
				parent = mathml.addNestedElements(doc, parent, elementsIndex, null, elements);
			}

			boolean first = true;
			for (Object arg : args) {
				Node newParent = parent;

				if (infix == null || arg == null) {// null args should only be used for internal computations
					// nothing to do
				} else if (!first) { // before the first argument no infix is needed
					for (Object inf : infix) {
						if (inf instanceof String) {
							mathml.addNestedElements(doc, parent, null, null, operationReference, Mo.ELEMENT, inf);
						} else {
							newParent = mathml.addNestedElements(doc, parent, null, null, operationReference, inf);
						}
					}
				}
				first = false;
				mathml.callWith(new RuleContext(doc, newParent, arg, context.getOriginal(), false, mathml));
			}

			if (suffix == null) {
				// nothing to do
			} else if (suffix instanceof String) {
				mathml.addNestedElements(doc, parent, null, null, operationReference, Mo.ELEMENT, suffix);
			} else {
				mathml.addNestedElements(doc, parent, null, null, operationReference, suffix);
			}

			return parent;
		}
	}

}
